/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import java.util.ArrayList;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.IRecipeComplex;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.World;

public class RecipeFireworks
extends IRecipeComplex {
    private static final RecipeItemStack PAPER_INGREDIENT = RecipeItemStack.of(Items.PAPER);
    private static final RecipeItemStack GUNPOWDER_INGREDIENT = RecipeItemStack.of(Items.GUNPOWDER);
    private static final RecipeItemStack STAR_INGREDIENT = RecipeItemStack.of(Items.FIREWORK_STAR);

    public RecipeFireworks(CraftingBookCategory var0) {
        super(var0);
    }

    @Override
    public boolean matches(CraftingInput var0, World var1) {
        boolean var2 = false;
        int var3 = 0;
        for (int var4 = 0; var4 < var0.size(); ++var4) {
            ItemStack var5 = var0.getItem(var4);
            if (var5.isEmpty()) continue;
            if (PAPER_INGREDIENT.test(var5)) {
                if (var2) {
                    return false;
                }
                var2 = true;
                continue;
            }
            if (!(GUNPOWDER_INGREDIENT.test(var5) ? ++var3 > 3 : !STAR_INGREDIENT.test(var5))) continue;
            return false;
        }
        return var2 && var3 >= 1;
    }

    @Override
    public ItemStack assemble(CraftingInput var0, HolderLookup.a var1) {
        ArrayList<FireworkExplosion> var2 = new ArrayList<FireworkExplosion>();
        int var3 = 0;
        for (int var4 = 0; var4 < var0.size(); ++var4) {
            FireworkExplosion var6;
            ItemStack var5 = var0.getItem(var4);
            if (var5.isEmpty()) continue;
            if (GUNPOWDER_INGREDIENT.test(var5)) {
                ++var3;
                continue;
            }
            if (!STAR_INGREDIENT.test(var5) || (var6 = var5.get(DataComponents.FIREWORK_EXPLOSION)) == null) continue;
            var2.add(var6);
        }
        ItemStack var4 = new ItemStack(Items.FIREWORK_ROCKET, 3);
        var4.set(DataComponents.FIREWORKS, new Fireworks(var3, var2));
        return var4;
    }

    @Override
    public boolean canCraftInDimensions(int var0, int var1) {
        return var0 * var1 >= 2;
    }

    @Override
    public ItemStack getResultItem(HolderLookup.a var0) {
        return new ItemStack(Items.FIREWORK_ROCKET);
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializer.FIREWORK_ROCKET;
    }
}

