/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.AutoRecipeStackManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.IMaterial;

public final class RecipeItemStack
implements Predicate<ItemStack> {
    public static final RecipeItemStack EMPTY = new RecipeItemStack(Stream.empty());
    public static final StreamCodec<RegistryFriendlyByteBuf, RecipeItemStack> CONTENTS_STREAM_CODEC = ItemStack.LIST_STREAM_CODEC.map(list -> RecipeItemStack.fromValues(list.stream().map(StackProvider::new)), recipeitemstack -> Arrays.asList(recipeitemstack.getItems()));
    private final Provider[] values;
    @Nullable
    public ItemStack[] itemStacks;
    @Nullable
    private IntList stackingIds;
    public boolean exact;
    public static final Codec<RecipeItemStack> CODEC = RecipeItemStack.codec(true);
    public static final Codec<RecipeItemStack> CODEC_NONEMPTY = RecipeItemStack.codec(false);

    public RecipeItemStack(Stream<? extends Provider> stream) {
        this.values = (Provider[])stream.toArray(Provider[]::new);
    }

    private RecipeItemStack(Provider[] arecipeitemstack_provider) {
        this.values = arecipeitemstack_provider;
    }

    public ItemStack[] getItems() {
        if (this.itemStacks == null) {
            this.itemStacks = (ItemStack[])Arrays.stream(this.values).flatMap(recipeitemstack_provider -> recipeitemstack_provider.getItems().stream()).distinct().toArray(ItemStack[]::new);
        }
        return this.itemStacks;
    }

    @Override
    public boolean test(@Nullable ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        if (this.isEmpty()) {
            return itemstack.isEmpty();
        }
        for (ItemStack itemstack1 : this.getItems()) {
            if (!(this.exact ? itemstack1.getItem() == itemstack.getItem() && ItemStack.isSameItemSameComponents(itemstack, itemstack1) : itemstack1.is(itemstack.getItem()))) continue;
            return true;
        }
        return false;
    }

    public IntList getStackingIds() {
        if (this.stackingIds == null) {
            ItemStack[] aitemstack = this.getItems();
            this.stackingIds = new IntArrayList(aitemstack.length);
            ItemStack[] aitemstack1 = aitemstack;
            int i2 = aitemstack.length;
            for (int j2 = 0; j2 < i2; ++j2) {
                ItemStack itemstack = aitemstack1[j2];
                this.stackingIds.add(AutoRecipeStackManager.getStackingIndex(itemstack));
            }
            this.stackingIds.sort(IntComparators.NATURAL_COMPARATOR);
        }
        return this.stackingIds;
    }

    public boolean isEmpty() {
        return this.values.length == 0;
    }

    public boolean equals(Object object) {
        if (object instanceof RecipeItemStack) {
            RecipeItemStack recipeitemstack = (RecipeItemStack)object;
            return Arrays.equals(this.values, recipeitemstack.values);
        }
        return false;
    }

    private static RecipeItemStack fromValues(Stream<? extends Provider> stream) {
        RecipeItemStack recipeitemstack = new RecipeItemStack(stream);
        return recipeitemstack.isEmpty() ? EMPTY : recipeitemstack;
    }

    public static RecipeItemStack of() {
        return EMPTY;
    }

    public static RecipeItemStack of(IMaterial ... aimaterial) {
        return RecipeItemStack.of(Arrays.stream(aimaterial).map(ItemStack::new));
    }

    public static RecipeItemStack of(ItemStack ... aitemstack) {
        return RecipeItemStack.of(Arrays.stream(aitemstack));
    }

    public static RecipeItemStack of(Stream<ItemStack> stream) {
        return RecipeItemStack.fromValues(stream.filter(itemstack -> !itemstack.isEmpty()).map(StackProvider::new));
    }

    public static RecipeItemStack of(TagKey<Item> tagkey) {
        return RecipeItemStack.fromValues(Stream.of(new b(tagkey)));
    }

    private static Codec<RecipeItemStack> codec(boolean flag) {
        Codec codec = Codec.list(Provider.CODEC).comapFlatMap(list -> !flag && list.size() < 1 ? DataResult.error(() -> "Item array cannot be empty, at least one item must be defined") : DataResult.success((Object)list.toArray(new Provider[0])), List::of);
        return Codec.either((Codec)codec, Provider.CODEC).flatComapMap(either -> (RecipeItemStack)either.map(RecipeItemStack::new, recipeitemstack_provider -> new RecipeItemStack(new Provider[]{recipeitemstack_provider})), recipeitemstack -> recipeitemstack.values.length == 1 ? DataResult.success((Object)Either.right((Object)recipeitemstack.values[0])) : (recipeitemstack.values.length == 0 && !flag ? DataResult.error(() -> "Item array cannot be empty, at least one item must be defined") : DataResult.success((Object)Either.left((Object)recipeitemstack.values))));
    }

    public static interface Provider {
        public static final Codec<Provider> CODEC = Codec.xor(StackProvider.CODEC, b.CODEC).xmap(either -> (Provider)either.map(recipeitemstack_stackprovider -> recipeitemstack_stackprovider, recipeitemstack_b -> recipeitemstack_b), recipeitemstack_provider -> {
            if (recipeitemstack_provider instanceof b) {
                b recipeitemstack_b = (b)recipeitemstack_provider;
                return Either.right((Object)recipeitemstack_b);
            }
            if (recipeitemstack_provider instanceof StackProvider) {
                StackProvider recipeitemstack_stackprovider = (StackProvider)recipeitemstack_provider;
                return Either.left((Object)recipeitemstack_stackprovider);
            }
            throw new UnsupportedOperationException("This is neither an item value nor a tag value.");
        });

        public Collection<ItemStack> getItems();
    }

    private record b(TagKey<Item> tag) implements Provider
    {
        static final Codec<b> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TagKey.codec(Registries.ITEM).fieldOf("tag").forGetter(recipeitemstack_b -> recipeitemstack_b.tag)).apply((Applicative)instance, b::new));

        @Override
        public boolean equals(Object object) {
            if (object instanceof b) {
                b recipeitemstack_b = (b)object;
                return recipeitemstack_b.tag.location().equals(this.tag.location());
            }
            return false;
        }

        @Override
        public Collection<ItemStack> getItems() {
            ArrayList list = Lists.newArrayList();
            for (Holder<Item> holder : BuiltInRegistries.ITEM.getTagOrEmpty(this.tag)) {
                list.add(new ItemStack(holder));
            }
            return list;
        }
    }

    public record StackProvider(ItemStack item) implements Provider
    {
        static final Codec<StackProvider> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.SIMPLE_ITEM_CODEC.fieldOf("item").forGetter(recipeitemstack_stackprovider -> recipeitemstack_stackprovider.item)).apply((Applicative)instance, StackProvider::new));

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof StackProvider)) {
                return false;
            }
            StackProvider recipeitemstack_stackprovider = (StackProvider)object;
            return recipeitemstack_stackprovider.item.getItem().equals(this.item.getItem()) && recipeitemstack_stackprovider.item.getCount() == this.item.getCount();
        }

        @Override
        public Collection<ItemStack> getItems() {
            return Collections.singleton(this.item);
        }
    }
}

