/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDye;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.IRecipeComplex;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockShulkerBox;

public class RecipeShulkerBox
extends IRecipeComplex {
    public RecipeShulkerBox(CraftingBookCategory var0) {
        super(var0);
    }

    @Override
    public boolean matches(CraftingInput var0, World var1) {
        int var2 = 0;
        int var3 = 0;
        for (int var4 = 0; var4 < var0.size(); ++var4) {
            ItemStack var5 = var0.getItem(var4);
            if (var5.isEmpty()) continue;
            if (Block.byItem(var5.getItem()) instanceof BlockShulkerBox) {
                ++var2;
            } else if (var5.getItem() instanceof ItemDye) {
                ++var3;
            } else {
                return false;
            }
            if (var3 <= 1 && var2 <= 1) continue;
            return false;
        }
        return var2 == 1 && var3 == 1;
    }

    @Override
    public ItemStack assemble(CraftingInput var0, HolderLookup.a var1) {
        ItemStack var2 = ItemStack.EMPTY;
        ItemDye var3 = (ItemDye)Items.WHITE_DYE;
        for (int var4 = 0; var4 < var0.size(); ++var4) {
            ItemStack var5 = var0.getItem(var4);
            if (var5.isEmpty()) continue;
            Item var6 = var5.getItem();
            if (Block.byItem(var6) instanceof BlockShulkerBox) {
                var2 = var5;
                continue;
            }
            if (!(var6 instanceof ItemDye)) continue;
            var3 = (ItemDye)var6;
        }
        Block var4 = BlockShulkerBox.getBlockByColor(var3.getDyeColor());
        return var2.transmuteCopy(var4, 1);
    }

    @Override
    public boolean canCraftInDimensions(int var0, int var1) {
        return var0 * var1 >= 2;
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializer.SHULKER_BOX_COLORING;
    }
}

