/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeCrafting;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.World;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftRecipe;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftShapedRecipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;

public class ShapedRecipes
implements RecipeCrafting {
    final ShapedRecipePattern pattern;
    final ItemStack result;
    final String group;
    final CraftingBookCategory category;
    final boolean showNotification;

    public ShapedRecipes(String s2, CraftingBookCategory craftingbookcategory, ShapedRecipePattern shapedrecipepattern, ItemStack itemstack, boolean flag) {
        this.group = s2;
        this.category = craftingbookcategory;
        this.pattern = shapedrecipepattern;
        this.result = itemstack;
        this.showNotification = flag;
    }

    public ShapedRecipes(String s2, CraftingBookCategory craftingbookcategory, ShapedRecipePattern shapedrecipepattern, ItemStack itemstack) {
        this(s2, craftingbookcategory, shapedrecipepattern, itemstack, true);
    }

    public ShapedRecipe toBukkitRecipe(NamespacedKey id) {
        CraftItemStack result = CraftItemStack.asCraftMirror(this.result);
        CraftShapedRecipe recipe = new CraftShapedRecipe(id, result, this);
        recipe.setGroup(this.group);
        recipe.setCategory(CraftRecipe.getCategory(this.category()));
        block0 : switch (this.pattern.height()) {
            case 1: {
                switch (this.pattern.width()) {
                    case 1: {
                        recipe.shape(new String[]{"a"});
                        break;
                    }
                    case 2: {
                        recipe.shape(new String[]{"ab"});
                        break;
                    }
                    case 3: {
                        recipe.shape(new String[]{"abc"});
                    }
                }
                break;
            }
            case 2: {
                switch (this.pattern.width()) {
                    case 1: {
                        recipe.shape(new String[]{"a", "b"});
                        break;
                    }
                    case 2: {
                        recipe.shape(new String[]{"ab", "cd"});
                        break;
                    }
                    case 3: {
                        recipe.shape(new String[]{"abc", "def"});
                    }
                }
                break;
            }
            case 3: {
                switch (this.pattern.width()) {
                    case 1: {
                        recipe.shape(new String[]{"a", "b", "c"});
                        break block0;
                    }
                    case 2: {
                        recipe.shape(new String[]{"ab", "cd", "ef"});
                        break block0;
                    }
                    case 3: {
                        recipe.shape(new String[]{"abc", "def", "ghi"});
                    }
                }
            }
        }
        char c2 = 'a';
        for (RecipeItemStack list : this.pattern.ingredients()) {
            RecipeChoice choice = CraftRecipe.toBukkit(list);
            if (choice != null) {
                recipe.setIngredient(c2, choice);
            }
            c2 = (char)(c2 + 1);
        }
        return recipe;
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializer.SHAPED_RECIPE;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public CraftingBookCategory category() {
        return this.category;
    }

    @Override
    public ItemStack getResultItem(HolderLookup.a holderlookup_a) {
        return this.result;
    }

    @Override
    public NonNullList<RecipeItemStack> getIngredients() {
        return this.pattern.ingredients();
    }

    @Override
    public boolean showNotification() {
        return this.showNotification;
    }

    @Override
    public boolean canCraftInDimensions(int i2, int j2) {
        return i2 >= this.pattern.width() && j2 >= this.pattern.height();
    }

    @Override
    public boolean matches(CraftingInput craftinginput, World world) {
        return this.pattern.matches(craftinginput);
    }

    @Override
    public ItemStack assemble(CraftingInput craftinginput, HolderLookup.a holderlookup_a) {
        return this.getResultItem(holderlookup_a).copy();
    }

    public int getWidth() {
        return this.pattern.width();
    }

    public int getHeight() {
        return this.pattern.height();
    }

    @Override
    public boolean isIncomplete() {
        NonNullList<RecipeItemStack> nonnulllist = this.getIngredients();
        return nonnulllist.isEmpty() || nonnulllist.stream().filter(recipeitemstack -> !recipeitemstack.isEmpty()).anyMatch(recipeitemstack -> recipeitemstack.getItems().length == 0);
    }

    public static class Serializer
    implements RecipeSerializer<ShapedRecipes> {
        public static final MapCodec<ShapedRecipes> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(shapedrecipes -> shapedrecipes.group), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(shapedrecipes -> shapedrecipes.category), (App)ShapedRecipePattern.MAP_CODEC.forGetter(shapedrecipes -> shapedrecipes.pattern), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(shapedrecipes -> shapedrecipes.result), (App)Codec.BOOL.optionalFieldOf("show_notification", (Object)true).forGetter(shapedrecipes -> shapedrecipes.showNotification)).apply((Applicative)instance, ShapedRecipes::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ShapedRecipes> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        @Override
        public MapCodec<ShapedRecipes> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, ShapedRecipes> streamCodec() {
            return STREAM_CODEC;
        }

        private static ShapedRecipes fromNetwork(RegistryFriendlyByteBuf registryfriendlybytebuf) {
            String s2 = registryfriendlybytebuf.readUtf();
            CraftingBookCategory craftingbookcategory = registryfriendlybytebuf.readEnum(CraftingBookCategory.class);
            ShapedRecipePattern shapedrecipepattern = (ShapedRecipePattern)ShapedRecipePattern.STREAM_CODEC.decode(registryfriendlybytebuf);
            ItemStack itemstack = (ItemStack)ItemStack.STREAM_CODEC.decode(registryfriendlybytebuf);
            boolean flag = registryfriendlybytebuf.readBoolean();
            return new ShapedRecipes(s2, craftingbookcategory, shapedrecipepattern, itemstack, flag);
        }

        private static void toNetwork(RegistryFriendlyByteBuf registryfriendlybytebuf, ShapedRecipes shapedrecipes) {
            registryfriendlybytebuf.writeUtf(shapedrecipes.group);
            registryfriendlybytebuf.writeEnum(shapedrecipes.category);
            ShapedRecipePattern.STREAM_CODEC.encode(registryfriendlybytebuf, shapedrecipes.pattern);
            ItemStack.STREAM_CODEC.encode(registryfriendlybytebuf, shapedrecipes.result);
            registryfriendlybytebuf.writeBoolean(shapedrecipes.showNotification);
        }
    }
}

