/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeCrafting;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.World;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftRecipe;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftShapelessRecipe;
import org.bukkit.inventory.ShapelessRecipe;

public class ShapelessRecipes
implements RecipeCrafting {
    final String group;
    final CraftingBookCategory category;
    final ItemStack result;
    final NonNullList<RecipeItemStack> ingredients;

    public ShapelessRecipes(String s2, CraftingBookCategory craftingbookcategory, ItemStack itemstack, NonNullList<RecipeItemStack> nonnulllist) {
        this.group = s2;
        this.category = craftingbookcategory;
        this.result = itemstack;
        this.ingredients = nonnulllist;
    }

    public ShapelessRecipe toBukkitRecipe(NamespacedKey id) {
        CraftItemStack result = CraftItemStack.asCraftMirror(this.result);
        CraftShapelessRecipe recipe = new CraftShapelessRecipe(id, result, this);
        recipe.setGroup(this.group);
        recipe.setCategory(CraftRecipe.getCategory(this.category()));
        for (RecipeItemStack list : this.ingredients) {
            recipe.addIngredient(CraftRecipe.toBukkit(list));
        }
        return recipe;
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializer.SHAPELESS_RECIPE;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public CraftingBookCategory category() {
        return this.category;
    }

    @Override
    public ItemStack getResultItem(HolderLookup.a holderlookup_a) {
        return this.result;
    }

    @Override
    public NonNullList<RecipeItemStack> getIngredients() {
        return this.ingredients;
    }

    @Override
    public boolean matches(CraftingInput craftinginput, World world) {
        return craftinginput.ingredientCount() != this.ingredients.size() ? false : (craftinginput.size() == 1 && this.ingredients.size() == 1 ? ((RecipeItemStack)this.ingredients.getFirst()).test(craftinginput.getItem(0)) : craftinginput.stackedContents().canCraft(this, null));
    }

    @Override
    public ItemStack assemble(CraftingInput craftinginput, HolderLookup.a holderlookup_a) {
        return this.result.copy();
    }

    @Override
    public boolean canCraftInDimensions(int i2, int j2) {
        return i2 * j2 >= this.ingredients.size();
    }

    public static class a
    implements RecipeSerializer<ShapelessRecipes> {
        private static final MapCodec<ShapelessRecipes> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(shapelessrecipes -> shapelessrecipes.group), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(shapelessrecipes -> shapelessrecipes.category), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(shapelessrecipes -> shapelessrecipes.result), (App)RecipeItemStack.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(list -> {
            RecipeItemStack[] arecipeitemstack = (RecipeItemStack[])list.stream().filter(recipeitemstack -> !recipeitemstack.isEmpty()).toArray(RecipeItemStack[]::new);
            return arecipeitemstack.length == 0 ? DataResult.error(() -> "No ingredients for shapeless recipe") : (arecipeitemstack.length > 9 ? DataResult.error(() -> "Too many ingredients for shapeless recipe") : DataResult.success(NonNullList.of(RecipeItemStack.EMPTY, arecipeitemstack)));
        }, DataResult::success).forGetter(shapelessrecipes -> shapelessrecipes.ingredients)).apply((Applicative)instance, ShapelessRecipes::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ShapelessRecipes> STREAM_CODEC = StreamCodec.of(a::toNetwork, a::fromNetwork);

        @Override
        public MapCodec<ShapelessRecipes> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, ShapelessRecipes> streamCodec() {
            return STREAM_CODEC;
        }

        private static ShapelessRecipes fromNetwork(RegistryFriendlyByteBuf registryfriendlybytebuf) {
            String s2 = registryfriendlybytebuf.readUtf();
            CraftingBookCategory craftingbookcategory = registryfriendlybytebuf.readEnum(CraftingBookCategory.class);
            int i2 = registryfriendlybytebuf.readVarInt();
            NonNullList<RecipeItemStack> nonnulllist = NonNullList.withSize(i2, RecipeItemStack.EMPTY);
            nonnulllist.replaceAll(recipeitemstack -> (RecipeItemStack)RecipeItemStack.CONTENTS_STREAM_CODEC.decode(registryfriendlybytebuf));
            ItemStack itemstack = (ItemStack)ItemStack.STREAM_CODEC.decode(registryfriendlybytebuf);
            return new ShapelessRecipes(s2, craftingbookcategory, itemstack, nonnulllist);
        }

        private static void toNetwork(RegistryFriendlyByteBuf registryfriendlybytebuf, ShapelessRecipes shapelessrecipes) {
            registryfriendlybytebuf.writeUtf(shapelessrecipes.group);
            registryfriendlybytebuf.writeEnum(shapelessrecipes.category);
            registryfriendlybytebuf.writeVarInt(shapelessrecipes.ingredients.size());
            for (RecipeItemStack recipeitemstack : shapelessrecipes.ingredients) {
                RecipeItemStack.CONTENTS_STREAM_CODEC.encode(registryfriendlybytebuf, recipeitemstack);
            }
            ItemStack.STREAM_CODEC.encode(registryfriendlybytebuf, shapelessrecipes.result);
        }
    }
}

