/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.level.World;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftRecipe;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftSmithingTransformRecipe;
import org.bukkit.inventory.Recipe;

public class SmithingTransformRecipe
implements SmithingRecipe {
    final RecipeItemStack template;
    final RecipeItemStack base;
    final RecipeItemStack addition;
    final ItemStack result;

    public SmithingTransformRecipe(RecipeItemStack recipeitemstack, RecipeItemStack recipeitemstack1, RecipeItemStack recipeitemstack2, ItemStack itemstack) {
        this.template = recipeitemstack;
        this.base = recipeitemstack1;
        this.addition = recipeitemstack2;
        this.result = itemstack;
    }

    @Override
    public boolean matches(SmithingRecipeInput smithingrecipeinput, World world) {
        return this.template.test(smithingrecipeinput.template()) && this.base.test(smithingrecipeinput.base()) && this.addition.test(smithingrecipeinput.addition());
    }

    @Override
    public ItemStack assemble(SmithingRecipeInput smithingrecipeinput, HolderLookup.a holderlookup_a) {
        ItemStack itemstack = smithingrecipeinput.base().transmuteCopy(this.result.getItem(), this.result.getCount());
        itemstack.applyComponents(this.result.getComponentsPatch());
        return itemstack;
    }

    @Override
    public ItemStack getResultItem(HolderLookup.a holderlookup_a) {
        return this.result;
    }

    @Override
    public boolean isTemplateIngredient(ItemStack itemstack) {
        return this.template.test(itemstack);
    }

    @Override
    public boolean isBaseIngredient(ItemStack itemstack) {
        return this.base.test(itemstack);
    }

    @Override
    public boolean isAdditionIngredient(ItemStack itemstack) {
        return this.addition.test(itemstack);
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializer.SMITHING_TRANSFORM;
    }

    @Override
    public boolean isIncomplete() {
        return Stream.of(this.template, this.base, this.addition).anyMatch(RecipeItemStack::isEmpty);
    }

    @Override
    public Recipe toBukkitRecipe(NamespacedKey id) {
        CraftItemStack result = CraftItemStack.asCraftMirror(this.result);
        CraftSmithingTransformRecipe recipe = new CraftSmithingTransformRecipe(id, result, CraftRecipe.toBukkit(this.template), CraftRecipe.toBukkit(this.base), CraftRecipe.toBukkit(this.addition));
        return recipe;
    }

    public static class a
    implements RecipeSerializer<SmithingTransformRecipe> {
        private static final MapCodec<SmithingTransformRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RecipeItemStack.CODEC.fieldOf("template").forGetter(smithingtransformrecipe -> smithingtransformrecipe.template), (App)RecipeItemStack.CODEC.fieldOf("base").forGetter(smithingtransformrecipe -> smithingtransformrecipe.base), (App)RecipeItemStack.CODEC.fieldOf("addition").forGetter(smithingtransformrecipe -> smithingtransformrecipe.addition), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(smithingtransformrecipe -> smithingtransformrecipe.result)).apply((Applicative)instance, SmithingTransformRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, SmithingTransformRecipe> STREAM_CODEC = StreamCodec.of(a::toNetwork, a::fromNetwork);

        @Override
        public MapCodec<SmithingTransformRecipe> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, SmithingTransformRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static SmithingTransformRecipe fromNetwork(RegistryFriendlyByteBuf registryfriendlybytebuf) {
            RecipeItemStack recipeitemstack = (RecipeItemStack)RecipeItemStack.CONTENTS_STREAM_CODEC.decode(registryfriendlybytebuf);
            RecipeItemStack recipeitemstack1 = (RecipeItemStack)RecipeItemStack.CONTENTS_STREAM_CODEC.decode(registryfriendlybytebuf);
            RecipeItemStack recipeitemstack2 = (RecipeItemStack)RecipeItemStack.CONTENTS_STREAM_CODEC.decode(registryfriendlybytebuf);
            ItemStack itemstack = (ItemStack)ItemStack.STREAM_CODEC.decode(registryfriendlybytebuf);
            return new SmithingTransformRecipe(recipeitemstack, recipeitemstack1, recipeitemstack2, itemstack);
        }

        private static void toNetwork(RegistryFriendlyByteBuf registryfriendlybytebuf, SmithingTransformRecipe smithingtransformrecipe) {
            RecipeItemStack.CONTENTS_STREAM_CODEC.encode(registryfriendlybytebuf, smithingtransformrecipe.template);
            RecipeItemStack.CONTENTS_STREAM_CODEC.encode(registryfriendlybytebuf, smithingtransformrecipe.base);
            RecipeItemStack.CONTENTS_STREAM_CODEC.encode(registryfriendlybytebuf, smithingtransformrecipe.addition);
            ItemStack.STREAM_CODEC.encode(registryfriendlybytebuf, smithingtransformrecipe.result);
        }
    }
}

