/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment.effects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public record ApplyMobEffect(HolderSet<MobEffectList> toApply, LevelBasedValue minDuration, LevelBasedValue maxDuration, LevelBasedValue minAmplifier, LevelBasedValue maxAmplifier) implements EnchantmentEntityEffect
{
    public static final MapCodec<ApplyMobEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RegistryCodecs.homogeneousList(Registries.MOB_EFFECT).fieldOf("to_apply").forGetter(ApplyMobEffect::toApply), (App)LevelBasedValue.CODEC.fieldOf("min_duration").forGetter(ApplyMobEffect::minDuration), (App)LevelBasedValue.CODEC.fieldOf("max_duration").forGetter(ApplyMobEffect::maxDuration), (App)LevelBasedValue.CODEC.fieldOf("min_amplifier").forGetter(ApplyMobEffect::minAmplifier), (App)LevelBasedValue.CODEC.fieldOf("max_amplifier").forGetter(ApplyMobEffect::maxAmplifier)).apply((Applicative)instance, ApplyMobEffect::new));

    @Override
    public void apply(WorldServer worldserver, int i2, EnchantedItemInUse enchantediteminuse, Entity entity, Vec3D vec3d) {
        EntityLiving entityliving;
        RandomSource randomsource;
        Optional<Holder<MobEffectList>> optional;
        if (entity instanceof EntityLiving && (optional = this.toApply.getRandomElement(randomsource = (entityliving = (EntityLiving)entity).getRandom())).isPresent()) {
            int j2 = Math.round(MathHelper.randomBetween(randomsource, this.minDuration.calculate(i2), this.maxDuration.calculate(i2)) * 20.0f);
            int k2 = Math.max(0, Math.round(MathHelper.randomBetween(randomsource, this.minAmplifier.calculate(i2), this.maxAmplifier.calculate(i2))));
            entityliving.addEffect(new MobEffect(optional.get(), j2, k2), EntityPotionEffectEvent.Cause.ATTACK);
        }
    }

    public MapCodec<ApplyMobEffect> codec() {
        return CODEC;
    }
}

