/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment.effects;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.function.Function;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.effects.AllOf;
import net.minecraft.world.item.enchantment.effects.ApplyMobEffect;
import net.minecraft.world.item.enchantment.effects.DamageEntity;
import net.minecraft.world.item.enchantment.effects.DamageItem;
import net.minecraft.world.item.enchantment.effects.EnchantmentAttributeEffect;
import net.minecraft.world.item.enchantment.effects.ExplodeEffect;
import net.minecraft.world.item.enchantment.effects.Ignite;
import net.minecraft.world.item.enchantment.effects.PlaySoundEffect;
import net.minecraft.world.item.enchantment.effects.ReplaceBlock;
import net.minecraft.world.item.enchantment.effects.ReplaceDisk;
import net.minecraft.world.item.enchantment.effects.RunFunction;
import net.minecraft.world.item.enchantment.effects.SetBlockProperties;
import net.minecraft.world.item.enchantment.effects.SpawnParticlesEffect;
import net.minecraft.world.item.enchantment.effects.SummonEntityEffect;
import net.minecraft.world.phys.Vec3D;

public interface EnchantmentLocationBasedEffect {
    public static final Codec<EnchantmentLocationBasedEffect> CODEC = BuiltInRegistries.ENCHANTMENT_LOCATION_BASED_EFFECT_TYPE.byNameCodec().dispatch(EnchantmentLocationBasedEffect::codec, Function.identity());

    public static MapCodec<? extends EnchantmentLocationBasedEffect> bootstrap(IRegistry<MapCodec<? extends EnchantmentLocationBasedEffect>> var0) {
        IRegistry.register(var0, "all_of", AllOf.b.CODEC);
        IRegistry.register(var0, "apply_mob_effect", ApplyMobEffect.CODEC);
        IRegistry.register(var0, "attribute", EnchantmentAttributeEffect.CODEC);
        IRegistry.register(var0, "damage_entity", DamageEntity.CODEC);
        IRegistry.register(var0, "damage_item", DamageItem.CODEC);
        IRegistry.register(var0, "explode", ExplodeEffect.CODEC);
        IRegistry.register(var0, "ignite", Ignite.CODEC);
        IRegistry.register(var0, "play_sound", PlaySoundEffect.CODEC);
        IRegistry.register(var0, "replace_block", ReplaceBlock.CODEC);
        IRegistry.register(var0, "replace_disk", ReplaceDisk.CODEC);
        IRegistry.register(var0, "run_function", RunFunction.CODEC);
        IRegistry.register(var0, "set_block_properties", SetBlockProperties.CODEC);
        IRegistry.register(var0, "spawn_particles", SpawnParticlesEffect.CODEC);
        return IRegistry.register(var0, "summon_entity", SummonEntityEffect.CODEC);
    }

    public void onChangedBlock(WorldServer var1, int var2, EnchantedItemInUse var3, Entity var4, Vec3D var5, boolean var6);

    default public void onDeactivated(EnchantedItemInUse var0, Entity var1, Vec3D var2, int var3) {
    }

    public MapCodec<? extends EnchantmentLocationBasedEffect> codec();
}

