/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment.effects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityCombustEvent;

public record Ignite(LevelBasedValue duration) implements EnchantmentEntityEffect
{
    public static final MapCodec<Ignite> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LevelBasedValue.CODEC.fieldOf("duration").forGetter(ignite -> ignite.duration)).apply((Applicative)instance, Ignite::new));

    @Override
    public void apply(WorldServer worldserver, int i2, EnchantedItemInUse enchantediteminuse, net.minecraft.world.entity.Entity entity, Vec3D vec3d) {
        Object entityCombustEvent = enchantediteminuse.owner() != null ? new EntityCombustByEntityEvent((Entity)enchantediteminuse.owner().getBukkitEntity(), (Entity)entity.getBukkitEntity(), this.duration.calculate(i2)) : new EntityCombustEvent((Entity)entity.getBukkitEntity(), this.duration.calculate(i2));
        Bukkit.getPluginManager().callEvent((Event)entityCombustEvent);
        if (entityCombustEvent.isCancelled()) {
            return;
        }
        entity.igniteForSeconds(entityCombustEvent.getDuration(), false);
    }

    public MapCodec<Ignite> codec() {
        return CODEC;
    }
}

