/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment.effects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.stateproviders.WorldGenFeatureStateProvider;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;

public record ReplaceDisk(LevelBasedValue radius, LevelBasedValue height, BaseBlockPosition offset, Optional<BlockPredicate> predicate, WorldGenFeatureStateProvider blockState, Optional<Holder<GameEvent>> triggerGameEvent) implements EnchantmentEntityEffect
{
    public static final MapCodec<ReplaceDisk> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LevelBasedValue.CODEC.fieldOf("radius").forGetter(ReplaceDisk::radius), (App)LevelBasedValue.CODEC.fieldOf("height").forGetter(ReplaceDisk::height), (App)BaseBlockPosition.CODEC.optionalFieldOf("offset", (Object)BaseBlockPosition.ZERO).forGetter(ReplaceDisk::offset), (App)BlockPredicate.CODEC.optionalFieldOf("predicate").forGetter(ReplaceDisk::predicate), (App)WorldGenFeatureStateProvider.CODEC.fieldOf("block_state").forGetter(ReplaceDisk::blockState), (App)GameEvent.CODEC.optionalFieldOf("trigger_game_event").forGetter(ReplaceDisk::triggerGameEvent)).apply((Applicative)instance, ReplaceDisk::new));

    @Override
    public void apply(WorldServer worldserver, int i2, EnchantedItemInUse enchantediteminuse, Entity entity, Vec3D vec3d) {
        BlockPosition blockposition = BlockPosition.containing(vec3d).offset(this.offset);
        RandomSource randomsource = entity.getRandom();
        int j2 = (int)this.radius.calculate(i2);
        int k2 = (int)this.height.calculate(i2);
        for (BlockPosition blockposition1 : BlockPosition.betweenClosed(blockposition.offset(-j2, 0, -j2), blockposition.offset(j2, Math.min(k2 - 1, 0), j2))) {
            if (!(blockposition1.distToCenterSqr(vec3d.x(), (double)blockposition1.getY() + 0.5, vec3d.z()) < (double)MathHelper.square(j2)) || !this.predicate.map(blockpredicate -> blockpredicate.test(worldserver, blockposition1)).orElse(true).booleanValue() || !CraftEventFactory.handleBlockFormEvent((World)worldserver, blockposition1, this.blockState.getState(randomsource, blockposition1), entity)) continue;
            this.triggerGameEvent.ifPresent(holder -> worldserver.gameEvent(entity, (Holder<GameEvent>)holder, blockposition1));
        }
    }

    public MapCodec<ReplaceDisk> codec() {
        return CODEC;
    }
}

