/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment.effects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.weather.LightningStrikeEvent;

public record SummonEntityEffect(HolderSet<EntityTypes<?>> entityTypes, boolean joinTeam) implements EnchantmentEntityEffect
{
    public static final MapCodec<SummonEntityEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RegistryCodecs.homogeneousList(Registries.ENTITY_TYPE).fieldOf("entity").forGetter(SummonEntityEffect::entityTypes), (App)Codec.BOOL.optionalFieldOf("join_team", (Object)false).forGetter(SummonEntityEffect::joinTeam)).apply((Applicative)instance, SummonEntityEffect::new));

    @Override
    public void apply(WorldServer worldserver, int i2, EnchantedItemInUse enchantediteminuse, Entity entity, Vec3D vec3d) {
        Object entity1;
        Optional<Holder<EntityTypes<?>>> optional;
        BlockPosition blockposition = BlockPosition.containing(vec3d);
        if (World.isInSpawnableBounds(blockposition) && !(optional = this.entityTypes().getRandomElement(worldserver.getRandom())).isEmpty() && (entity1 = optional.get().value().create(worldserver, null, blockposition, EnumMobSpawn.TRIGGERED, false, false)) != null) {
            if (entity1 instanceof EntityLightning) {
                EntityLightning entitylightning = (EntityLightning)entity1;
                EntityLiving entityliving = enchantediteminuse.owner();
                if (entityliving instanceof EntityPlayer) {
                    EntityPlayer entityplayer = (EntityPlayer)entityliving;
                    entitylightning.setCause(entityplayer);
                }
                worldserver.strikeLightning((Entity)entity1, enchantediteminuse.itemStack().getItem() == Items.TRIDENT ? LightningStrikeEvent.Cause.TRIDENT : LightningStrikeEvent.Cause.ENCHANTMENT);
            } else {
                worldserver.addFreshEntityWithPassengers(entity, CreatureSpawnEvent.SpawnReason.ENCHANTMENT);
            }
            if (this.joinTeam && entity.getTeam() != null) {
                worldserver.getScoreboard().addPlayerToTeam(((Entity)entity1).getScoreboardName(), entity.getTeam());
            }
            ((Entity)entity1).moveTo(vec3d.x, vec3d.y, vec3d.z, ((Entity)entity1).getYRot(), ((Entity)entity1).getXRot());
        }
    }

    public MapCodec<SummonEntityEffect> codec() {
        return CODEC;
    }
}

