/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.trading;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.MathHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.ItemCost;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftMerchantRecipe;

public class MerchantRecipe {
    public static final Codec<MerchantRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemCost.CODEC.fieldOf("buy").forGetter(merchantrecipe -> merchantrecipe.baseCostA), (App)ItemCost.CODEC.lenientOptionalFieldOf("buyB").forGetter(merchantrecipe -> merchantrecipe.costB), (App)ItemStack.CODEC.fieldOf("sell").forGetter(merchantrecipe -> merchantrecipe.result), (App)Codec.INT.lenientOptionalFieldOf("uses", (Object)0).forGetter(merchantrecipe -> merchantrecipe.uses), (App)Codec.INT.lenientOptionalFieldOf("maxUses", (Object)4).forGetter(merchantrecipe -> merchantrecipe.maxUses), (App)Codec.BOOL.lenientOptionalFieldOf("rewardExp", (Object)true).forGetter(merchantrecipe -> merchantrecipe.rewardExp), (App)Codec.INT.lenientOptionalFieldOf("specialPrice", (Object)0).forGetter(merchantrecipe -> merchantrecipe.specialPriceDiff), (App)Codec.INT.lenientOptionalFieldOf("demand", (Object)0).forGetter(merchantrecipe -> merchantrecipe.demand), (App)Codec.FLOAT.lenientOptionalFieldOf("priceMultiplier", (Object)Float.valueOf(0.0f)).forGetter(merchantrecipe -> Float.valueOf(merchantrecipe.priceMultiplier)), (App)Codec.INT.lenientOptionalFieldOf("xp", (Object)1).forGetter(merchantrecipe -> merchantrecipe.xp)).apply((Applicative)instance, MerchantRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, MerchantRecipe> STREAM_CODEC = StreamCodec.of(MerchantRecipe::writeToStream, MerchantRecipe::createFromStream);
    public ItemCost baseCostA;
    public Optional<ItemCost> costB;
    public final ItemStack result;
    public int uses;
    public int maxUses;
    public boolean rewardExp;
    public int specialPriceDiff;
    public int demand;
    public float priceMultiplier;
    public int xp;
    private CraftMerchantRecipe bukkitHandle;

    public CraftMerchantRecipe asBukkit() {
        return this.bukkitHandle == null ? (this.bukkitHandle = new CraftMerchantRecipe(this)) : this.bukkitHandle;
    }

    public MerchantRecipe(ItemCost baseCostA, Optional<ItemCost> costB, ItemStack result, int uses, int maxUses, int experience, float priceMultiplier, int demand, CraftMerchantRecipe bukkit) {
        this(baseCostA, costB, result, uses, maxUses, experience, priceMultiplier, demand);
        this.bukkitHandle = bukkit;
    }

    private MerchantRecipe(ItemCost itemcost, Optional<ItemCost> optional, ItemStack itemstack, int i2, int j2, boolean flag, int k2, int l2, float f2, int i1) {
        this.baseCostA = itemcost;
        this.costB = optional;
        this.result = itemstack;
        this.uses = i2;
        this.maxUses = j2;
        this.rewardExp = flag;
        this.specialPriceDiff = k2;
        this.demand = l2;
        this.priceMultiplier = f2;
        this.xp = i1;
    }

    public MerchantRecipe(ItemCost itemcost, ItemStack itemstack, int i2, int j2, float f2) {
        this(itemcost, Optional.empty(), itemstack, i2, j2, f2);
    }

    public MerchantRecipe(ItemCost itemcost, Optional<ItemCost> optional, ItemStack itemstack, int i2, int j2, float f2) {
        this(itemcost, optional, itemstack, 0, i2, j2, f2);
    }

    public MerchantRecipe(ItemCost itemcost, Optional<ItemCost> optional, ItemStack itemstack, int i2, int j2, int k2, float f2) {
        this(itemcost, optional, itemstack, i2, j2, k2, f2, 0);
    }

    public MerchantRecipe(ItemCost itemcost, Optional<ItemCost> optional, ItemStack itemstack, int i2, int j2, int k2, float f2, int l2) {
        this(itemcost, optional, itemstack, i2, j2, true, 0, l2, f2, k2);
    }

    private MerchantRecipe(MerchantRecipe merchantrecipe) {
        this(merchantrecipe.baseCostA, merchantrecipe.costB, merchantrecipe.result.copy(), merchantrecipe.uses, merchantrecipe.maxUses, merchantrecipe.rewardExp, merchantrecipe.specialPriceDiff, merchantrecipe.demand, merchantrecipe.priceMultiplier, merchantrecipe.xp);
    }

    public ItemStack getBaseCostA() {
        return this.baseCostA.itemStack();
    }

    public ItemStack getCostA() {
        return this.baseCostA.itemStack().copyWithCount(this.getModifiedCostCount(this.baseCostA));
    }

    private int getModifiedCostCount(ItemCost itemcost) {
        int i2 = itemcost.count();
        int j2 = Math.max(0, MathHelper.floor((float)(i2 * this.demand) * this.priceMultiplier));
        return MathHelper.clamp(i2 + j2 + this.specialPriceDiff, 1, itemcost.itemStack().getMaxStackSize());
    }

    public ItemStack getCostB() {
        return this.costB.map(ItemCost::itemStack).orElse(ItemStack.EMPTY);
    }

    public ItemCost getItemCostA() {
        return this.baseCostA;
    }

    public Optional<ItemCost> getItemCostB() {
        return this.costB;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public void updateDemand() {
        this.demand = this.demand + this.uses - (this.maxUses - this.uses);
    }

    public ItemStack assemble() {
        return this.result.copy();
    }

    public int getUses() {
        return this.uses;
    }

    public void resetUses() {
        this.uses = 0;
    }

    public int getMaxUses() {
        return this.maxUses;
    }

    public void increaseUses() {
        ++this.uses;
    }

    public int getDemand() {
        return this.demand;
    }

    public void addToSpecialPriceDiff(int i2) {
        this.specialPriceDiff += i2;
    }

    public void resetSpecialPriceDiff() {
        this.specialPriceDiff = 0;
    }

    public int getSpecialPriceDiff() {
        return this.specialPriceDiff;
    }

    public void setSpecialPriceDiff(int i2) {
        this.specialPriceDiff = i2;
    }

    public float getPriceMultiplier() {
        return this.priceMultiplier;
    }

    public int getXp() {
        return this.xp;
    }

    public boolean isOutOfStock() {
        return this.uses >= this.maxUses;
    }

    public void setToOutOfStock() {
        this.uses = this.maxUses;
    }

    public boolean needsRestock() {
        return this.uses > 0;
    }

    public boolean shouldRewardExp() {
        return this.rewardExp;
    }

    public boolean satisfiedBy(ItemStack itemstack, ItemStack itemstack1) {
        return this.baseCostA.test(itemstack) && itemstack.getCount() >= this.getModifiedCostCount(this.baseCostA) ? (!this.costB.isPresent() ? itemstack1.isEmpty() : this.costB.get().test(itemstack1) && itemstack1.getCount() >= this.costB.get().count()) : false;
    }

    public boolean take(ItemStack itemstack, ItemStack itemstack1) {
        if (!this.satisfiedBy(itemstack, itemstack1)) {
            return false;
        }
        if (!this.getCostA().isEmpty()) {
            itemstack.shrink(this.getCostA().getCount());
        }
        if (!this.getCostB().isEmpty()) {
            itemstack1.shrink(this.getCostB().getCount());
        }
        return true;
    }

    public MerchantRecipe copy() {
        return new MerchantRecipe(this);
    }

    private static void writeToStream(RegistryFriendlyByteBuf registryfriendlybytebuf, MerchantRecipe merchantrecipe) {
        ItemCost.STREAM_CODEC.encode(registryfriendlybytebuf, merchantrecipe.getItemCostA());
        ItemStack.STREAM_CODEC.encode(registryfriendlybytebuf, merchantrecipe.getResult());
        ItemCost.OPTIONAL_STREAM_CODEC.encode(registryfriendlybytebuf, merchantrecipe.getItemCostB());
        registryfriendlybytebuf.writeBoolean(merchantrecipe.isOutOfStock());
        registryfriendlybytebuf.writeInt(merchantrecipe.getUses());
        registryfriendlybytebuf.writeInt(merchantrecipe.getMaxUses());
        registryfriendlybytebuf.writeInt(merchantrecipe.getXp());
        registryfriendlybytebuf.writeInt(merchantrecipe.getSpecialPriceDiff());
        registryfriendlybytebuf.writeFloat(merchantrecipe.getPriceMultiplier());
        registryfriendlybytebuf.writeInt(merchantrecipe.getDemand());
    }

    public static MerchantRecipe createFromStream(RegistryFriendlyByteBuf registryfriendlybytebuf) {
        ItemCost itemcost = (ItemCost)ItemCost.STREAM_CODEC.decode(registryfriendlybytebuf);
        ItemStack itemstack = (ItemStack)ItemStack.STREAM_CODEC.decode(registryfriendlybytebuf);
        Optional optional = (Optional)ItemCost.OPTIONAL_STREAM_CODEC.decode(registryfriendlybytebuf);
        boolean flag = registryfriendlybytebuf.readBoolean();
        int i2 = registryfriendlybytebuf.readInt();
        int j2 = registryfriendlybytebuf.readInt();
        int k2 = registryfriendlybytebuf.readInt();
        int l2 = registryfriendlybytebuf.readInt();
        float f2 = registryfriendlybytebuf.readFloat();
        int i1 = registryfriendlybytebuf.readInt();
        MerchantRecipe merchantrecipe = new MerchantRecipe(itemcost, optional, itemstack, i2, j2, k2, f2, i1);
        if (flag) {
            merchantrecipe.setToOutOfStock();
        }
        merchantrecipe.setSpecialPriceDiff(l2);
        return merchantrecipe;
    }
}

