/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.item.EntityTNTPrimed;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.ExplosionDamageCalculatorEntity;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.level.block.BlockTNT;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.TNTPrimeEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityKnockbackEvent;

public class Explosion {
    private static final ExplosionDamageCalculator EXPLOSION_DAMAGE_CALCULATOR = new ExplosionDamageCalculator();
    private static final int MAX_DROPS_PER_COMBINED_STACK = 16;
    private final boolean fire;
    private final Effect blockInteraction;
    private final RandomSource random = RandomSource.create();
    private final World level;
    private final double x;
    private final double y;
    private final double z;
    @Nullable
    public final Entity source;
    private final float radius;
    private final DamageSource damageSource;
    private final ExplosionDamageCalculator damageCalculator;
    private final ParticleParam smallExplosionParticles;
    private final ParticleParam largeExplosionParticles;
    private final Holder<SoundEffect> explosionSound;
    private final ObjectArrayList<BlockPosition> toBlow = new ObjectArrayList();
    private final Map<EntityHuman, Vec3D> hitPlayers = Maps.newHashMap();
    public boolean wasCanceled = false;
    public float yield;

    public static DamageSource getDefaultDamageSource(World world, @Nullable Entity entity) {
        return world.damageSources().explosion(entity, Explosion.getIndirectSourceEntityInternal(entity));
    }

    public Explosion(World world, @Nullable Entity entity, double d0, double d1, double d2, float f2, List<BlockPosition> list, Effect explosion_effect, ParticleParam particleparam, ParticleParam particleparam1, Holder<SoundEffect> holder) {
        this(world, entity, Explosion.getDefaultDamageSource(world, entity), null, d0, d1, d2, f2, false, explosion_effect, particleparam, particleparam1, holder);
        this.toBlow.addAll(list);
    }

    public Explosion(World world, @Nullable Entity entity, double d0, double d1, double d2, float f2, boolean flag, Effect explosion_effect, List<BlockPosition> list) {
        this(world, entity, d0, d1, d2, f2, flag, explosion_effect);
        this.toBlow.addAll(list);
    }

    public Explosion(World world, @Nullable Entity entity, double d0, double d1, double d2, float f2, boolean flag, Effect explosion_effect) {
        this(world, entity, Explosion.getDefaultDamageSource(world, entity), null, d0, d1, d2, f2, flag, explosion_effect, Particles.EXPLOSION, Particles.EXPLOSION_EMITTER, SoundEffects.GENERIC_EXPLODE);
    }

    public Explosion(World world, @Nullable Entity entity, @Nullable DamageSource damagesource, @Nullable ExplosionDamageCalculator explosiondamagecalculator, double d0, double d1, double d2, float f2, boolean flag, Effect explosion_effect, ParticleParam particleparam, ParticleParam particleparam1, Holder<SoundEffect> holder) {
        this.level = world;
        this.source = entity;
        this.radius = (float)Math.max((double)f2, 0.0);
        this.x = d0;
        this.y = d1;
        this.z = d2;
        this.fire = flag;
        this.blockInteraction = explosion_effect;
        this.damageSource = damagesource == null ? world.damageSources().explosion(this) : damagesource;
        this.damageCalculator = explosiondamagecalculator == null ? this.makeDamageCalculator(entity) : explosiondamagecalculator;
        this.smallExplosionParticles = particleparam;
        this.largeExplosionParticles = particleparam1;
        this.explosionSound = holder;
        this.yield = this.blockInteraction == Effect.DESTROY_WITH_DECAY ? 1.0f / this.radius : 1.0f;
    }

    private ExplosionDamageCalculator makeDamageCalculator(@Nullable Entity entity) {
        return entity == null ? EXPLOSION_DAMAGE_CALCULATOR : new ExplosionDamageCalculatorEntity(entity);
    }

    public static float getSeenPercent(Vec3D vec3d, Entity entity) {
        AxisAlignedBB axisalignedbb = entity.getBoundingBox();
        double d0 = 1.0 / ((axisalignedbb.maxX - axisalignedbb.minX) * 2.0 + 1.0);
        double d1 = 1.0 / ((axisalignedbb.maxY - axisalignedbb.minY) * 2.0 + 1.0);
        double d2 = 1.0 / ((axisalignedbb.maxZ - axisalignedbb.minZ) * 2.0 + 1.0);
        double d3 = (1.0 - Math.floor(1.0 / d0) * d0) / 2.0;
        double d4 = (1.0 - Math.floor(1.0 / d2) * d2) / 2.0;
        if (d0 >= 0.0 && d1 >= 0.0 && d2 >= 0.0) {
            int i2 = 0;
            int j2 = 0;
            for (double d5 = 0.0; d5 <= 1.0; d5 += d0) {
                for (double d6 = 0.0; d6 <= 1.0; d6 += d1) {
                    for (double d7 = 0.0; d7 <= 1.0; d7 += d2) {
                        double d8 = MathHelper.lerp(d5, axisalignedbb.minX, axisalignedbb.maxX);
                        double d9 = MathHelper.lerp(d6, axisalignedbb.minY, axisalignedbb.maxY);
                        double d10 = MathHelper.lerp(d7, axisalignedbb.minZ, axisalignedbb.maxZ);
                        Vec3D vec3d1 = new Vec3D(d8 + d3, d9, d10 + d4);
                        if (entity.level().clip(new RayTrace(vec3d1, vec3d, RayTrace.BlockCollisionOption.COLLIDER, RayTrace.FluidCollisionOption.NONE, entity)).getType() == MovingObjectPosition.EnumMovingObjectType.MISS) {
                            ++i2;
                        }
                        ++j2;
                    }
                }
            }
            return (float)i2 / (float)j2;
        }
        return 0.0f;
    }

    public float radius() {
        return this.radius;
    }

    public Vec3D center() {
        return new Vec3D(this.x, this.y, this.z);
    }

    public void explode() {
        int j2;
        int i2;
        if (this.radius < 0.1f) {
            return;
        }
        this.level.gameEvent(this.source, GameEvent.EXPLODE, new Vec3D(this.x, this.y, this.z));
        HashSet set = Sets.newHashSet();
        boolean flag = true;
        for (int k2 = 0; k2 < 16; ++k2) {
            for (i2 = 0; i2 < 16; ++i2) {
                block2: for (j2 = 0; j2 < 16; ++j2) {
                    if (k2 != 0 && k2 != 15 && i2 != 0 && i2 != 15 && j2 != 0 && j2 != 15) continue;
                    double d0 = (float)k2 / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)i2 / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)j2 / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = this.x;
                    double d5 = this.y;
                    double d6 = this.z;
                    float f1 = 0.3f;
                    for (float f2 = this.radius * (0.7f + this.level.random.nextFloat() * 0.6f); f2 > 0.0f; f2 -= 0.22500001f) {
                        BlockPosition blockposition = BlockPosition.containing(d4, d5, d6);
                        IBlockData iblockdata = this.level.getBlockState(blockposition);
                        Fluid fluid = this.level.getFluidState(blockposition);
                        if (!this.level.isInWorldBounds(blockposition)) continue block2;
                        Optional<Float> optional = this.damageCalculator.getBlockExplosionResistance(this, this.level, blockposition, iblockdata, fluid);
                        if (optional.isPresent()) {
                            f2 -= (optional.get().floatValue() + 0.3f) * 0.3f;
                        }
                        if (f2 > 0.0f && this.damageCalculator.shouldBlockExplode(this, this.level, blockposition, iblockdata, f2)) {
                            set.add(blockposition);
                        }
                        d4 += d0 * (double)0.3f;
                        d5 += d1 * (double)0.3f;
                        d6 += d2 * (double)0.3f;
                    }
                }
            }
        }
        this.toBlow.addAll((Collection)set);
        float f2 = this.radius * 2.0f;
        i2 = MathHelper.floor(this.x - (double)f2 - 1.0);
        j2 = MathHelper.floor(this.x + (double)f2 + 1.0);
        int l2 = MathHelper.floor(this.y - (double)f2 - 1.0);
        int i1 = MathHelper.floor(this.y + (double)f2 + 1.0);
        int j1 = MathHelper.floor(this.z - (double)f2 - 1.0);
        int k1 = MathHelper.floor(this.z + (double)f2 + 1.0);
        List<Entity> list = this.level.getEntities(this.source, new AxisAlignedBB(i2, l2, j1, j2, i1, k1));
        Vec3D vec3d = new Vec3D(this.x, this.y, this.z);
        for (Entity entity : list) {
            EntityHuman entityhuman;
            double d13;
            double d10;
            double d9;
            double d8;
            double d11;
            double d7;
            if (entity.ignoreExplosion(this) || !((d7 = Math.sqrt(entity.distanceToSqr(vec3d)) / (double)f2) <= 1.0) || (d11 = Math.sqrt((d8 = entity.getX() - this.x) * d8 + (d9 = (entity instanceof EntityTNTPrimed ? entity.getY() : entity.getEyeY()) - this.y) * d9 + (d10 = entity.getZ() - this.z) * d10)) == 0.0) continue;
            d8 /= d11;
            d9 /= d11;
            d10 /= d11;
            if (this.damageCalculator.shouldDamageEntity(this, entity)) {
                if (entity instanceof EntityComplexPart) continue;
                entity.lastDamageCancelled = false;
                if (entity instanceof EntityEnderDragon) {
                    for (EntityComplexPart entityComplexPart : ((EntityEnderDragon)entity).subEntities) {
                        if (!list.contains(entityComplexPart)) continue;
                        entityComplexPart.hurt(this.damageSource, this.damageCalculator.getEntityDamageAmount(this, entity));
                    }
                } else {
                    entity.hurt(this.damageSource, this.damageCalculator.getEntityDamageAmount(this, entity));
                }
                if (entity.lastDamageCancelled) continue;
            }
            double d12 = (1.0 - d7) * (double)Explosion.getSeenPercent(vec3d, entity) * (double)this.damageCalculator.getKnockbackMultiplier(entity);
            if (entity instanceof EntityLiving) {
                EntityLiving entityliving = (EntityLiving)entity;
                d13 = d12 * (1.0 - entityliving.getAttributeValue(GenericAttributes.EXPLOSION_KNOCKBACK_RESISTANCE));
            } else {
                d13 = d12;
            }
            Vec3D vec3d1 = new Vec3D(d8 *= d13, d9 *= d13, d10 *= d13);
            if (entity instanceof EntityLiving) {
                Vec3D result = entity.getDeltaMovement().add(vec3d1);
                EntityKnockbackEvent event = CraftEventFactory.callEntityKnockbackEvent((CraftLivingEntity)entity.getBukkitEntity(), this.source, EntityKnockbackEvent.KnockbackCause.EXPLOSION, d13, vec3d1, result.x, result.y, result.z);
                vec3d1 = event.isCancelled() ? Vec3D.ZERO : new Vec3D(event.getFinalKnockback().getX(), event.getFinalKnockback().getY(), event.getFinalKnockback().getZ()).subtract(entity.getDeltaMovement());
            }
            entity.setDeltaMovement(entity.getDeltaMovement().add(vec3d1));
            if (!(!(entity instanceof EntityHuman) || (entityhuman = (EntityHuman)entity).isSpectator() || entityhuman.isCreative() && entityhuman.getAbilities().flying)) {
                this.hitPlayers.put(entityhuman, vec3d1);
            }
            entity.onExplosionHit(this.source);
        }
    }

    public void finalizeExplosion(boolean flag) {
        if (this.level.isClientSide) {
            this.level.playLocalSound(this.x, this.y, this.z, this.explosionSound.value(), SoundCategory.BLOCKS, 4.0f, (1.0f + (this.level.random.nextFloat() - this.level.random.nextFloat()) * 0.2f) * 0.7f, false);
        }
        boolean flag1 = this.interactsWithBlocks();
        if (flag) {
            ParticleParam particleparam = this.radius >= 2.0f && flag1 ? this.largeExplosionParticles : this.smallExplosionParticles;
            this.level.addParticle(particleparam, this.x, this.y, this.z, 1.0, 0.0, 0.0);
        }
        if (flag1) {
            List bukkitBlocks;
            this.level.getProfiler().push("explosion_blocks");
            ArrayList list = new ArrayList();
            SystemUtils.shuffle(this.toBlow, this.level.random);
            ObjectListIterator objectlistiterator = this.toBlow.iterator();
            CraftWorld bworld = this.level.getWorld();
            Location location = new Location((org.bukkit.World)bworld, this.x, this.y, this.z);
            ObjectArrayList blockList = new ObjectArrayList();
            for (int i1 = this.toBlow.size() - 1; i1 >= 0; --i1) {
                BlockPosition cpos = (BlockPosition)this.toBlow.get(i1);
                org.bukkit.block.Block bblock = bworld.getBlockAt(cpos.getX(), cpos.getY(), cpos.getZ());
                if (bblock.getType().isAir()) continue;
                blockList.add(bblock);
            }
            if (this.source != null) {
                EntityExplodeEvent event = CraftEventFactory.callEntityExplodeEvent(this.source, (List<org.bukkit.block.Block>)blockList, this.yield, this.getBlockInteraction());
                this.wasCanceled = event.isCancelled();
                bukkitBlocks = event.blockList();
                this.yield = event.getYield();
            } else {
                org.bukkit.block.Block block = location.getBlock();
                BlockState blockState = this.damageSource.getDirectBlockState() != null ? this.damageSource.getDirectBlockState() : block.getState();
                BlockExplodeEvent event = CraftEventFactory.callBlockExplodeEvent(block, blockState, (List<org.bukkit.block.Block>)blockList, this.yield, this.getBlockInteraction());
                this.wasCanceled = event.isCancelled();
                bukkitBlocks = event.blockList();
                this.yield = event.getYield();
            }
            this.toBlow.clear();
            for (org.bukkit.block.Block bblock : bukkitBlocks) {
                BlockPosition coords = new BlockPosition(bblock.getX(), bblock.getY(), bblock.getZ());
                this.toBlow.add((Object)coords);
            }
            if (this.wasCanceled) {
                return;
            }
            for (BlockPosition blockposition : this.toBlow) {
                IBlockData iblockdata = this.level.getBlockState(blockposition);
                Block block = iblockdata.getBlock();
                if (block instanceof BlockTNT) {
                    BlockPosition sourceBlock;
                    Entity sourceEntity = this.source == null ? null : this.source;
                    BlockPosition blockPosition = sourceBlock = sourceEntity == null ? BlockPosition.containing(this.x, this.y, this.z) : null;
                    if (!CraftEventFactory.callTNTPrimeEvent(this.level, blockposition, TNTPrimeEvent.PrimeCause.EXPLOSION, sourceEntity, sourceBlock)) {
                        this.level.sendBlockUpdated(blockposition, Blocks.AIR.defaultBlockState(), iblockdata, 3);
                        continue;
                    }
                }
                this.level.getBlockState(blockposition).onExplosionHit(this.level, blockposition, this, (itemstack, blockposition1) -> Explosion.addOrAppendStack(list, itemstack, blockposition1));
            }
            for (Pair pair : list) {
                Block.popResource(this.level, (BlockPosition)pair.getSecond(), (ItemStack)pair.getFirst());
            }
            this.level.getProfiler().pop();
        }
        if (this.fire) {
            for (BlockPosition blockposition12 : this.toBlow) {
                if (this.random.nextInt(3) != 0 || !this.level.getBlockState(blockposition12).isAir() || !this.level.getBlockState(blockposition12.below()).isSolidRender(this.level, blockposition12.below()) || CraftEventFactory.callBlockIgniteEvent(this.level, blockposition12, this).isCancelled()) continue;
                this.level.setBlockAndUpdate(blockposition12, BlockFireAbstract.getState(this.level, blockposition12));
            }
        }
    }

    private static void addOrAppendStack(List<Pair<ItemStack, BlockPosition>> list, ItemStack itemstack, BlockPosition blockposition) {
        if (itemstack.isEmpty()) {
            return;
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Pair<ItemStack, BlockPosition> pair = list.get(i2);
            ItemStack itemstack1 = (ItemStack)pair.getFirst();
            if (!EntityItem.areMergable(itemstack1, itemstack)) continue;
            list.set(i2, (Pair<ItemStack, BlockPosition>)Pair.of((Object)EntityItem.merge(itemstack1, itemstack, 16), (Object)((BlockPosition)pair.getSecond())));
            if (!itemstack.isEmpty()) continue;
            return;
        }
        list.add((Pair<ItemStack, BlockPosition>)Pair.of((Object)itemstack, (Object)blockposition));
    }

    public boolean interactsWithBlocks() {
        return this.blockInteraction != Effect.KEEP;
    }

    public Map<EntityHuman, Vec3D> getHitPlayers() {
        return this.hitPlayers;
    }

    @Nullable
    private static EntityLiving getIndirectSourceEntityInternal(@Nullable Entity entity) {
        IProjectile iprojectile;
        Entity entity1;
        if (entity == null) {
            return null;
        }
        if (entity instanceof EntityTNTPrimed) {
            EntityTNTPrimed entitytntprimed = (EntityTNTPrimed)entity;
            return entitytntprimed.getOwner();
        }
        if (entity instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            return entityliving;
        }
        if (entity instanceof IProjectile && (entity1 = (iprojectile = (IProjectile)entity).getOwner()) instanceof EntityLiving) {
            EntityLiving entityliving1 = (EntityLiving)entity1;
            return entityliving1;
        }
        return null;
    }

    @Nullable
    public EntityLiving getIndirectSourceEntity() {
        return Explosion.getIndirectSourceEntityInternal(this.source);
    }

    @Nullable
    public Entity getDirectSourceEntity() {
        return this.source;
    }

    public void clearToBlow() {
        this.toBlow.clear();
    }

    public List<BlockPosition> getToBlow() {
        return this.toBlow;
    }

    public Effect getBlockInteraction() {
        return this.blockInteraction;
    }

    public ParticleParam getSmallExplosionParticles() {
        return this.smallExplosionParticles;
    }

    public ParticleParam getLargeExplosionParticles() {
        return this.largeExplosionParticles;
    }

    public Holder<SoundEffect> getExplosionSound() {
        return this.explosionSound;
    }

    public boolean canTriggerBlocks() {
        return this.blockInteraction == Effect.TRIGGER_BLOCK && !this.level.isClientSide() ? (this.source != null && this.source.getType() == EntityTypes.BREEZE_WIND_CHARGE ? this.level.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING) : true) : false;
    }

    public static enum Effect {
        KEEP,
        DESTROY,
        DESTROY_WITH_DECAY,
        TRIGGER_BLOCK;

    }
}

