/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicLike;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import org.slf4j.Logger;

public class GameRules {
    public static final int DEFAULT_RANDOM_TICK_SPEED = 3;
    static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<GameRuleKey<?>, GameRuleDefinition<?>> GAME_RULE_TYPES = Maps.newTreeMap(Comparator.comparing(gamerules_gamerulekey -> gamerules_gamerulekey.id));
    public static final GameRuleKey<GameRuleBoolean> RULE_DOFIRETICK = GameRules.register("doFireTick", GameRuleCategory.UPDATES, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleBoolean> RULE_MOBGRIEFING = GameRules.register("mobGriefing", GameRuleCategory.MOBS, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleBoolean> RULE_KEEPINVENTORY = GameRules.register("keepInventory", GameRuleCategory.PLAYER, GameRuleBoolean.create(false));
    public static final GameRuleKey<GameRuleBoolean> RULE_DOMOBSPAWNING = GameRules.register("doMobSpawning", GameRuleCategory.SPAWNING, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleBoolean> RULE_DOMOBLOOT = GameRules.register("doMobLoot", GameRuleCategory.DROPS, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleBoolean> RULE_PROJECTILESCANBREAKBLOCKS = GameRules.register("projectilesCanBreakBlocks", GameRuleCategory.DROPS, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleBoolean> RULE_DOBLOCKDROPS = GameRules.register("doTileDrops", GameRuleCategory.DROPS, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleBoolean> RULE_DOENTITYDROPS = GameRules.register("doEntityDrops", GameRuleCategory.DROPS, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleBoolean> RULE_COMMANDBLOCKOUTPUT = GameRules.register("commandBlockOutput", GameRuleCategory.CHAT, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleBoolean> RULE_NATURAL_REGENERATION = GameRules.register("naturalRegeneration", GameRuleCategory.PLAYER, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleBoolean> RULE_DAYLIGHT = GameRules.register("doDaylightCycle", GameRuleCategory.UPDATES, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleBoolean> RULE_LOGADMINCOMMANDS = GameRules.register("logAdminCommands", GameRuleCategory.CHAT, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleBoolean> RULE_SHOWDEATHMESSAGES = GameRules.register("showDeathMessages", GameRuleCategory.CHAT, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleInt> RULE_RANDOMTICKING = GameRules.register("randomTickSpeed", GameRuleCategory.UPDATES, GameRuleInt.create(3));
    public static final GameRuleKey<GameRuleBoolean> RULE_SENDCOMMANDFEEDBACK = GameRules.register("sendCommandFeedback", GameRuleCategory.CHAT, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleBoolean> RULE_REDUCEDDEBUGINFO = GameRules.register("reducedDebugInfo", GameRuleCategory.MISC, GameRuleBoolean.create(false, (minecraftserver, gamerules_gameruleboolean) -> {
        int i2 = gamerules_gameruleboolean.get() ? 22 : 23;
        for (EntityPlayer entityplayer : minecraftserver.players()) {
            entityplayer.connection.send(new PacketPlayOutEntityStatus(entityplayer, (byte)i2));
        }
    }));
    public static final GameRuleKey<GameRuleBoolean> RULE_SPECTATORSGENERATECHUNKS = GameRules.register("spectatorsGenerateChunks", GameRuleCategory.PLAYER, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleInt> RULE_SPAWN_RADIUS = GameRules.register("spawnRadius", GameRuleCategory.PLAYER, GameRuleInt.create(10));
    public static final GameRuleKey<GameRuleBoolean> RULE_DISABLE_ELYTRA_MOVEMENT_CHECK = GameRules.register("disableElytraMovementCheck", GameRuleCategory.PLAYER, GameRuleBoolean.create(false));
    public static final GameRuleKey<GameRuleInt> RULE_MAX_ENTITY_CRAMMING = GameRules.register("maxEntityCramming", GameRuleCategory.MOBS, GameRuleInt.create(24));
    public static final GameRuleKey<GameRuleBoolean> RULE_WEATHER_CYCLE = GameRules.register("doWeatherCycle", GameRuleCategory.UPDATES, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleBoolean> RULE_LIMITED_CRAFTING = GameRules.register("doLimitedCrafting", GameRuleCategory.PLAYER, GameRuleBoolean.create(false, (minecraftserver, gamerules_gameruleboolean) -> {
        for (EntityPlayer entityplayer : minecraftserver.players()) {
            entityplayer.connection.send(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.LIMITED_CRAFTING, gamerules_gameruleboolean.get() ? 1.0f : 0.0f));
        }
    }));
    public static final GameRuleKey<GameRuleInt> RULE_MAX_COMMAND_CHAIN_LENGTH = GameRules.register("maxCommandChainLength", GameRuleCategory.MISC, GameRuleInt.create(65536));
    public static final GameRuleKey<GameRuleInt> RULE_MAX_COMMAND_FORK_COUNT = GameRules.register("maxCommandForkCount", GameRuleCategory.MISC, GameRuleInt.create(65536));
    public static final GameRuleKey<GameRuleInt> RULE_COMMAND_MODIFICATION_BLOCK_LIMIT = GameRules.register("commandModificationBlockLimit", GameRuleCategory.MISC, GameRuleInt.create(32768));
    public static final GameRuleKey<GameRuleBoolean> RULE_ANNOUNCE_ADVANCEMENTS = GameRules.register("announceAdvancements", GameRuleCategory.CHAT, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleBoolean> RULE_DISABLE_RAIDS = GameRules.register("disableRaids", GameRuleCategory.MOBS, GameRuleBoolean.create(false));
    public static final GameRuleKey<GameRuleBoolean> RULE_DOINSOMNIA = GameRules.register("doInsomnia", GameRuleCategory.SPAWNING, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleBoolean> RULE_DO_IMMEDIATE_RESPAWN = GameRules.register("doImmediateRespawn", GameRuleCategory.PLAYER, GameRuleBoolean.create(false, (minecraftserver, gamerules_gameruleboolean) -> {
        for (EntityPlayer entityplayer : minecraftserver.players()) {
            entityplayer.connection.send(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.IMMEDIATE_RESPAWN, gamerules_gameruleboolean.get() ? 1.0f : 0.0f));
        }
    }));
    public static final GameRuleKey<GameRuleInt> RULE_PLAYERS_NETHER_PORTAL_DEFAULT_DELAY = GameRules.register("playersNetherPortalDefaultDelay", GameRuleCategory.PLAYER, GameRuleInt.create(80));
    public static final GameRuleKey<GameRuleInt> RULE_PLAYERS_NETHER_PORTAL_CREATIVE_DELAY = GameRules.register("playersNetherPortalCreativeDelay", GameRuleCategory.PLAYER, GameRuleInt.create(1));
    public static final GameRuleKey<GameRuleBoolean> RULE_DROWNING_DAMAGE = GameRules.register("drowningDamage", GameRuleCategory.PLAYER, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleBoolean> RULE_FALL_DAMAGE = GameRules.register("fallDamage", GameRuleCategory.PLAYER, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleBoolean> RULE_FIRE_DAMAGE = GameRules.register("fireDamage", GameRuleCategory.PLAYER, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleBoolean> RULE_FREEZE_DAMAGE = GameRules.register("freezeDamage", GameRuleCategory.PLAYER, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleBoolean> RULE_DO_PATROL_SPAWNING = GameRules.register("doPatrolSpawning", GameRuleCategory.SPAWNING, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleBoolean> RULE_DO_TRADER_SPAWNING = GameRules.register("doTraderSpawning", GameRuleCategory.SPAWNING, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleBoolean> RULE_DO_WARDEN_SPAWNING = GameRules.register("doWardenSpawning", GameRuleCategory.SPAWNING, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleBoolean> RULE_FORGIVE_DEAD_PLAYERS = GameRules.register("forgiveDeadPlayers", GameRuleCategory.MOBS, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleBoolean> RULE_UNIVERSAL_ANGER = GameRules.register("universalAnger", GameRuleCategory.MOBS, GameRuleBoolean.create(false));
    public static final GameRuleKey<GameRuleInt> RULE_PLAYERS_SLEEPING_PERCENTAGE = GameRules.register("playersSleepingPercentage", GameRuleCategory.PLAYER, GameRuleInt.create(100));
    public static final GameRuleKey<GameRuleBoolean> RULE_BLOCK_EXPLOSION_DROP_DECAY = GameRules.register("blockExplosionDropDecay", GameRuleCategory.DROPS, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleBoolean> RULE_MOB_EXPLOSION_DROP_DECAY = GameRules.register("mobExplosionDropDecay", GameRuleCategory.DROPS, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleBoolean> RULE_TNT_EXPLOSION_DROP_DECAY = GameRules.register("tntExplosionDropDecay", GameRuleCategory.DROPS, GameRuleBoolean.create(false));
    public static final GameRuleKey<GameRuleInt> RULE_SNOW_ACCUMULATION_HEIGHT = GameRules.register("snowAccumulationHeight", GameRuleCategory.UPDATES, GameRuleInt.create(1));
    public static final GameRuleKey<GameRuleBoolean> RULE_WATER_SOURCE_CONVERSION = GameRules.register("waterSourceConversion", GameRuleCategory.UPDATES, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleBoolean> RULE_LAVA_SOURCE_CONVERSION = GameRules.register("lavaSourceConversion", GameRuleCategory.UPDATES, GameRuleBoolean.create(false));
    public static final GameRuleKey<GameRuleBoolean> RULE_GLOBAL_SOUND_EVENTS = GameRules.register("globalSoundEvents", GameRuleCategory.MISC, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleBoolean> RULE_DO_VINES_SPREAD = GameRules.register("doVinesSpread", GameRuleCategory.UPDATES, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleBoolean> RULE_ENDER_PEARLS_VANISH_ON_DEATH = GameRules.register("enderPearlsVanishOnDeath", GameRuleCategory.PLAYER, GameRuleBoolean.create(true));
    public static final GameRuleKey<GameRuleInt> RULE_SPAWN_CHUNK_RADIUS = GameRules.register("spawnChunkRadius", GameRuleCategory.MISC, GameRuleInt.create(2, 0, 32, (minecraftserver, gamerules_gameruleint) -> {
        WorldServer worldserver = minecraftserver;
        worldserver.setDefaultSpawnPos(worldserver.getSharedSpawnPos(), worldserver.getSharedSpawnAngle());
    }));
    private final Map<GameRuleKey<?>, GameRuleValue<?>> rules;

    private static <T extends GameRuleValue<T>> GameRuleKey<T> register(String s2, GameRuleCategory gamerules_gamerulecategory, GameRuleDefinition<T> gamerules_gameruledefinition) {
        GameRuleKey gamerules_gamerulekey = new GameRuleKey(s2, gamerules_gamerulecategory);
        GameRuleDefinition<T> gamerules_gameruledefinition1 = GAME_RULE_TYPES.put(gamerules_gamerulekey, gamerules_gameruledefinition);
        if (gamerules_gameruledefinition1 != null) {
            throw new IllegalStateException("Duplicate game rule registration for " + s2);
        }
        return gamerules_gamerulekey;
    }

    public GameRules(DynamicLike<?> dynamiclike) {
        this();
        this.loadFromTag(dynamiclike);
    }

    public GameRules() {
        this.rules = (Map)GAME_RULE_TYPES.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((GameRuleDefinition)entry.getValue()).createRule()));
    }

    private GameRules(Map<GameRuleKey<?>, GameRuleValue<?>> map) {
        this.rules = map;
    }

    public <T extends GameRuleValue<T>> T getRule(GameRuleKey<T> gamerules_gamerulekey) {
        return (T)this.rules.get(gamerules_gamerulekey);
    }

    public NBTTagCompound createTag() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.rules.forEach((gamerules_gamerulekey, gamerules_gamerulevalue) -> nbttagcompound.putString(gamerules_gamerulekey.id, gamerules_gamerulevalue.serialize()));
        return nbttagcompound;
    }

    private void loadFromTag(DynamicLike<?> dynamiclike) {
        this.rules.forEach((gamerules_gamerulekey, gamerules_gamerulevalue) -> {
            DataResult dataresult = dynamiclike.get(gamerules_gamerulekey.id).asString();
            Objects.requireNonNull(gamerules_gamerulevalue);
            dataresult.ifSuccess(gamerules_gamerulevalue::deserialize);
        });
    }

    public GameRules copy() {
        return new GameRules((Map)this.rules.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((GameRuleValue)entry.getValue()).copy())));
    }

    public static void visitGameRuleTypes(GameRuleVisitor gamerules_gamerulevisitor) {
        GAME_RULE_TYPES.forEach((gamerules_gamerulekey, gamerules_gameruledefinition) -> GameRules.callVisitorCap(gamerules_gamerulevisitor, gamerules_gamerulekey, gamerules_gameruledefinition));
    }

    private static <T extends GameRuleValue<T>> void callVisitorCap(GameRuleVisitor gamerules_gamerulevisitor, GameRuleKey<?> gamerules_gamerulekey, GameRuleDefinition<?> gamerules_gameruledefinition) {
        gamerules_gamerulevisitor.visit(gamerules_gamerulekey, gamerules_gameruledefinition);
        gamerules_gameruledefinition.callVisitor(gamerules_gamerulevisitor, gamerules_gamerulekey);
    }

    public void assignFrom(GameRules gamerules, @Nullable WorldServer minecraftserver) {
        gamerules.rules.keySet().forEach(gamerules_gamerulekey -> this.assignCap((GameRuleKey)gamerules_gamerulekey, gamerules, minecraftserver));
    }

    private <T extends GameRuleValue<T>> void assignCap(GameRuleKey<T> gamerules_gamerulekey, GameRules gamerules, @Nullable WorldServer minecraftserver) {
        T t0 = gamerules.getRule(gamerules_gamerulekey);
        ((GameRuleValue)this.getRule(gamerules_gamerulekey)).setFrom(t0, minecraftserver);
    }

    public boolean getBoolean(GameRuleKey<GameRuleBoolean> gamerules_gamerulekey) {
        return this.getRule(gamerules_gamerulekey).get();
    }

    public int getInt(GameRuleKey<GameRuleInt> gamerules_gamerulekey) {
        return this.getRule(gamerules_gamerulekey).get();
    }

    public static final class GameRuleKey<T extends GameRuleValue<T>> {
        final String id;
        private final GameRuleCategory category;

        public GameRuleKey(String s2, GameRuleCategory gamerules_gamerulecategory) {
            this.id = s2;
            this.category = gamerules_gamerulecategory;
        }

        public String toString() {
            return this.id;
        }

        public boolean equals(Object object) {
            return this == object ? true : object instanceof GameRuleKey && ((GameRuleKey)object).id.equals(this.id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public String getId() {
            return this.id;
        }

        public String getDescriptionId() {
            return "gamerule." + this.id;
        }

        public GameRuleCategory getCategory() {
            return this.category;
        }
    }

    public static enum GameRuleCategory {
        PLAYER("gamerule.category.player"),
        MOBS("gamerule.category.mobs"),
        SPAWNING("gamerule.category.spawning"),
        DROPS("gamerule.category.drops"),
        UPDATES("gamerule.category.updates"),
        CHAT("gamerule.category.chat"),
        MISC("gamerule.category.misc");

        private final String descriptionId;

        private GameRuleCategory(String s2) {
            this.descriptionId = s2;
        }

        public String getDescriptionId() {
            return this.descriptionId;
        }
    }

    public static class GameRuleDefinition<T extends GameRuleValue<T>> {
        final Supplier<ArgumentType<?>> argument;
        private final Function<GameRuleDefinition<T>, T> constructor;
        final BiConsumer<WorldServer, T> callback;
        private final h<T> visitorCaller;

        GameRuleDefinition(Supplier<ArgumentType<?>> supplier, Function<GameRuleDefinition<T>, T> function, BiConsumer<WorldServer, T> biconsumer, h<T> gamerules_h) {
            this.argument = supplier;
            this.constructor = function;
            this.callback = biconsumer;
            this.visitorCaller = gamerules_h;
        }

        public RequiredArgumentBuilder<CommandListenerWrapper, ?> createArgument(String s2) {
            return CommandDispatcher.argument(s2, this.argument.get());
        }

        public T createRule() {
            return (T)((GameRuleValue)this.constructor.apply(this));
        }

        public void callVisitor(GameRuleVisitor gamerules_gamerulevisitor, GameRuleKey<T> gamerules_gamerulekey) {
            this.visitorCaller.call(gamerules_gamerulevisitor, gamerules_gamerulekey, this);
        }
    }

    public static abstract class GameRuleValue<T extends GameRuleValue<T>> {
        protected final GameRuleDefinition<T> type;

        public GameRuleValue(GameRuleDefinition<T> gamerules_gameruledefinition) {
            this.type = gamerules_gameruledefinition;
        }

        protected abstract void updateFromArgument(CommandContext<CommandListenerWrapper> var1, String var2);

        public void setFromArgument(CommandContext<CommandListenerWrapper> commandcontext, String s2) {
            this.updateFromArgument(commandcontext, s2);
            this.onChanged(((CommandListenerWrapper)commandcontext.getSource()).getLevel());
        }

        public void onChanged(@Nullable WorldServer minecraftserver) {
            if (minecraftserver != null) {
                this.type.callback.accept(minecraftserver, (WorldServer)this.getSelf());
            }
        }

        public abstract void deserialize(String var1);

        public abstract String serialize();

        public String toString() {
            return this.serialize();
        }

        public abstract int getCommandResult();

        protected abstract T getSelf();

        protected abstract T copy();

        public abstract void setFrom(T var1, @Nullable WorldServer var2);
    }

    public static interface GameRuleVisitor {
        default public <T extends GameRuleValue<T>> void visit(GameRuleKey<T> gamerules_gamerulekey, GameRuleDefinition<T> gamerules_gameruledefinition) {
        }

        default public void visitBoolean(GameRuleKey<GameRuleBoolean> gamerules_gamerulekey, GameRuleDefinition<GameRuleBoolean> gamerules_gameruledefinition) {
        }

        default public void visitInteger(GameRuleKey<GameRuleInt> gamerules_gamerulekey, GameRuleDefinition<GameRuleInt> gamerules_gameruledefinition) {
        }
    }

    public static class GameRuleBoolean
    extends GameRuleValue<GameRuleBoolean> {
        private boolean value;

        static GameRuleDefinition<GameRuleBoolean> create(boolean flag, BiConsumer<WorldServer, GameRuleBoolean> biconsumer) {
            return new GameRuleDefinition<GameRuleBoolean>(BoolArgumentType::bool, gamerules_gameruledefinition -> new GameRuleBoolean((GameRuleDefinition<GameRuleBoolean>)gamerules_gameruledefinition, flag), biconsumer, GameRuleVisitor::visitBoolean);
        }

        static GameRuleDefinition<GameRuleBoolean> create(boolean flag) {
            return GameRuleBoolean.create(flag, (minecraftserver, gamerules_gameruleboolean) -> {});
        }

        public GameRuleBoolean(GameRuleDefinition<GameRuleBoolean> gamerules_gameruledefinition, boolean flag) {
            super(gamerules_gameruledefinition);
            this.value = flag;
        }

        @Override
        protected void updateFromArgument(CommandContext<CommandListenerWrapper> commandcontext, String s2) {
            this.value = BoolArgumentType.getBool(commandcontext, (String)s2);
        }

        public boolean get() {
            return this.value;
        }

        public void set(boolean flag, @Nullable WorldServer minecraftserver) {
            this.value = flag;
            this.onChanged(minecraftserver);
        }

        @Override
        public String serialize() {
            return Boolean.toString(this.value);
        }

        @Override
        public void deserialize(String s2) {
            this.value = Boolean.parseBoolean(s2);
        }

        @Override
        public int getCommandResult() {
            return this.value ? 1 : 0;
        }

        @Override
        protected GameRuleBoolean getSelf() {
            return this;
        }

        @Override
        protected GameRuleBoolean copy() {
            return new GameRuleBoolean(this.type, this.value);
        }

        @Override
        public void setFrom(GameRuleBoolean gamerules_gameruleboolean, @Nullable WorldServer minecraftserver) {
            this.value = gamerules_gameruleboolean.value;
            this.onChanged(minecraftserver);
        }
    }

    public static class GameRuleInt
    extends GameRuleValue<GameRuleInt> {
        private int value;

        private static GameRuleDefinition<GameRuleInt> create(int i2, BiConsumer<WorldServer, GameRuleInt> biconsumer) {
            return new GameRuleDefinition<GameRuleInt>(IntegerArgumentType::integer, gamerules_gameruledefinition -> new GameRuleInt((GameRuleDefinition<GameRuleInt>)gamerules_gameruledefinition, i2), biconsumer, GameRuleVisitor::visitInteger);
        }

        static GameRuleDefinition<GameRuleInt> create(int i2, int j2, int k2, BiConsumer<WorldServer, GameRuleInt> biconsumer) {
            return new GameRuleDefinition<GameRuleInt>(() -> IntegerArgumentType.integer((int)j2, (int)k2), gamerules_gameruledefinition -> new GameRuleInt((GameRuleDefinition<GameRuleInt>)gamerules_gameruledefinition, i2), biconsumer, GameRuleVisitor::visitInteger);
        }

        static GameRuleDefinition<GameRuleInt> create(int i2) {
            return GameRuleInt.create(i2, (minecraftserver, gamerules_gameruleint) -> {});
        }

        public GameRuleInt(GameRuleDefinition<GameRuleInt> gamerules_gameruledefinition, int i2) {
            super(gamerules_gameruledefinition);
            this.value = i2;
        }

        @Override
        protected void updateFromArgument(CommandContext<CommandListenerWrapper> commandcontext, String s2) {
            this.value = IntegerArgumentType.getInteger(commandcontext, (String)s2);
        }

        public int get() {
            return this.value;
        }

        public void set(int i2, @Nullable WorldServer minecraftserver) {
            this.value = i2;
            this.onChanged(minecraftserver);
        }

        @Override
        public String serialize() {
            return Integer.toString(this.value);
        }

        @Override
        public void deserialize(String s2) {
            this.value = GameRuleInt.safeParse(s2);
        }

        public boolean tryDeserialize(String s2) {
            try {
                StringReader stringreader = new StringReader(s2);
                this.value = (Integer)this.type.argument.get().parse(stringreader);
                return !stringreader.canRead();
            }
            catch (CommandSyntaxException commandsyntaxexception) {
                return false;
            }
        }

        private static int safeParse(String s2) {
            if (!s2.isEmpty()) {
                try {
                    return Integer.parseInt(s2);
                }
                catch (NumberFormatException numberformatexception) {
                    LOGGER.warn("Failed to parse integer {}", (Object)s2);
                }
            }
            return 0;
        }

        @Override
        public int getCommandResult() {
            return this.value;
        }

        @Override
        protected GameRuleInt getSelf() {
            return this;
        }

        @Override
        protected GameRuleInt copy() {
            return new GameRuleInt(this.type, this.value);
        }

        @Override
        public void setFrom(GameRuleInt gamerules_gameruleint, @Nullable WorldServer minecraftserver) {
            this.value = gamerules_gameruleint.value;
            this.onChanged(minecraftserver);
        }
    }

    private static interface h<T extends GameRuleValue<T>> {
        public void call(GameRuleVisitor var1, GameRuleKey<T> var2, GameRuleDefinition<T> var3);
    }
}

