/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.ICombinedAccess;
import net.minecraft.world.level.IWorldTime;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.IChunkProvider;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.redstone.NeighborUpdater;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.ticks.LevelTickAccess;
import net.minecraft.world.ticks.NextTickListEntry;
import net.minecraft.world.ticks.TickListPriority;

public interface GeneratorAccess
extends ICombinedAccess,
IWorldTime {
    @Override
    default public long dayTime() {
        return this.getLevelData().getDayTime();
    }

    public long nextSubTickCount();

    public LevelTickAccess<Block> getBlockTicks();

    private <T> NextTickListEntry<T> createTick(BlockPosition blockposition, T t0, int i2, TickListPriority ticklistpriority) {
        return new NextTickListEntry<T>(t0, blockposition, this.getLevelData().getGameTime() + (long)i2, ticklistpriority, this.nextSubTickCount());
    }

    private <T> NextTickListEntry<T> createTick(BlockPosition blockposition, T t0, int i2) {
        return new NextTickListEntry<T>(t0, blockposition, this.getLevelData().getGameTime() + (long)i2, this.nextSubTickCount());
    }

    default public void scheduleTick(BlockPosition blockposition, Block block, int i2, TickListPriority ticklistpriority) {
        this.getBlockTicks().schedule(this.createTick(blockposition, block, i2, ticklistpriority));
    }

    default public void scheduleTick(BlockPosition blockposition, Block block, int i2) {
        this.getBlockTicks().schedule(this.createTick(blockposition, block, i2));
    }

    public LevelTickAccess<FluidType> getFluidTicks();

    default public void scheduleTick(BlockPosition blockposition, FluidType fluidtype, int i2, TickListPriority ticklistpriority) {
        this.getFluidTicks().schedule(this.createTick(blockposition, fluidtype, i2, ticklistpriority));
    }

    default public void scheduleTick(BlockPosition blockposition, FluidType fluidtype, int i2) {
        this.getFluidTicks().schedule(this.createTick(blockposition, fluidtype, i2));
    }

    public WorldData getLevelData();

    public DifficultyDamageScaler getCurrentDifficultyAt(BlockPosition var1);

    @Nullable
    public MinecraftServer getServer();

    default public EnumDifficulty getDifficulty() {
        return this.getLevelData().getDifficulty();
    }

    public IChunkProvider getChunkSource();

    @Override
    default public boolean hasChunk(int i2, int j2) {
        return this.getChunkSource().hasChunk(i2, j2);
    }

    public RandomSource getRandom();

    default public void blockUpdated(BlockPosition blockposition, Block block) {
    }

    default public void neighborShapeChanged(EnumDirection enumdirection, IBlockData iblockdata, BlockPosition blockposition, BlockPosition blockposition1, int i2, int j2) {
        NeighborUpdater.executeShapeUpdate(this, enumdirection, iblockdata, blockposition, blockposition1, i2, j2 - 1);
    }

    default public void playSound(@Nullable EntityHuman entityhuman, BlockPosition blockposition, SoundEffect soundeffect, SoundCategory soundcategory) {
        this.playSound(entityhuman, blockposition, soundeffect, soundcategory, 1.0f, 1.0f);
    }

    public void playSound(@Nullable EntityHuman var1, BlockPosition var2, SoundEffect var3, SoundCategory var4, float var5, float var6);

    public void addParticle(ParticleParam var1, double var2, double var4, double var6, double var8, double var10, double var12);

    public void levelEvent(@Nullable EntityHuman var1, int var2, BlockPosition var3, int var4);

    default public void levelEvent(int i2, BlockPosition blockposition, int j2) {
        this.levelEvent(null, i2, blockposition, j2);
    }

    public void gameEvent(Holder<GameEvent> var1, Vec3D var2, GameEvent.a var3);

    default public void gameEvent(@Nullable Entity entity, Holder<GameEvent> holder, Vec3D vec3d) {
        this.gameEvent(holder, vec3d, new GameEvent.a(entity, null));
    }

    default public void gameEvent(@Nullable Entity entity, Holder<GameEvent> holder, BlockPosition blockposition) {
        this.gameEvent(holder, blockposition, new GameEvent.a(entity, null));
    }

    default public void gameEvent(Holder<GameEvent> holder, BlockPosition blockposition, GameEvent.a gameevent_a) {
        this.gameEvent(holder, Vec3D.atCenterOf(blockposition), gameevent_a);
    }

    default public void gameEvent(ResourceKey<GameEvent> resourcekey, BlockPosition blockposition, GameEvent.a gameevent_a) {
        this.gameEvent(this.registryAccess().registryOrThrow(Registries.GAME_EVENT).getHolderOrThrow(resourcekey), blockposition, gameevent_a);
    }

    public WorldServer getMinecraftWorld();
}

