/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;

public interface LevelHeightAccessor {
    public int getHeight();

    public int getMinBuildHeight();

    default public int getMaxBuildHeight() {
        return this.getMinBuildHeight() + this.getHeight();
    }

    default public int getSectionsCount() {
        return this.getMaxSection() - this.getMinSection();
    }

    default public int getMinSection() {
        return SectionPosition.blockToSectionCoord(this.getMinBuildHeight());
    }

    default public int getMaxSection() {
        return SectionPosition.blockToSectionCoord(this.getMaxBuildHeight() - 1) + 1;
    }

    default public boolean isOutsideBuildHeight(BlockPosition var0) {
        return this.isOutsideBuildHeight(var0.getY());
    }

    default public boolean isOutsideBuildHeight(int var0) {
        return var0 < this.getMinBuildHeight() || var0 >= this.getMaxBuildHeight();
    }

    default public int getSectionIndex(int var0) {
        return this.getSectionIndexFromSectionY(SectionPosition.blockToSectionCoord(var0));
    }

    default public int getSectionIndexFromSectionY(int var0) {
        return var0 - this.getMinSection();
    }

    default public int getSectionYFromSectionIndex(int var0) {
        return var0 + this.getMinSection();
    }

    public static LevelHeightAccessor create(final int var0, final int var1) {
        return new LevelHeightAccessor(){

            @Override
            public int getHeight() {
                return var1;
            }

            @Override
            public int getMinBuildHeight() {
                return var0;
            }
        };
    }
}

