/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPositionTypes;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.animal.EntityOcelot;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.LocalMobCapCalculator;
import net.minecraft.world.level.SpawnerCreatureProbabilities;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeSettingsMobs;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.structures.NetherFortressStructure;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftSpawnCategory;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.slf4j.Logger;

public final class SpawnerCreature {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int MIN_SPAWN_DISTANCE = 24;
    public static final int SPAWN_DISTANCE_CHUNK = 8;
    public static final int SPAWN_DISTANCE_BLOCK = 128;
    static final int MAGIC_NUMBER = (int)Math.pow(17.0, 2.0);
    private static final EnumCreatureType[] SPAWNING_CATEGORIES = (EnumCreatureType[])Stream.of(EnumCreatureType.values()).filter(enumcreaturetype -> enumcreaturetype != EnumCreatureType.MISC).toArray(EnumCreatureType[]::new);

    private SpawnerCreature() {
    }

    public static d createState(int i2, Iterable<Entity> iterable, b spawnercreature_b, LocalMobCapCalculator localmobcapcalculator) {
        SpawnerCreatureProbabilities spawnercreatureprobabilities = new SpawnerCreatureProbabilities();
        Object2IntOpenHashMap object2intopenhashmap = new Object2IntOpenHashMap();
        for (Entity entity : iterable) {
            EnumCreatureType enumcreaturetype;
            EntityInsentient entityinsentient;
            if (entity instanceof EntityInsentient && ((entityinsentient = (EntityInsentient)entity).isPersistenceRequired() || entityinsentient.requiresCustomPersistence()) || (enumcreaturetype = entity.getType().getCategory()) == EnumCreatureType.MISC) continue;
            BlockPosition blockposition = entity.blockPosition();
            spawnercreature_b.query(ChunkCoordIntPair.asLong(blockposition), chunk -> {
                BiomeSettingsMobs.b biomesettingsmobs_b = SpawnerCreature.getRoughBiome(blockposition, chunk).getMobSettings().getMobSpawnCost(entity.getType());
                if (biomesettingsmobs_b != null) {
                    spawnercreatureprobabilities.addCharge(entity.blockPosition(), biomesettingsmobs_b.charge());
                }
                if (entity instanceof EntityInsentient) {
                    localmobcapcalculator.addMob(chunk.getPos(), enumcreaturetype);
                }
                object2intopenhashmap.addTo((Object)enumcreaturetype, 1);
            });
        }
        return new d(i2, (Object2IntOpenHashMap<EnumCreatureType>)object2intopenhashmap, spawnercreatureprobabilities, localmobcapcalculator);
    }

    static BiomeBase getRoughBiome(BlockPosition blockposition, IChunkAccess ichunkaccess) {
        return ichunkaccess.getNoiseBiome(QuartPos.fromBlock(blockposition.getX()), QuartPos.fromBlock(blockposition.getY()), QuartPos.fromBlock(blockposition.getZ())).value();
    }

    public static void spawnForChunk(WorldServer worldserver, Chunk chunk, d spawnercreature_d, boolean flag, boolean flag1, boolean flag2) {
        worldserver.getProfiler().push("spawner");
        worldserver.timings.mobSpawn.startTiming();
        EnumCreatureType[] aenumcreaturetype = SPAWNING_CATEGORIES;
        int i2 = aenumcreaturetype.length;
        WorldData worlddata = worldserver.getLevelData();
        for (int j2 = 0; j2 < i2; ++j2) {
            EnumCreatureType enumcreaturetype = aenumcreaturetype[j2];
            boolean spawnThisTick = true;
            int limit = enumcreaturetype.getMaxInstancesPerChunk();
            SpawnCategory spawnCategory = CraftSpawnCategory.toBukkit(enumcreaturetype);
            if (CraftSpawnCategory.isValidForLimits(spawnCategory)) {
                spawnThisTick = worldserver.ticksPerSpawnCategory.getLong((Object)spawnCategory) != 0L && worlddata.getGameTime() % worldserver.ticksPerSpawnCategory.getLong((Object)spawnCategory) == 0L;
                limit = worldserver.getWorld().getSpawnLimit(spawnCategory);
            }
            if (!spawnThisTick || limit == 0 || !flag && enumcreaturetype.isFriendly() || !flag1 && !enumcreaturetype.isFriendly() || !flag2 && enumcreaturetype.isPersistent() || !spawnercreature_d.canSpawnForCategory(enumcreaturetype, chunk.getPos(), limit)) continue;
            Objects.requireNonNull(spawnercreature_d);
            c spawnercreature_c = spawnercreature_d::canSpawn;
            Objects.requireNonNull(spawnercreature_d);
            SpawnerCreature.spawnCategoryForChunk(enumcreaturetype, worldserver, chunk, spawnercreature_c, spawnercreature_d::afterSpawn);
        }
        worldserver.timings.mobSpawn.stopTiming();
        worldserver.getProfiler().pop();
    }

    public static void spawnCategoryForChunk(EnumCreatureType enumcreaturetype, WorldServer worldserver, Chunk chunk, c spawnercreature_c, a spawnercreature_a) {
        BlockPosition blockposition = SpawnerCreature.getRandomPosWithin(worldserver, chunk);
        if (blockposition.getY() >= worldserver.getMinBuildHeight() + 1) {
            SpawnerCreature.spawnCategoryForPosition(enumcreaturetype, worldserver, chunk, blockposition, spawnercreature_c, spawnercreature_a);
        }
    }

    @VisibleForDebug
    public static void spawnCategoryForPosition(EnumCreatureType enumcreaturetype, WorldServer worldserver, BlockPosition blockposition) {
        SpawnerCreature.spawnCategoryForPosition(enumcreaturetype, worldserver, worldserver.getChunk(blockposition), blockposition, (entitytypes, blockposition1, ichunkaccess) -> true, (entityinsentient, ichunkaccess) -> {});
    }

    public static void spawnCategoryForPosition(EnumCreatureType enumcreaturetype, WorldServer worldserver, IChunkAccess ichunkaccess, BlockPosition blockposition, c spawnercreature_c, a spawnercreature_a) {
        StructureManager structuremanager = worldserver.structureManager();
        ChunkGenerator chunkgenerator = worldserver.getChunkSource().getGenerator();
        int i2 = blockposition.getY();
        IBlockData iblockdata = ichunkaccess.getBlockState(blockposition);
        if (!iblockdata.isRedstoneConductor(ichunkaccess, blockposition)) {
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
            int j2 = 0;
            block0: for (int k2 = 0; k2 < 3; ++k2) {
                int l2 = blockposition.getX();
                int i1 = blockposition.getZ();
                boolean flag = true;
                BiomeSettingsMobs.c biomesettingsmobs_c = null;
                GroupDataEntity groupdataentity = null;
                int j1 = MathHelper.ceil(worldserver.random.nextFloat() * 4.0f);
                int k1 = 0;
                for (int l1 = 0; l1 < j1; ++l1) {
                    double d2;
                    blockposition_mutableblockposition.set(l2 += worldserver.random.nextInt(6) - worldserver.random.nextInt(6), i2, i1 += worldserver.random.nextInt(6) - worldserver.random.nextInt(6));
                    double d0 = (double)l2 + 0.5;
                    double d1 = (double)i1 + 0.5;
                    EntityHuman entityhuman = worldserver.getNearestPlayer(d0, (double)i2, d1, -1.0, false);
                    if (entityhuman == null || !SpawnerCreature.isRightDistanceToPlayerAndSpawnPoint(worldserver, ichunkaccess, blockposition_mutableblockposition, d2 = entityhuman.distanceToSqr(d0, i2, d1))) continue;
                    if (biomesettingsmobs_c == null) {
                        Optional<BiomeSettingsMobs.c> optional = SpawnerCreature.getRandomSpawnMobAt(worldserver, structuremanager, chunkgenerator, enumcreaturetype, worldserver.random, blockposition_mutableblockposition);
                        if (optional.isEmpty()) continue block0;
                        biomesettingsmobs_c = optional.get();
                        j1 = biomesettingsmobs_c.minCount + worldserver.random.nextInt(1 + biomesettingsmobs_c.maxCount - biomesettingsmobs_c.minCount);
                    }
                    if (!SpawnerCreature.isValidSpawnPostitionForType(worldserver, enumcreaturetype, structuremanager, chunkgenerator, biomesettingsmobs_c, blockposition_mutableblockposition, d2) || !spawnercreature_c.test(biomesettingsmobs_c.type, blockposition_mutableblockposition, ichunkaccess)) continue;
                    EntityInsentient entityinsentient = SpawnerCreature.getMobForSpawn(worldserver, biomesettingsmobs_c.type);
                    if (entityinsentient == null) {
                        return;
                    }
                    entityinsentient.moveTo(d0, i2, d1, worldserver.random.nextFloat() * 360.0f, 0.0f);
                    if (!SpawnerCreature.isValidPositionForMob(worldserver, entityinsentient, d2)) continue;
                    groupdataentity = entityinsentient.finalizeSpawn(worldserver, worldserver.getCurrentDifficultyAt(entityinsentient.blockPosition()), EnumMobSpawn.NATURAL, groupdataentity);
                    worldserver.addFreshEntityWithPassengers(entityinsentient, entityinsentient instanceof EntityOcelot && !((Ageable)entityinsentient.getBukkitEntity()).isAdult() ? CreatureSpawnEvent.SpawnReason.OCELOT_BABY : CreatureSpawnEvent.SpawnReason.NATURAL);
                    if (!entityinsentient.isRemoved()) {
                        ++j2;
                        ++k1;
                        spawnercreature_a.run(entityinsentient, ichunkaccess);
                    }
                    if (j2 >= entityinsentient.getMaxSpawnClusterSize()) {
                        return;
                    }
                    if (entityinsentient.isMaxGroupSizeReached(k1)) continue block0;
                }
            }
        }
    }

    private static boolean isRightDistanceToPlayerAndSpawnPoint(WorldServer worldserver, IChunkAccess ichunkaccess, BlockPosition.MutableBlockPosition blockposition_mutableblockposition, double d0) {
        return d0 <= 576.0 ? false : (worldserver.getSharedSpawnPos().closerToCenterThan(new Vec3D((double)blockposition_mutableblockposition.getX() + 0.5, blockposition_mutableblockposition.getY(), (double)blockposition_mutableblockposition.getZ() + 0.5), 24.0) ? false : Objects.equals(new ChunkCoordIntPair(blockposition_mutableblockposition), ichunkaccess.getPos()) || worldserver.isNaturalSpawningAllowed(blockposition_mutableblockposition));
    }

    private static boolean isValidSpawnPostitionForType(WorldServer worldserver, EnumCreatureType enumcreaturetype, StructureManager structuremanager, ChunkGenerator chunkgenerator, BiomeSettingsMobs.c biomesettingsmobs_c, BlockPosition.MutableBlockPosition blockposition_mutableblockposition, double d0) {
        EntityTypes<?> entitytypes = biomesettingsmobs_c.type;
        return entitytypes.getCategory() == EnumCreatureType.MISC ? false : (!entitytypes.canSpawnFarFromPlayer() && d0 > (double)(entitytypes.getCategory().getDespawnDistance() * entitytypes.getCategory().getDespawnDistance()) ? false : (entitytypes.canSummon() && SpawnerCreature.canSpawnMobAt(worldserver, structuremanager, chunkgenerator, enumcreaturetype, biomesettingsmobs_c, blockposition_mutableblockposition) ? (!EntityPositionTypes.isSpawnPositionOk(entitytypes, worldserver, blockposition_mutableblockposition) ? false : (!EntityPositionTypes.checkSpawnRules(entitytypes, worldserver, EnumMobSpawn.NATURAL, blockposition_mutableblockposition, worldserver.random) ? false : worldserver.noCollision(entitytypes.getSpawnAABB((double)blockposition_mutableblockposition.getX() + 0.5, blockposition_mutableblockposition.getY(), (double)blockposition_mutableblockposition.getZ() + 0.5)))) : false));
    }

    @Nullable
    private static EntityInsentient getMobForSpawn(WorldServer worldserver, EntityTypes<?> entitytypes) {
        try {
            Object entity = entitytypes.create(worldserver);
            if (entity instanceof EntityInsentient) {
                EntityInsentient entityinsentient = (EntityInsentient)entity;
                return entityinsentient;
            }
            LOGGER.warn("Can't spawn entity of type: {}", (Object)BuiltInRegistries.ENTITY_TYPE.getKey(entitytypes));
        }
        catch (Exception exception) {
            LOGGER.warn("Failed to create mob", (Throwable)exception);
        }
        return null;
    }

    private static boolean isValidPositionForMob(WorldServer worldserver, EntityInsentient entityinsentient, double d0) {
        return d0 > (double)(entityinsentient.getType().getCategory().getDespawnDistance() * entityinsentient.getType().getCategory().getDespawnDistance()) && entityinsentient.removeWhenFarAway(d0) ? false : entityinsentient.checkSpawnRules(worldserver, EnumMobSpawn.NATURAL) && entityinsentient.checkSpawnObstruction(worldserver);
    }

    private static Optional<BiomeSettingsMobs.c> getRandomSpawnMobAt(WorldServer worldserver, StructureManager structuremanager, ChunkGenerator chunkgenerator, EnumCreatureType enumcreaturetype, RandomSource randomsource, BlockPosition blockposition) {
        Holder<BiomeBase> holder = worldserver.getBiome(blockposition);
        return enumcreaturetype == EnumCreatureType.WATER_AMBIENT && holder.is(BiomeTags.REDUCED_WATER_AMBIENT_SPAWNS) && randomsource.nextFloat() < 0.98f ? Optional.empty() : SpawnerCreature.mobsAt(worldserver, structuremanager, chunkgenerator, enumcreaturetype, blockposition, holder).getRandom(randomsource);
    }

    private static boolean canSpawnMobAt(WorldServer worldserver, StructureManager structuremanager, ChunkGenerator chunkgenerator, EnumCreatureType enumcreaturetype, BiomeSettingsMobs.c biomesettingsmobs_c, BlockPosition blockposition) {
        return SpawnerCreature.mobsAt(worldserver, structuremanager, chunkgenerator, enumcreaturetype, blockposition, null).unwrap().contains(biomesettingsmobs_c);
    }

    private static WeightedRandomList<BiomeSettingsMobs.c> mobsAt(WorldServer worldserver, StructureManager structuremanager, ChunkGenerator chunkgenerator, EnumCreatureType enumcreaturetype, BlockPosition blockposition, @Nullable Holder<BiomeBase> holder) {
        return SpawnerCreature.isInNetherFortressBounds(blockposition, worldserver, enumcreaturetype, structuremanager) ? NetherFortressStructure.FORTRESS_ENEMIES : chunkgenerator.getMobsAt(holder != null ? holder : worldserver.getBiome(blockposition), structuremanager, enumcreaturetype, blockposition);
    }

    public static boolean isInNetherFortressBounds(BlockPosition blockposition, WorldServer worldserver, EnumCreatureType enumcreaturetype, StructureManager structuremanager) {
        if (enumcreaturetype == EnumCreatureType.MONSTER && worldserver.getBlockState(blockposition.below()).is(Blocks.NETHER_BRICKS)) {
            Structure structure = structuremanager.registryAccess().registryOrThrow(Registries.STRUCTURE).get(BuiltinStructures.FORTRESS);
            return structure == null ? false : structuremanager.getStructureAt(blockposition, structure).isValid();
        }
        return false;
    }

    private static BlockPosition getRandomPosWithin(World world, Chunk chunk) {
        ChunkCoordIntPair chunkcoordintpair = chunk.getPos();
        int i2 = chunkcoordintpair.getMinBlockX() + world.random.nextInt(16);
        int j2 = chunkcoordintpair.getMinBlockZ() + world.random.nextInt(16);
        int k2 = chunk.getHeight(HeightMap.Type.WORLD_SURFACE, i2, j2) + 1;
        int l2 = MathHelper.randomBetweenInclusive(world.random, world.getMinBuildHeight(), k2);
        return new BlockPosition(i2, l2, j2);
    }

    public static boolean isValidEmptySpawnBlock(IBlockAccess iblockaccess, BlockPosition blockposition, IBlockData iblockdata, Fluid fluid, EntityTypes<?> entitytypes) {
        return iblockdata.isCollisionShapeFullBlock(iblockaccess, blockposition) ? false : (iblockdata.isSignalSource() ? false : (!fluid.isEmpty() ? false : (iblockdata.is(TagsBlock.PREVENT_MOB_SPAWNING_INSIDE) ? false : !entitytypes.isBlockDangerous(iblockdata))));
    }

    public static void spawnMobsForChunkGeneration(WorldAccess worldaccess, Holder<BiomeBase> holder, ChunkCoordIntPair chunkcoordintpair, RandomSource randomsource) {
        BiomeSettingsMobs biomesettingsmobs = holder.value().getMobSettings();
        WeightedRandomList<BiomeSettingsMobs.c> weightedrandomlist = biomesettingsmobs.getMobs(EnumCreatureType.CREATURE);
        if (!weightedrandomlist.isEmpty()) {
            int i2 = chunkcoordintpair.getMinBlockX();
            int j2 = chunkcoordintpair.getMinBlockZ();
            while (randomsource.nextFloat() < biomesettingsmobs.getCreatureProbability()) {
                Optional<BiomeSettingsMobs.c> optional = weightedrandomlist.getRandom(randomsource);
                if (optional.isEmpty()) continue;
                BiomeSettingsMobs.c biomesettingsmobs_c = optional.get();
                int k2 = biomesettingsmobs_c.minCount + randomsource.nextInt(1 + biomesettingsmobs_c.maxCount - biomesettingsmobs_c.minCount);
                GroupDataEntity groupdataentity = null;
                int l2 = i2 + randomsource.nextInt(16);
                int i1 = j2 + randomsource.nextInt(16);
                int j1 = l2;
                int k1 = i1;
                for (int l1 = 0; l1 < k2; ++l1) {
                    boolean flag = false;
                    for (int i22 = 0; !flag && i22 < 4; ++i22) {
                        BlockPosition blockposition = SpawnerCreature.getTopNonCollidingPos(worldaccess, biomesettingsmobs_c.type, l2, i1);
                        if (biomesettingsmobs_c.type.canSummon() && EntityPositionTypes.isSpawnPositionOk(biomesettingsmobs_c.type, worldaccess, blockposition)) {
                            EntityInsentient entityinsentient;
                            Object entity;
                            float f2 = biomesettingsmobs_c.type.getWidth();
                            double d0 = MathHelper.clamp((double)l2, (double)i2 + (double)f2, (double)i2 + 16.0 - (double)f2);
                            double d1 = MathHelper.clamp((double)i1, (double)j2 + (double)f2, (double)j2 + 16.0 - (double)f2);
                            if (!worldaccess.noCollision(biomesettingsmobs_c.type.getSpawnAABB(d0, blockposition.getY(), d1)) || !EntityPositionTypes.checkSpawnRules(biomesettingsmobs_c.type, worldaccess, EnumMobSpawn.CHUNK_GENERATION, BlockPosition.containing(d0, blockposition.getY(), d1), worldaccess.getRandom())) continue;
                            try {
                                entity = biomesettingsmobs_c.type.create(worldaccess.getLevel());
                            }
                            catch (Exception exception) {
                                LOGGER.warn("Failed to create mob", (Throwable)exception);
                                continue;
                            }
                            if (entity == null) continue;
                            ((Entity)entity).moveTo(d0, blockposition.getY(), d1, randomsource.nextFloat() * 360.0f, 0.0f);
                            if (entity instanceof EntityInsentient && (entityinsentient = (EntityInsentient)entity).checkSpawnRules(worldaccess, EnumMobSpawn.CHUNK_GENERATION) && entityinsentient.checkSpawnObstruction(worldaccess)) {
                                groupdataentity = entityinsentient.finalizeSpawn(worldaccess, worldaccess.getCurrentDifficultyAt(entityinsentient.blockPosition()), EnumMobSpawn.CHUNK_GENERATION, groupdataentity);
                                worldaccess.addFreshEntityWithPassengers(entityinsentient, CreatureSpawnEvent.SpawnReason.CHUNK_GEN);
                                flag = true;
                            }
                        }
                        l2 += randomsource.nextInt(5) - randomsource.nextInt(5);
                        i1 += randomsource.nextInt(5) - randomsource.nextInt(5);
                        while (l2 < i2 || l2 >= i2 + 16 || i1 < j2 || i1 >= j2 + 16) {
                            l2 = j1 + randomsource.nextInt(5) - randomsource.nextInt(5);
                            i1 = k1 + randomsource.nextInt(5) - randomsource.nextInt(5);
                        }
                    }
                }
            }
        }
    }

    private static BlockPosition getTopNonCollidingPos(IWorldReader iworldreader, EntityTypes<?> entitytypes, int i2, int j2) {
        int k2 = iworldreader.getHeight(EntityPositionTypes.getHeightmapType(entitytypes), i2, j2);
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition(i2, k2, j2);
        if (iworldreader.dimensionType().hasCeiling()) {
            do {
                blockposition_mutableblockposition.move(EnumDirection.DOWN);
            } while (!iworldreader.getBlockState(blockposition_mutableblockposition).isAir());
            do {
                blockposition_mutableblockposition.move(EnumDirection.DOWN);
            } while (iworldreader.getBlockState(blockposition_mutableblockposition).isAir() && blockposition_mutableblockposition.getY() > iworldreader.getMinBuildHeight());
        }
        return EntityPositionTypes.getPlacementType(entitytypes).adjustSpawnPosition(iworldreader, blockposition_mutableblockposition.immutable());
    }

    @FunctionalInterface
    public static interface b {
        public void query(long var1, Consumer<Chunk> var3);
    }

    public static class d {
        private final int spawnableChunkCount;
        private final Object2IntOpenHashMap<EnumCreatureType> mobCategoryCounts;
        private final SpawnerCreatureProbabilities spawnPotential;
        private final Object2IntMap<EnumCreatureType> unmodifiableMobCategoryCounts;
        private final LocalMobCapCalculator localMobCapCalculator;
        @Nullable
        private BlockPosition lastCheckedPos;
        @Nullable
        private EntityTypes<?> lastCheckedType;
        private double lastCharge;

        d(int i2, Object2IntOpenHashMap<EnumCreatureType> object2intopenhashmap, SpawnerCreatureProbabilities spawnercreatureprobabilities, LocalMobCapCalculator localmobcapcalculator) {
            this.spawnableChunkCount = i2;
            this.mobCategoryCounts = object2intopenhashmap;
            this.spawnPotential = spawnercreatureprobabilities;
            this.localMobCapCalculator = localmobcapcalculator;
            this.unmodifiableMobCategoryCounts = Object2IntMaps.unmodifiable(object2intopenhashmap);
        }

        private boolean canSpawn(EntityTypes<?> entitytypes, BlockPosition blockposition, IChunkAccess ichunkaccess) {
            double d0;
            this.lastCheckedPos = blockposition;
            this.lastCheckedType = entitytypes;
            BiomeSettingsMobs.b biomesettingsmobs_b = SpawnerCreature.getRoughBiome(blockposition, ichunkaccess).getMobSettings().getMobSpawnCost(entitytypes);
            if (biomesettingsmobs_b == null) {
                this.lastCharge = 0.0;
                return true;
            }
            this.lastCharge = d0 = biomesettingsmobs_b.charge();
            double d1 = this.spawnPotential.getPotentialEnergyChange(blockposition, d0);
            return d1 <= biomesettingsmobs_b.energyBudget();
        }

        private void afterSpawn(EntityInsentient entityinsentient, IChunkAccess ichunkaccess) {
            BiomeSettingsMobs.b biomesettingsmobs_b;
            EntityTypes<?> entitytypes = entityinsentient.getType();
            BlockPosition blockposition = entityinsentient.blockPosition();
            double d0 = blockposition.equals(this.lastCheckedPos) && entitytypes == this.lastCheckedType ? this.lastCharge : ((biomesettingsmobs_b = SpawnerCreature.getRoughBiome(blockposition, ichunkaccess).getMobSettings().getMobSpawnCost(entitytypes)) != null ? biomesettingsmobs_b.charge() : 0.0);
            this.spawnPotential.addCharge(blockposition, d0);
            EnumCreatureType enumcreaturetype = entitytypes.getCategory();
            this.mobCategoryCounts.addTo((Object)enumcreaturetype, 1);
            this.localMobCapCalculator.addMob(new ChunkCoordIntPair(blockposition), enumcreaturetype);
        }

        public int getSpawnableChunkCount() {
            return this.spawnableChunkCount;
        }

        public Object2IntMap<EnumCreatureType> getMobCategoryCounts() {
            return this.unmodifiableMobCategoryCounts;
        }

        boolean canSpawnForCategory(EnumCreatureType enumcreaturetype, ChunkCoordIntPair chunkcoordintpair, int limit) {
            int i2 = limit * this.spawnableChunkCount / MAGIC_NUMBER;
            return this.mobCategoryCounts.getInt((Object)enumcreaturetype) >= i2 ? false : this.localMobCapCalculator.canSpawn(enumcreaturetype, chunkcoordintpair);
        }
    }

    @FunctionalInterface
    public static interface c {
        public boolean test(EntityTypes<?> var1, BlockPosition var2, IChunkAccess var3);
    }

    @FunctionalInterface
    public static interface a {
        public void run(EntityInsentient var1, IChunkAccess var2);
    }
}

