/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetBorderCenterPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderLerpSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDelayPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDistancePacket;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.TickRateManager;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionBrewer;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.IWorldBorderListener;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.IChunkProvider;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.redstone.CollectingNeighborUpdater;
import net.minecraft.world.level.redstone.NeighborUpdater;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.storage.WorldDataMutable;
import net.minecraft.world.level.storage.WorldDataServer;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.Scoreboard;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R1.SpigotTimings;
import org.bukkit.craftbukkit.v1_21_R1.block.CapturedBlockState;
import org.bukkit.craftbukkit.v1_21_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftSpawnCategory;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.ChunkGenerator;
import org.spigotmc.SpigotWorldConfig;
import org.spigotmc.TickLimiter;

public abstract class World
implements GeneratorAccess,
AutoCloseable {
    public static final Codec<ResourceKey<World>> RESOURCE_KEY_CODEC = ResourceKey.codec(Registries.DIMENSION);
    public static final ResourceKey<World> OVERWORLD = ResourceKey.create(Registries.DIMENSION, MinecraftKey.withDefaultNamespace("overworld"));
    public static final ResourceKey<World> NETHER = ResourceKey.create(Registries.DIMENSION, MinecraftKey.withDefaultNamespace("the_nether"));
    public static final ResourceKey<World> END = ResourceKey.create(Registries.DIMENSION, MinecraftKey.withDefaultNamespace("the_end"));
    public static final int MAX_LEVEL_SIZE = 30000000;
    public static final int LONG_PARTICLE_CLIP_RANGE = 512;
    public static final int SHORT_PARTICLE_CLIP_RANGE = 32;
    public static final int MAX_BRIGHTNESS = 15;
    public static final int TICKS_PER_DAY = 24000;
    public static final int MAX_ENTITY_SPAWN_Y = 20000000;
    public static final int MIN_ENTITY_SPAWN_Y = -20000000;
    protected final List<TickingBlockEntity> blockEntityTickers = Lists.newArrayList();
    protected final NeighborUpdater neighborUpdater;
    private final List<TickingBlockEntity> pendingBlockEntityTickers = Lists.newArrayList();
    private boolean tickingBlockEntities;
    public final Thread thread;
    private final boolean isDebug;
    private int skyDarken;
    protected int randValue = RandomSource.create().nextInt();
    protected final int addend = 1013904223;
    protected float oRainLevel;
    public float rainLevel;
    protected float oThunderLevel;
    public float thunderLevel;
    public final RandomSource random = RandomSource.create();
    @Deprecated
    private final RandomSource threadSafeRandom = RandomSource.createThreadSafe();
    private final Holder<DimensionManager> dimensionTypeRegistration;
    public final WorldDataMutable levelData;
    private final Supplier<GameProfilerFiller> profiler;
    public final boolean isClientSide;
    private final WorldBorder worldBorder;
    private final BiomeManager biomeManager;
    private final ResourceKey<World> dimension;
    private final IRegistryCustom registryAccess;
    private final DamageSources damageSources;
    private long subTickCount;
    private final CraftWorld world;
    public boolean pvpMode;
    public ChunkGenerator generator;
    public boolean preventPoiUpdated = false;
    public boolean captureBlockStates = false;
    public boolean captureTreeGeneration = false;
    public Map<BlockPosition, CapturedBlockState> capturedBlockStates = new LinkedHashMap<BlockPosition, CapturedBlockState>();
    public Map<BlockPosition, TileEntity> capturedTileEntities = new HashMap<BlockPosition, TileEntity>();
    public List<EntityItem> captureDrops;
    public final Object2LongOpenHashMap<SpawnCategory> ticksPerSpawnCategory = new Object2LongOpenHashMap();
    public boolean populating;
    public final SpigotWorldConfig spigotConfig;
    public final SpigotTimings.WorldTimingsHandler timings;
    public static BlockPosition lastPhysicsProblem;
    private TickLimiter entityLimiter;
    private TickLimiter tileLimiter;
    private int tileTickPosition;

    public CraftWorld getWorld() {
        return this.world;
    }

    public CraftServer getCraftServer() {
        return (CraftServer)Bukkit.getServer();
    }

    public abstract ResourceKey<WorldDimension> getTypeKey();

    protected World(WorldDataMutable worlddatamutable, ResourceKey<World> resourcekey, IRegistryCustom iregistrycustom, Holder<DimensionManager> holder, Supplier<GameProfilerFiller> supplier, boolean flag, boolean flag1, long i2, int j2, ChunkGenerator gen, BiomeProvider biomeProvider, World.Environment env) {
        this.spigotConfig = new SpigotWorldConfig(((WorldDataServer)worlddatamutable).getLevelName());
        this.generator = gen;
        this.world = new CraftWorld((WorldServer)this, gen, biomeProvider, env);
        for (SpawnCategory spawnCategory : SpawnCategory.values()) {
            if (!CraftSpawnCategory.isValidForLimits(spawnCategory)) continue;
            this.ticksPerSpawnCategory.put((Object)spawnCategory, (long)this.getCraftServer().getTicksPerSpawns(spawnCategory));
        }
        this.profiler = supplier;
        this.levelData = worlddatamutable;
        this.dimensionTypeRegistration = holder;
        DimensionManager dimensionmanager = holder.value();
        this.dimension = resourcekey;
        this.isClientSide = flag;
        this.worldBorder = dimensionmanager.coordinateScale() != 1.0 ? new WorldBorder(this){

            @Override
            public double getCenterX() {
                return super.getCenterX();
            }

            @Override
            public double getCenterZ() {
                return super.getCenterZ();
            }
        } : new WorldBorder();
        this.thread = Thread.currentThread();
        this.biomeManager = new BiomeManager(this, i2);
        this.isDebug = flag1;
        this.neighborUpdater = new CollectingNeighborUpdater(this, j2);
        this.registryAccess = iregistrycustom;
        this.damageSources = new DamageSources(iregistrycustom);
        this.getWorldBorder().world = (WorldServer)this;
        this.getWorldBorder().addListener(new IWorldBorderListener(){

            @Override
            public void onBorderSizeSet(WorldBorder worldborder, double d0) {
                World.this.getCraftServer().getHandle().broadcastAll((Packet)new ClientboundSetBorderSizePacket(worldborder), worldborder.world);
            }

            @Override
            public void onBorderSizeLerping(WorldBorder worldborder, double d0, double d1, long i2) {
                World.this.getCraftServer().getHandle().broadcastAll((Packet)new ClientboundSetBorderLerpSizePacket(worldborder), worldborder.world);
            }

            @Override
            public void onBorderCenterSet(WorldBorder worldborder, double d0, double d1) {
                World.this.getCraftServer().getHandle().broadcastAll((Packet)new ClientboundSetBorderCenterPacket(worldborder), worldborder.world);
            }

            @Override
            public void onBorderSetWarningTime(WorldBorder worldborder, int i2) {
                World.this.getCraftServer().getHandle().broadcastAll((Packet)new ClientboundSetBorderWarningDelayPacket(worldborder), worldborder.world);
            }

            @Override
            public void onBorderSetWarningBlocks(WorldBorder worldborder, int i2) {
                World.this.getCraftServer().getHandle().broadcastAll((Packet)new ClientboundSetBorderWarningDistancePacket(worldborder), worldborder.world);
            }

            @Override
            public void onBorderSetDamagePerBlock(WorldBorder worldborder, double d0) {
            }

            @Override
            public void onBorderSetDamageSafeZOne(WorldBorder worldborder, double d0) {
            }
        });
        this.timings = new SpigotTimings.WorldTimingsHandler(this);
        this.entityLimiter = new TickLimiter(this.spigotConfig.entityMaxTickTime);
        this.tileLimiter = new TickLimiter(this.spigotConfig.tileMaxTickTime);
    }

    @Override
    public boolean isClientSide() {
        return this.isClientSide;
    }

    @Override
    @Nullable
    public MinecraftServer getServer() {
        return null;
    }

    public boolean isInWorldBounds(BlockPosition blockposition) {
        return !this.isOutsideBuildHeight(blockposition) && World.isInWorldBoundsHorizontal(blockposition);
    }

    public static boolean isInSpawnableBounds(BlockPosition blockposition) {
        return !World.isOutsideSpawnableHeight(blockposition.getY()) && World.isInWorldBoundsHorizontal(blockposition);
    }

    private static boolean isInWorldBoundsHorizontal(BlockPosition blockposition) {
        return blockposition.getX() >= -30000000 && blockposition.getZ() >= -30000000 && blockposition.getX() < 30000000 && blockposition.getZ() < 30000000;
    }

    private static boolean isOutsideSpawnableHeight(int i2) {
        return i2 < -20000000 || i2 >= 20000000;
    }

    public Chunk getChunkAt(BlockPosition blockposition) {
        return this.getChunk(SectionPosition.blockToSectionCoord(blockposition.getX()), SectionPosition.blockToSectionCoord(blockposition.getZ()));
    }

    @Override
    public Chunk getChunk(int i2, int j2) {
        return (Chunk)this.getChunk(i2, j2, ChunkStatus.FULL);
    }

    @Override
    @Nullable
    public IChunkAccess getChunk(int i2, int j2, ChunkStatus chunkstatus, boolean flag) {
        IChunkAccess ichunkaccess = this.getChunkSource().getChunk(i2, j2, chunkstatus, flag);
        if (ichunkaccess == null && flag) {
            throw new IllegalStateException("Should always be able to create a chunk!");
        }
        return ichunkaccess;
    }

    @Override
    public boolean setBlock(BlockPosition blockposition, IBlockData iblockdata, int i2) {
        return this.setBlock(blockposition, iblockdata, i2, 512);
    }

    @Override
    public boolean setBlock(BlockPosition blockposition, IBlockData iblockdata, int i2, int j2) {
        IBlockData iblockdata1;
        if (this.captureTreeGeneration) {
            CapturedBlockState blockstate = this.capturedBlockStates.get(blockposition);
            if (blockstate == null) {
                blockstate = CapturedBlockState.getTreeBlockState(this, blockposition, i2);
                this.capturedBlockStates.put(blockposition.immutable(), blockstate);
            }
            blockstate.setData(iblockdata);
            blockstate.setFlag(i2);
            return true;
        }
        if (this.isOutsideBuildHeight(blockposition)) {
            return false;
        }
        if (!this.isClientSide && this.isDebug()) {
            return false;
        }
        Chunk chunk = this.getChunkAt(blockposition);
        Block block = iblockdata.getBlock();
        boolean captured = false;
        if (this.captureBlockStates && !this.capturedBlockStates.containsKey(blockposition)) {
            CapturedBlockState blockstate = CapturedBlockState.getBlockState(this, blockposition, i2);
            this.capturedBlockStates.put(blockposition.immutable(), blockstate);
            captured = true;
        }
        if ((iblockdata1 = chunk.setBlockState(blockposition, iblockdata, (i2 & 0x40) != 0, (i2 & 0x400) == 0)) == null) {
            if (this.captureBlockStates && captured) {
                this.capturedBlockStates.remove(blockposition);
            }
            return false;
        }
        IBlockData iblockdata2 = this.getBlockState(blockposition);
        if (!this.captureBlockStates) {
            try {
                this.notifyAndUpdatePhysics(blockposition, chunk, iblockdata1, iblockdata, iblockdata2, i2, j2);
            }
            catch (StackOverflowError ex) {
                lastPhysicsProblem = new BlockPosition(blockposition);
            }
        }
        return true;
    }

    public void notifyAndUpdatePhysics(BlockPosition blockposition, Chunk chunk, IBlockData oldBlock, IBlockData newBlock, IBlockData actualBlock, int i2, int j2) {
        IBlockData iblockdata = newBlock;
        IBlockData iblockdata1 = oldBlock;
        IBlockData iblockdata2 = actualBlock;
        if (iblockdata2 == iblockdata) {
            if (iblockdata1 != iblockdata2) {
                this.setBlocksDirty(blockposition, iblockdata1, iblockdata2);
            }
            if ((i2 & 2) != 0 && (!this.isClientSide || (i2 & 4) == 0) && (this.isClientSide || chunk == null || chunk.getFullStatus() != null && chunk.getFullStatus().isOrAfter(FullChunkStatus.BLOCK_TICKING))) {
                this.sendBlockUpdated(blockposition, iblockdata1, iblockdata, i2);
            }
            if ((i2 & 1) != 0) {
                this.blockUpdated(blockposition, iblockdata1.getBlock());
                if (!this.isClientSide && iblockdata.hasAnalogOutputSignal()) {
                    this.updateNeighbourForOutputSignal(blockposition, newBlock.getBlock());
                }
            }
            if ((i2 & 0x10) == 0 && j2 > 0) {
                int k2 = i2 & 0xFFFFFFDE;
                iblockdata1.updateIndirectNeighbourShapes(this, blockposition, k2, j2 - 1);
                CraftWorld world = ((WorldServer)this).getWorld();
                if (world != null) {
                    BlockPhysicsEvent event = new BlockPhysicsEvent(world.getBlockAt(blockposition.getX(), blockposition.getY(), blockposition.getZ()), (BlockData)CraftBlockData.fromData(iblockdata));
                    this.getCraftServer().getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        return;
                    }
                }
                iblockdata.updateNeighbourShapes(this, blockposition, k2, j2 - 1);
                iblockdata.updateIndirectNeighbourShapes(this, blockposition, k2, j2 - 1);
            }
            if (!this.preventPoiUpdated) {
                this.onBlockStateChange(blockposition, iblockdata1, iblockdata2);
            }
        }
    }

    public void onBlockStateChange(BlockPosition blockposition, IBlockData iblockdata, IBlockData iblockdata1) {
    }

    @Override
    public boolean removeBlock(BlockPosition blockposition, boolean flag) {
        Fluid fluid = this.getFluidState(blockposition);
        return this.setBlock(blockposition, fluid.createLegacyBlock(), 3 | (flag ? 64 : 0));
    }

    @Override
    public boolean destroyBlock(BlockPosition blockposition, boolean flag, @Nullable Entity entity, int i2) {
        boolean flag1;
        IBlockData iblockdata = this.getBlockState(blockposition);
        if (iblockdata.isAir()) {
            return false;
        }
        Fluid fluid = this.getFluidState(blockposition);
        if (!(iblockdata.getBlock() instanceof BlockFireAbstract)) {
            this.levelEvent(2001, blockposition, Block.getId(iblockdata));
        }
        if (flag) {
            TileEntity tileentity = iblockdata.hasBlockEntity() ? this.getBlockEntity(blockposition) : null;
            Block.dropResources(iblockdata, this, blockposition, tileentity, entity, ItemStack.EMPTY);
        }
        if (flag1 = this.setBlock(blockposition, fluid.createLegacyBlock(), 3, i2)) {
            this.gameEvent(GameEvent.BLOCK_DESTROY, blockposition, GameEvent.a.of(entity, iblockdata));
        }
        return flag1;
    }

    public void addDestroyBlockEffect(BlockPosition blockposition, IBlockData iblockdata) {
    }

    public boolean setBlockAndUpdate(BlockPosition blockposition, IBlockData iblockdata) {
        return this.setBlock(blockposition, iblockdata, 3);
    }

    public abstract void sendBlockUpdated(BlockPosition var1, IBlockData var2, IBlockData var3, int var4);

    public void setBlocksDirty(BlockPosition blockposition, IBlockData iblockdata, IBlockData iblockdata1) {
    }

    public void updateNeighborsAt(BlockPosition blockposition, Block block) {
    }

    public void updateNeighborsAtExceptFromFacing(BlockPosition blockposition, Block block, EnumDirection enumdirection) {
    }

    public void neighborChanged(BlockPosition blockposition, Block block, BlockPosition blockposition1) {
    }

    public void neighborChanged(IBlockData iblockdata, BlockPosition blockposition, Block block, BlockPosition blockposition1, boolean flag) {
    }

    @Override
    public void neighborShapeChanged(EnumDirection enumdirection, IBlockData iblockdata, BlockPosition blockposition, BlockPosition blockposition1, int i2, int j2) {
        this.neighborUpdater.shapeUpdate(enumdirection, iblockdata, blockposition, blockposition1, i2, j2);
    }

    @Override
    public int getHeight(HeightMap.Type heightmap_type, int i2, int j2) {
        int k2 = i2 >= -30000000 && j2 >= -30000000 && i2 < 30000000 && j2 < 30000000 ? (this.hasChunk(SectionPosition.blockToSectionCoord(i2), SectionPosition.blockToSectionCoord(j2)) ? this.getChunk(SectionPosition.blockToSectionCoord(i2), SectionPosition.blockToSectionCoord(j2)).getHeight(heightmap_type, i2 & 0xF, j2 & 0xF) + 1 : this.getMinBuildHeight()) : this.getSeaLevel() + 1;
        return k2;
    }

    @Override
    public LevelLightEngine getLightEngine() {
        return this.getChunkSource().getLightEngine();
    }

    @Override
    public IBlockData getBlockState(BlockPosition blockposition) {
        CapturedBlockState previous;
        if (this.captureTreeGeneration && (previous = this.capturedBlockStates.get(blockposition)) != null) {
            return previous.getHandle();
        }
        if (this.isOutsideBuildHeight(blockposition)) {
            return Blocks.VOID_AIR.defaultBlockState();
        }
        Chunk chunk = this.getChunk(SectionPosition.blockToSectionCoord(blockposition.getX()), SectionPosition.blockToSectionCoord(blockposition.getZ()));
        return chunk.getBlockState(blockposition);
    }

    @Override
    public Fluid getFluidState(BlockPosition blockposition) {
        if (this.isOutsideBuildHeight(blockposition)) {
            return FluidTypes.EMPTY.defaultFluidState();
        }
        Chunk chunk = this.getChunkAt(blockposition);
        return chunk.getFluidState(blockposition);
    }

    public boolean isDay() {
        return !this.dimensionType().hasFixedTime() && this.skyDarken < 4;
    }

    public boolean isNight() {
        return !this.dimensionType().hasFixedTime() && !this.isDay();
    }

    public void playSound(@Nullable Entity entity, BlockPosition blockposition, SoundEffect soundeffect, SoundCategory soundcategory, float f2, float f1) {
        EntityHuman entityhuman1;
        EntityHuman entityhuman = entity instanceof EntityHuman ? (entityhuman1 = (EntityHuman)entity) : null;
        this.playSound(entityhuman, blockposition, soundeffect, soundcategory, f2, f1);
    }

    @Override
    public void playSound(@Nullable EntityHuman entityhuman, BlockPosition blockposition, SoundEffect soundeffect, SoundCategory soundcategory, float f2, float f1) {
        this.playSound(entityhuman, (double)blockposition.getX() + 0.5, (double)blockposition.getY() + 0.5, (double)blockposition.getZ() + 0.5, soundeffect, soundcategory, f2, f1);
    }

    public abstract void playSeededSound(@Nullable EntityHuman var1, double var2, double var4, double var6, Holder<SoundEffect> var8, SoundCategory var9, float var10, float var11, long var12);

    public void playSeededSound(@Nullable EntityHuman entityhuman, double d0, double d1, double d2, SoundEffect soundeffect, SoundCategory soundcategory, float f2, float f1, long i2) {
        this.playSeededSound(entityhuman, d0, d1, d2, BuiltInRegistries.SOUND_EVENT.wrapAsHolder(soundeffect), soundcategory, f2, f1, i2);
    }

    public abstract void playSeededSound(@Nullable EntityHuman var1, Entity var2, Holder<SoundEffect> var3, SoundCategory var4, float var5, float var6, long var7);

    public void playSound(@Nullable EntityHuman entityhuman, double d0, double d1, double d2, SoundEffect soundeffect, SoundCategory soundcategory) {
        this.playSound(entityhuman, d0, d1, d2, soundeffect, soundcategory, 1.0f, 1.0f);
    }

    public void playSound(@Nullable EntityHuman entityhuman, double d0, double d1, double d2, SoundEffect soundeffect, SoundCategory soundcategory, float f2, float f1) {
        this.playSeededSound(entityhuman, d0, d1, d2, soundeffect, soundcategory, f2, f1, this.threadSafeRandom.nextLong());
    }

    public void playSound(@Nullable EntityHuman entityhuman, double d0, double d1, double d2, Holder<SoundEffect> holder, SoundCategory soundcategory, float f2, float f1) {
        this.playSeededSound(entityhuman, d0, d1, d2, holder, soundcategory, f2, f1, this.threadSafeRandom.nextLong());
    }

    public void playSound(@Nullable EntityHuman entityhuman, Entity entity, SoundEffect soundeffect, SoundCategory soundcategory, float f2, float f1) {
        this.playSeededSound(entityhuman, entity, BuiltInRegistries.SOUND_EVENT.wrapAsHolder(soundeffect), soundcategory, f2, f1, this.threadSafeRandom.nextLong());
    }

    public void playLocalSound(BlockPosition blockposition, SoundEffect soundeffect, SoundCategory soundcategory, float f2, float f1, boolean flag) {
        this.playLocalSound((double)blockposition.getX() + 0.5, (double)blockposition.getY() + 0.5, (double)blockposition.getZ() + 0.5, soundeffect, soundcategory, f2, f1, flag);
    }

    public void playLocalSound(Entity entity, SoundEffect soundeffect, SoundCategory soundcategory, float f2, float f1) {
    }

    public void playLocalSound(double d0, double d1, double d2, SoundEffect soundeffect, SoundCategory soundcategory, float f2, float f1, boolean flag) {
    }

    @Override
    public void addParticle(ParticleParam particleparam, double d0, double d1, double d2, double d3, double d4, double d5) {
    }

    public void addParticle(ParticleParam particleparam, boolean flag, double d0, double d1, double d2, double d3, double d4, double d5) {
    }

    public void addAlwaysVisibleParticle(ParticleParam particleparam, double d0, double d1, double d2, double d3, double d4, double d5) {
    }

    public void addAlwaysVisibleParticle(ParticleParam particleparam, boolean flag, double d0, double d1, double d2, double d3, double d4, double d5) {
    }

    public float getSunAngle(float f2) {
        float f1 = this.getTimeOfDay(f2);
        return f1 * ((float)Math.PI * 2);
    }

    public void addBlockEntityTicker(TickingBlockEntity tickingblockentity) {
        (this.tickingBlockEntities ? this.pendingBlockEntityTickers : this.blockEntityTickers).add(tickingblockentity);
    }

    protected void tickBlockEntities() {
        GameProfilerFiller gameprofilerfiller = this.getProfiler();
        gameprofilerfiller.push("blockEntities");
        this.timings.tileEntityPending.startTiming();
        this.tickingBlockEntities = true;
        if (!this.pendingBlockEntityTickers.isEmpty()) {
            this.blockEntityTickers.addAll(this.pendingBlockEntityTickers);
            this.pendingBlockEntityTickers.clear();
        }
        this.timings.tileEntityPending.stopTiming();
        this.timings.tileEntityTick.startTiming();
        boolean flag = this.tickRateManager().runsNormally();
        this.tileLimiter.initTick();
        for (int tilesThisCycle = 0; tilesThisCycle < this.blockEntityTickers.size() && (tilesThisCycle % 10 != 0 || this.tileLimiter.shouldContinue()); ++tilesThisCycle) {
            this.tileTickPosition = this.tileTickPosition < this.blockEntityTickers.size() ? this.tileTickPosition : 0;
            TickingBlockEntity tickingblockentity = this.blockEntityTickers.get(this.tileTickPosition);
            if (tickingblockentity.isRemoved()) {
                --tilesThisCycle;
                this.blockEntityTickers.remove(this.tileTickPosition--);
            } else if (flag && this.shouldTickBlocksAt(tickingblockentity.getPos())) {
                tickingblockentity.tick();
            }
            ++this.tileTickPosition;
        }
        this.timings.tileEntityTick.stopTiming();
        this.tickingBlockEntities = false;
        gameprofilerfiller.pop();
        this.spigotConfig.currentPrimedTnt = 0;
    }

    public <T extends Entity> void guardEntityTick(Consumer<T> consumer, T t0) {
        try {
            SpigotTimings.tickEntityTimer.startTiming();
            consumer.accept(t0);
            SpigotTimings.tickEntityTimer.stopTiming();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.forThrowable(throwable, "Ticking entity");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.addCategory("Entity being ticked");
            t0.fillCrashReportCategory(crashreportsystemdetails);
            throw new ReportedException(crashreport);
        }
    }

    public boolean shouldTickDeath(Entity entity) {
        return true;
    }

    public boolean shouldTickBlocksAt(long i2) {
        return true;
    }

    public boolean shouldTickBlocksAt(BlockPosition blockposition) {
        return this.shouldTickBlocksAt(ChunkCoordIntPair.asLong(blockposition));
    }

    public Explosion explode(@Nullable Entity entity, double d0, double d1, double d2, float f2, a world_a) {
        return this.explode(entity, Explosion.getDefaultDamageSource(this, entity), null, d0, d1, d2, f2, false, world_a, Particles.EXPLOSION, Particles.EXPLOSION_EMITTER, SoundEffects.GENERIC_EXPLODE);
    }

    public Explosion explode(@Nullable Entity entity, double d0, double d1, double d2, float f2, boolean flag, a world_a) {
        return this.explode(entity, Explosion.getDefaultDamageSource(this, entity), null, d0, d1, d2, f2, flag, world_a, Particles.EXPLOSION, Particles.EXPLOSION_EMITTER, SoundEffects.GENERIC_EXPLODE);
    }

    public Explosion explode(@Nullable Entity entity, @Nullable DamageSource damagesource, @Nullable ExplosionDamageCalculator explosiondamagecalculator, Vec3D vec3d, float f2, boolean flag, a world_a) {
        return this.explode(entity, damagesource, explosiondamagecalculator, vec3d.x(), vec3d.y(), vec3d.z(), f2, flag, world_a, Particles.EXPLOSION, Particles.EXPLOSION_EMITTER, SoundEffects.GENERIC_EXPLODE);
    }

    public Explosion explode(@Nullable Entity entity, @Nullable DamageSource damagesource, @Nullable ExplosionDamageCalculator explosiondamagecalculator, double d0, double d1, double d2, float f2, boolean flag, a world_a) {
        return this.explode(entity, damagesource, explosiondamagecalculator, d0, d1, d2, f2, flag, world_a, Particles.EXPLOSION, Particles.EXPLOSION_EMITTER, SoundEffects.GENERIC_EXPLODE);
    }

    public Explosion explode(@Nullable Entity entity, @Nullable DamageSource damagesource, @Nullable ExplosionDamageCalculator explosiondamagecalculator, double d0, double d1, double d2, float f2, boolean flag, a world_a, ParticleParam particleparam, ParticleParam particleparam1, Holder<SoundEffect> holder) {
        return this.explode(entity, damagesource, explosiondamagecalculator, d0, d1, d2, f2, flag, world_a, true, particleparam, particleparam1, holder);
    }

    public Explosion explode(@Nullable Entity entity, @Nullable DamageSource damagesource, @Nullable ExplosionDamageCalculator explosiondamagecalculator, double d0, double d1, double d2, float f2, boolean flag, a world_a, boolean flag1, ParticleParam particleparam, ParticleParam particleparam1, Holder<SoundEffect> holder) {
        Explosion.Effect explosion_effect1 = switch (world_a.ordinal()) {
            case 0 -> Explosion.Effect.KEEP;
            case 1 -> this.getDestroyType(GameRules.RULE_BLOCK_EXPLOSION_DROP_DECAY);
            case 2 -> this.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING) ? this.getDestroyType(GameRules.RULE_MOB_EXPLOSION_DROP_DECAY) : Explosion.Effect.KEEP;
            case 3 -> this.getDestroyType(GameRules.RULE_TNT_EXPLOSION_DROP_DECAY);
            case 4 -> Explosion.Effect.TRIGGER_BLOCK;
            case 5 -> Explosion.Effect.DESTROY;
            default -> throw new MatchException(null, null);
        };
        Explosion explosion = new Explosion(this, entity, damagesource, explosiondamagecalculator, d0, d1, d2, f2, flag, explosion_effect1, particleparam, particleparam1, holder);
        explosion.explode();
        explosion.finalizeExplosion(flag1);
        return explosion;
    }

    private Explosion.Effect getDestroyType(GameRules.GameRuleKey<GameRules.GameRuleBoolean> gamerules_gamerulekey) {
        return this.getGameRules().getBoolean(gamerules_gamerulekey) ? Explosion.Effect.DESTROY_WITH_DECAY : Explosion.Effect.DESTROY;
    }

    public abstract String gatherChunkSourceStats();

    @Override
    @Nullable
    public TileEntity getBlockEntity(BlockPosition blockposition) {
        return this.getBlockEntity(blockposition, true);
    }

    @Nullable
    public TileEntity getBlockEntity(BlockPosition blockposition, boolean validate) {
        if (this.capturedTileEntities.containsKey(blockposition)) {
            return this.capturedTileEntities.get(blockposition);
        }
        return this.isOutsideBuildHeight(blockposition) ? null : (!this.isClientSide && Thread.currentThread() != this.thread ? null : this.getChunkAt(blockposition).getBlockEntity(blockposition, Chunk.EnumTileEntityState.IMMEDIATE));
    }

    public void setBlockEntity(TileEntity tileentity) {
        BlockPosition blockposition = tileentity.getBlockPos();
        if (!this.isOutsideBuildHeight(blockposition)) {
            if (this.captureBlockStates) {
                this.capturedTileEntities.put(blockposition.immutable(), tileentity);
                return;
            }
            this.getChunkAt(blockposition).addAndRegisterBlockEntity(tileentity);
        }
    }

    public void removeBlockEntity(BlockPosition blockposition) {
        if (!this.isOutsideBuildHeight(blockposition)) {
            this.getChunkAt(blockposition).removeBlockEntity(blockposition);
        }
    }

    public boolean isLoaded(BlockPosition blockposition) {
        return this.isOutsideBuildHeight(blockposition) ? false : this.getChunkSource().hasChunk(SectionPosition.blockToSectionCoord(blockposition.getX()), SectionPosition.blockToSectionCoord(blockposition.getZ()));
    }

    public boolean loadedAndEntityCanStandOnFace(BlockPosition blockposition, Entity entity, EnumDirection enumdirection) {
        if (this.isOutsideBuildHeight(blockposition)) {
            return false;
        }
        IChunkAccess ichunkaccess = this.getChunk(SectionPosition.blockToSectionCoord(blockposition.getX()), SectionPosition.blockToSectionCoord(blockposition.getZ()), ChunkStatus.FULL, false);
        return ichunkaccess == null ? false : ichunkaccess.getBlockState(blockposition).entityCanStandOnFace(this, blockposition, entity, enumdirection);
    }

    public boolean loadedAndEntityCanStandOn(BlockPosition blockposition, Entity entity) {
        return this.loadedAndEntityCanStandOnFace(blockposition, entity, EnumDirection.UP);
    }

    public void updateSkyBrightness() {
        double d0 = 1.0 - (double)(this.getRainLevel(1.0f) * 5.0f) / 16.0;
        double d1 = 1.0 - (double)(this.getThunderLevel(1.0f) * 5.0f) / 16.0;
        double d2 = 0.5 + 2.0 * MathHelper.clamp((double)MathHelper.cos(this.getTimeOfDay(1.0f) * ((float)Math.PI * 2)), -0.25, 0.25);
        this.skyDarken = (int)((1.0 - d2 * d0 * d1) * 11.0);
    }

    public void setSpawnSettings(boolean flag, boolean flag1) {
        this.getChunkSource().setSpawnSettings(flag, flag1);
    }

    public BlockPosition getSharedSpawnPos() {
        BlockPosition blockposition = this.levelData.getSpawnPos();
        if (!this.getWorldBorder().isWithinBounds(blockposition)) {
            blockposition = this.getHeightmapPos(HeightMap.Type.MOTION_BLOCKING, BlockPosition.containing(this.getWorldBorder().getCenterX(), 0.0, this.getWorldBorder().getCenterZ()));
        }
        return blockposition;
    }

    public float getSharedSpawnAngle() {
        return this.levelData.getSpawnAngle();
    }

    protected void prepareWeather() {
        if (this.levelData.isRaining()) {
            this.rainLevel = 1.0f;
            if (this.levelData.isThundering()) {
                this.thunderLevel = 1.0f;
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.getChunkSource().close();
    }

    @Override
    @Nullable
    public IBlockAccess getChunkForCollisions(int i2, int j2) {
        return this.getChunk(i2, j2, ChunkStatus.FULL, false);
    }

    @Override
    public List<Entity> getEntities(@Nullable Entity entity, AxisAlignedBB axisalignedbb, Predicate<? super Entity> predicate) {
        this.getProfiler().incrementCounter("getEntities");
        ArrayList list = Lists.newArrayList();
        this.getEntities().get(axisalignedbb, entity1 -> {
            if (entity1 != entity && predicate.test((Entity)entity1)) {
                list.add(entity1);
            }
            if (entity1 instanceof EntityEnderDragon) {
                for (EntityComplexPart entitycomplexpart : ((EntityEnderDragon)entity1).getSubEntities()) {
                    if (entity1 == entity || !predicate.test(entitycomplexpart)) continue;
                    list.add(entitycomplexpart);
                }
            }
        });
        return list;
    }

    @Override
    public <T extends Entity> List<T> getEntities(EntityTypeTest<Entity, T> entitytypetest, AxisAlignedBB axisalignedbb, Predicate<? super T> predicate) {
        ArrayList list = Lists.newArrayList();
        this.getEntities(entitytypetest, axisalignedbb, predicate, list);
        return list;
    }

    public <T extends Entity> void getEntities(EntityTypeTest<Entity, T> entitytypetest, AxisAlignedBB axisalignedbb, Predicate<? super T> predicate, List<? super T> list) {
        this.getEntities(entitytypetest, axisalignedbb, predicate, list, Integer.MAX_VALUE);
    }

    public <T extends Entity> void getEntities(EntityTypeTest<Entity, T> entitytypetest, AxisAlignedBB axisalignedbb, Predicate<? super T> predicate, List<? super T> list, int i2) {
        this.getProfiler().incrementCounter("getEntities");
        this.getEntities().get(entitytypetest, axisalignedbb, entity -> {
            if (predicate.test(entity)) {
                list.add((Object)entity);
                if (list.size() >= i2) {
                    return AbortableIterationConsumer.a.ABORT;
                }
            }
            if (entity instanceof EntityEnderDragon) {
                EntityEnderDragon entityenderdragon = (EntityEnderDragon)entity;
                for (EntityComplexPart entitycomplexpart : entityenderdragon.getSubEntities()) {
                    Entity t0 = (Entity)entitytypetest.tryCast(entitycomplexpart);
                    if (t0 == null || !predicate.test(t0)) continue;
                    list.add((Object)t0);
                    if (list.size() < i2) continue;
                    return AbortableIterationConsumer.a.ABORT;
                }
            }
            return AbortableIterationConsumer.a.CONTINUE;
        });
    }

    @Nullable
    public abstract Entity getEntity(int var1);

    public void blockEntityChanged(BlockPosition blockposition) {
        if (this.hasChunkAt(blockposition)) {
            this.getChunkAt(blockposition).setUnsaved(true);
        }
    }

    @Override
    public int getSeaLevel() {
        return 63;
    }

    public void disconnect() {
    }

    public long getGameTime() {
        return this.levelData.getGameTime();
    }

    public long getDayTime() {
        return this.levelData.getDayTime();
    }

    public boolean mayInteract(EntityHuman entityhuman, BlockPosition blockposition) {
        return true;
    }

    public void broadcastEntityEvent(Entity entity, byte b0) {
    }

    public void broadcastDamageEvent(Entity entity, DamageSource damagesource) {
    }

    public void blockEvent(BlockPosition blockposition, Block block, int i2, int j2) {
        this.getBlockState(blockposition).triggerEvent(this, blockposition, i2, j2);
    }

    @Override
    public WorldData getLevelData() {
        return this.levelData;
    }

    public GameRules getGameRules() {
        return this.levelData.getGameRules();
    }

    public abstract TickRateManager tickRateManager();

    public float getThunderLevel(float f2) {
        return MathHelper.lerp(f2, this.oThunderLevel, this.thunderLevel) * this.getRainLevel(f2);
    }

    public void setThunderLevel(float f2) {
        float f1;
        this.oThunderLevel = f1 = MathHelper.clamp(f2, 0.0f, 1.0f);
        this.thunderLevel = f1;
    }

    public float getRainLevel(float f2) {
        return MathHelper.lerp(f2, this.oRainLevel, this.rainLevel);
    }

    public void setRainLevel(float f2) {
        float f1;
        this.oRainLevel = f1 = MathHelper.clamp(f2, 0.0f, 1.0f);
        this.rainLevel = f1;
    }

    public boolean isThundering() {
        return this.dimensionType().hasSkyLight() && !this.dimensionType().hasCeiling() ? (double)this.getThunderLevel(1.0f) > 0.9 : false;
    }

    public boolean isRaining() {
        return (double)this.getRainLevel(1.0f) > 0.2;
    }

    public boolean isRainingAt(BlockPosition blockposition) {
        if (!this.isRaining()) {
            return false;
        }
        if (!this.canSeeSky(blockposition)) {
            return false;
        }
        if (this.getHeightmapPos(HeightMap.Type.MOTION_BLOCKING, blockposition).getY() > blockposition.getY()) {
            return false;
        }
        BiomeBase biomebase = this.getBiome(blockposition).value();
        return biomebase.getPrecipitationAt(blockposition) == BiomeBase.Precipitation.RAIN;
    }

    @Nullable
    public abstract WorldMap getMapData(MapId var1);

    public abstract void setMapData(MapId var1, WorldMap var2);

    public abstract MapId getFreeMapId();

    public void globalLevelEvent(int i2, BlockPosition blockposition, int j2) {
    }

    public CrashReportSystemDetails fillReportDetails(CrashReport crashreport) {
        CrashReportSystemDetails crashreportsystemdetails = crashreport.addCategory("Affected level", 1);
        crashreportsystemdetails.setDetail("All players", () -> {
            int i2 = this.players().size();
            return i2 + " total; " + String.valueOf(this.players());
        });
        IChunkProvider ichunkprovider = this.getChunkSource();
        Objects.requireNonNull(ichunkprovider);
        crashreportsystemdetails.setDetail("Chunk stats", ichunkprovider::gatherStats);
        crashreportsystemdetails.setDetail("Level dimension", () -> this.dimension().location().toString());
        try {
            this.levelData.fillCrashReportCategory(crashreportsystemdetails, this);
        }
        catch (Throwable throwable) {
            crashreportsystemdetails.setDetailError("Level Data Unobtainable", throwable);
        }
        return crashreportsystemdetails;
    }

    public abstract void destroyBlockProgress(int var1, BlockPosition var2, int var3);

    public void createFireworks(double d0, double d1, double d2, double d3, double d4, double d5, List<FireworkExplosion> list) {
    }

    public abstract Scoreboard getScoreboard();

    public void updateNeighbourForOutputSignal(BlockPosition blockposition, Block block) {
        for (EnumDirection enumdirection : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            BlockPosition blockposition1 = blockposition.relative(enumdirection);
            if (!this.hasChunkAt(blockposition1)) continue;
            IBlockData iblockdata = this.getBlockState(blockposition1);
            if (iblockdata.is(Blocks.COMPARATOR)) {
                this.neighborChanged(iblockdata, blockposition1, block, blockposition, false);
                continue;
            }
            if (!iblockdata.isRedstoneConductor(this, blockposition1) || !(iblockdata = this.getBlockState(blockposition1 = blockposition1.relative(enumdirection))).is(Blocks.COMPARATOR)) continue;
            this.neighborChanged(iblockdata, blockposition1, block, blockposition, false);
        }
    }

    @Override
    public DifficultyDamageScaler getCurrentDifficultyAt(BlockPosition blockposition) {
        long i2 = 0L;
        float f2 = 0.0f;
        if (this.hasChunkAt(blockposition)) {
            f2 = this.getMoonBrightness();
            i2 = this.getChunkAt(blockposition).getInhabitedTime();
        }
        return new DifficultyDamageScaler(this.getDifficulty(), this.getDayTime(), i2, f2);
    }

    @Override
    public int getSkyDarken() {
        return this.skyDarken;
    }

    public void setSkyFlashTime(int i2) {
    }

    @Override
    public WorldBorder getWorldBorder() {
        return this.worldBorder;
    }

    public void sendPacketToServer(Packet<?> packet) {
        throw new UnsupportedOperationException("Can't send packets to server unless you're on the client.");
    }

    @Override
    public DimensionManager dimensionType() {
        return this.dimensionTypeRegistration.value();
    }

    public Holder<DimensionManager> dimensionTypeRegistration() {
        return this.dimensionTypeRegistration;
    }

    public ResourceKey<World> dimension() {
        return this.dimension;
    }

    @Override
    public RandomSource getRandom() {
        return this.random;
    }

    @Override
    public boolean isStateAtPosition(BlockPosition blockposition, Predicate<IBlockData> predicate) {
        return predicate.test(this.getBlockState(blockposition));
    }

    @Override
    public boolean isFluidAtPosition(BlockPosition blockposition, Predicate<Fluid> predicate) {
        return predicate.test(this.getFluidState(blockposition));
    }

    public abstract CraftingManager getRecipeManager();

    public BlockPosition getBlockRandomPos(int i2, int j2, int k2, int l2) {
        this.randValue = this.randValue * 3 + 1013904223;
        int i1 = this.randValue >> 2;
        return new BlockPosition(i2 + (i1 & 0xF), j2 + (i1 >> 16 & l2), k2 + (i1 >> 8 & 0xF));
    }

    public boolean noSave() {
        return false;
    }

    public GameProfilerFiller getProfiler() {
        return this.profiler.get();
    }

    public Supplier<GameProfilerFiller> getProfilerSupplier() {
        return this.profiler;
    }

    @Override
    public BiomeManager getBiomeManager() {
        return this.biomeManager;
    }

    public final boolean isDebug() {
        return this.isDebug;
    }

    public abstract LevelEntityGetter<Entity> getEntities();

    @Override
    public long nextSubTickCount() {
        return this.subTickCount++;
    }

    @Override
    public IRegistryCustom registryAccess() {
        return this.registryAccess;
    }

    public DamageSources damageSources() {
        return this.damageSources;
    }

    public abstract PotionBrewer potionBrewing();

    public static enum a implements INamable
    {
        NONE("none"),
        BLOCK("block"),
        MOB("mob"),
        TNT("tnt"),
        TRIGGER("trigger"),
        STANDARD("standard");

        public static final Codec<a> CODEC;
        private final String id;

        private a(String s2) {
            this.id = s2;
        }

        @Override
        public String getSerializedName() {
            return this.id;
        }

        static {
            CODEC = INamable.fromEnum(a::values);
        }
    }
}

