/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicLike;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.WorldDataConfiguration;

public final class WorldSettings {
    public String levelName;
    private final EnumGamemode gameType;
    public boolean hardcore;
    private final EnumDifficulty difficulty;
    private final boolean allowCommands;
    private final GameRules gameRules;
    private final WorldDataConfiguration dataConfiguration;

    public WorldSettings(String var0, EnumGamemode var1, boolean var2, EnumDifficulty var3, boolean var4, GameRules var5, WorldDataConfiguration var6) {
        this.levelName = var0;
        this.gameType = var1;
        this.hardcore = var2;
        this.difficulty = var3;
        this.allowCommands = var4;
        this.gameRules = var5;
        this.dataConfiguration = var6;
    }

    public static WorldSettings parse(Dynamic<?> var02, WorldDataConfiguration var1) {
        EnumGamemode var2 = EnumGamemode.byId(var02.get("GameType").asInt(0));
        return new WorldSettings(var02.get("LevelName").asString(""), var2, var02.get("hardcore").asBoolean(false), var02.get("Difficulty").asNumber().map(var0 -> EnumDifficulty.byId(var0.byteValue())).result().orElse(EnumDifficulty.NORMAL), var02.get("allowCommands").asBoolean(var2 == EnumGamemode.CREATIVE), new GameRules((DynamicLike<?>)var02.get("GameRules")), var1);
    }

    public String levelName() {
        return this.levelName;
    }

    public EnumGamemode gameType() {
        return this.gameType;
    }

    public boolean hardcore() {
        return this.hardcore;
    }

    public EnumDifficulty difficulty() {
        return this.difficulty;
    }

    public boolean allowCommands() {
        return this.allowCommands;
    }

    public GameRules gameRules() {
        return this.gameRules;
    }

    public WorldDataConfiguration getDataConfiguration() {
        return this.dataConfiguration;
    }

    public WorldSettings withGameType(EnumGamemode var0) {
        return new WorldSettings(this.levelName, var0, this.hardcore, this.difficulty, this.allowCommands, this.gameRules, this.dataConfiguration);
    }

    public WorldSettings withDifficulty(EnumDifficulty var0) {
        return new WorldSettings(this.levelName, this.gameType, this.hardcore, var0, this.allowCommands, this.gameRules, this.dataConfiguration);
    }

    public WorldSettings withDataConfiguration(WorldDataConfiguration var0) {
        return new WorldSettings(this.levelName, this.gameType, this.hardcore, this.difficulty, this.allowCommands, this.gameRules, var0);
    }

    public WorldSettings copy() {
        return new WorldSettings(this.levelName, this.gameType, this.hardcore, this.difficulty, this.allowCommands, this.gameRules.copy(), this.dataConfiguration);
    }
}

