/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;

public abstract class AbstractCandleBlock
extends Block {
    public static final int LIGHT_PER_CANDLE = 3;
    public static final BlockStateBoolean LIT = BlockProperties.LIT;

    protected abstract MapCodec<? extends AbstractCandleBlock> codec();

    protected AbstractCandleBlock(BlockBase.Info blockbase_info) {
        super(blockbase_info);
    }

    protected abstract Iterable<Vec3D> getParticleOffsets(IBlockData var1);

    public static boolean isLit(IBlockData iblockdata) {
        return iblockdata.hasProperty(LIT) && (iblockdata.is(TagsBlock.CANDLES) || iblockdata.is(TagsBlock.CANDLE_CAKES)) && iblockdata.getValue(LIT) != false;
    }

    @Override
    protected void onProjectileHit(World world, IBlockData iblockdata, MovingObjectPositionBlock movingobjectpositionblock, IProjectile iprojectile) {
        if (!world.isClientSide && iprojectile.isOnFire() && this.canBeLit(iblockdata)) {
            if (CraftEventFactory.callBlockIgniteEvent(world, movingobjectpositionblock.getBlockPos(), iprojectile).isCancelled()) {
                return;
            }
            AbstractCandleBlock.setLit(world, iblockdata, movingobjectpositionblock.getBlockPos(), true);
        }
    }

    protected boolean canBeLit(IBlockData iblockdata) {
        return iblockdata.getValue(LIT) == false;
    }

    @Override
    public void animateTick(IBlockData iblockdata, World world, BlockPosition blockposition, RandomSource randomsource) {
        if (iblockdata.getValue(LIT).booleanValue()) {
            this.getParticleOffsets(iblockdata).forEach(vec3d -> AbstractCandleBlock.addParticlesAndSound(world, vec3d.add(blockposition.getX(), blockposition.getY(), blockposition.getZ()), randomsource));
        }
    }

    private static void addParticlesAndSound(World world, Vec3D vec3d, RandomSource randomsource) {
        float f2 = randomsource.nextFloat();
        if (f2 < 0.3f) {
            world.addParticle(Particles.SMOKE, vec3d.x, vec3d.y, vec3d.z, 0.0, 0.0, 0.0);
            if (f2 < 0.17f) {
                world.playLocalSound(vec3d.x + 0.5, vec3d.y + 0.5, vec3d.z + 0.5, SoundEffects.CANDLE_AMBIENT, SoundCategory.BLOCKS, 1.0f + randomsource.nextFloat(), randomsource.nextFloat() * 0.7f + 0.3f, false);
            }
        }
        world.addParticle(Particles.SMALL_FLAME, vec3d.x, vec3d.y, vec3d.z, 0.0, 0.0, 0.0);
    }

    public static void extinguish(@Nullable EntityHuman entityhuman, IBlockData iblockdata, GeneratorAccess generatoraccess, BlockPosition blockposition) {
        AbstractCandleBlock.setLit(generatoraccess, iblockdata, blockposition, false);
        if (iblockdata.getBlock() instanceof AbstractCandleBlock) {
            ((AbstractCandleBlock)iblockdata.getBlock()).getParticleOffsets(iblockdata).forEach(vec3d -> generatoraccess.addParticle(Particles.SMOKE, (double)blockposition.getX() + vec3d.x(), (double)blockposition.getY() + vec3d.y(), (double)blockposition.getZ() + vec3d.z(), 0.0, 0.1f, 0.0));
        }
        generatoraccess.playSound(null, blockposition, SoundEffects.CANDLE_EXTINGUISH, SoundCategory.BLOCKS, 1.0f, 1.0f);
        generatoraccess.gameEvent((Entity)entityhuman, GameEvent.BLOCK_CHANGE, blockposition);
    }

    private static void setLit(GeneratorAccess generatoraccess, IBlockData iblockdata, BlockPosition blockposition, boolean flag) {
        generatoraccess.setBlock(blockposition, (IBlockData)iblockdata.setValue(LIT, flag), 11);
    }

    @Override
    protected void onExplosionHit(IBlockData iblockdata, World world, BlockPosition blockposition, Explosion explosion, BiConsumer<ItemStack, BlockPosition> biconsumer) {
        if (explosion.canTriggerBlocks() && iblockdata.getValue(LIT).booleanValue()) {
            AbstractCandleBlock.extinguish(null, iblockdata, world, blockposition);
        }
        super.onExplosionHit(iblockdata, world, blockposition, explosion, biconsumer);
    }
}

