/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BigDripleafStemBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.Tilt;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class BigDripleafBlock
extends BlockFacingHorizontal
implements IBlockFragilePlantElement,
IBlockWaterlogged {
    public static final MapCodec<BigDripleafBlock> CODEC = BigDripleafBlock.simpleCodec(BigDripleafBlock::new);
    private static final BlockStateBoolean WATERLOGGED = BlockProperties.WATERLOGGED;
    private static final BlockStateEnum<Tilt> TILT = BlockProperties.TILT;
    private static final int NO_TICK = -1;
    private static final Object2IntMap<Tilt> DELAY_UNTIL_NEXT_TILT_STATE = (Object2IntMap)SystemUtils.make(new Object2IntArrayMap(), object2intarraymap -> {
        object2intarraymap.defaultReturnValue(-1);
        object2intarraymap.put((Object)Tilt.UNSTABLE, 10);
        object2intarraymap.put((Object)Tilt.PARTIAL, 10);
        object2intarraymap.put((Object)Tilt.FULL, 100);
    });
    private static final int MAX_GEN_HEIGHT = 5;
    private static final int STEM_WIDTH = 6;
    private static final int ENTITY_DETECTION_MIN_Y = 11;
    private static final int LOWEST_LEAF_TOP = 13;
    private static final Map<Tilt, VoxelShape> LEAF_SHAPES = ImmutableMap.of((Object)Tilt.NONE, (Object)Block.box(0.0, 11.0, 0.0, 16.0, 15.0, 16.0), (Object)Tilt.UNSTABLE, (Object)Block.box(0.0, 11.0, 0.0, 16.0, 15.0, 16.0), (Object)Tilt.PARTIAL, (Object)Block.box(0.0, 11.0, 0.0, 16.0, 13.0, 16.0), (Object)Tilt.FULL, (Object)VoxelShapes.empty());
    private static final VoxelShape STEM_SLICER = Block.box(0.0, 13.0, 0.0, 16.0, 16.0, 16.0);
    private static final Map<EnumDirection, VoxelShape> STEM_SHAPES = ImmutableMap.of((Object)EnumDirection.NORTH, (Object)VoxelShapes.joinUnoptimized(BigDripleafStemBlock.NORTH_SHAPE, STEM_SLICER, OperatorBoolean.ONLY_FIRST), (Object)EnumDirection.SOUTH, (Object)VoxelShapes.joinUnoptimized(BigDripleafStemBlock.SOUTH_SHAPE, STEM_SLICER, OperatorBoolean.ONLY_FIRST), (Object)EnumDirection.EAST, (Object)VoxelShapes.joinUnoptimized(BigDripleafStemBlock.EAST_SHAPE, STEM_SLICER, OperatorBoolean.ONLY_FIRST), (Object)EnumDirection.WEST, (Object)VoxelShapes.joinUnoptimized(BigDripleafStemBlock.WEST_SHAPE, STEM_SLICER, OperatorBoolean.ONLY_FIRST));
    private final Map<IBlockData, VoxelShape> shapesCache;

    public MapCodec<BigDripleafBlock> codec() {
        return CODEC;
    }

    protected BigDripleafBlock(BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(WATERLOGGED, false)).setValue(FACING, EnumDirection.NORTH)).setValue(TILT, Tilt.NONE));
        this.shapesCache = this.getShapeForEachState(BigDripleafBlock::calculateShape);
    }

    private static VoxelShape calculateShape(IBlockData iblockdata) {
        return VoxelShapes.or(LEAF_SHAPES.get(iblockdata.getValue(TILT)), STEM_SHAPES.get(iblockdata.getValue(FACING)));
    }

    public static void placeWithRandomHeight(GeneratorAccess generatoraccess, RandomSource randomsource, BlockPosition blockposition, EnumDirection enumdirection) {
        int j2;
        int i2 = MathHelper.nextInt(randomsource, 2, 5);
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = blockposition.mutable();
        for (j2 = 0; j2 < i2 && BigDripleafBlock.canPlaceAt(generatoraccess, blockposition_mutableblockposition, generatoraccess.getBlockState(blockposition_mutableblockposition)); ++j2) {
            blockposition_mutableblockposition.move(EnumDirection.UP);
        }
        int k2 = blockposition.getY() + j2 - 1;
        blockposition_mutableblockposition.setY(blockposition.getY());
        while (blockposition_mutableblockposition.getY() < k2) {
            BigDripleafStemBlock.place(generatoraccess, blockposition_mutableblockposition, generatoraccess.getFluidState(blockposition_mutableblockposition), enumdirection);
            blockposition_mutableblockposition.move(EnumDirection.UP);
        }
        BigDripleafBlock.place(generatoraccess, blockposition_mutableblockposition, generatoraccess.getFluidState(blockposition_mutableblockposition), enumdirection);
    }

    private static boolean canReplace(IBlockData iblockdata) {
        return iblockdata.isAir() || iblockdata.is(Blocks.WATER) || iblockdata.is(Blocks.SMALL_DRIPLEAF);
    }

    protected static boolean canPlaceAt(LevelHeightAccessor levelheightaccessor, BlockPosition blockposition, IBlockData iblockdata) {
        return !levelheightaccessor.isOutsideBuildHeight(blockposition) && BigDripleafBlock.canReplace(iblockdata);
    }

    protected static boolean place(GeneratorAccess generatoraccess, BlockPosition blockposition, Fluid fluid, EnumDirection enumdirection) {
        IBlockData iblockdata = (IBlockData)((IBlockData)Blocks.BIG_DRIPLEAF.defaultBlockState().setValue(WATERLOGGED, fluid.isSourceOfType(FluidTypes.WATER))).setValue(FACING, enumdirection);
        return generatoraccess.setBlock(blockposition, iblockdata, 3);
    }

    @Override
    protected void onProjectileHit(World world, IBlockData iblockdata, MovingObjectPositionBlock movingobjectpositionblock, IProjectile iprojectile) {
        this.setTiltAndScheduleTick(iblockdata, world, movingobjectpositionblock.getBlockPos(), Tilt.FULL, SoundEffects.BIG_DRIPLEAF_TILT_DOWN, iprojectile);
    }

    @Override
    protected Fluid getFluidState(IBlockData iblockdata) {
        return iblockdata.getValue(WATERLOGGED) != false ? FluidTypes.WATER.getSource(false) : super.getFluidState(iblockdata);
    }

    @Override
    protected boolean canSurvive(IBlockData iblockdata, IWorldReader iworldreader, BlockPosition blockposition) {
        BlockPosition blockposition1 = blockposition.below();
        IBlockData iblockdata1 = iworldreader.getBlockState(blockposition1);
        return iblockdata1.is(this) || iblockdata1.is(Blocks.BIG_DRIPLEAF_STEM) || iblockdata1.is(TagsBlock.BIG_DRIPLEAF_PLACEABLE);
    }

    @Override
    protected IBlockData updateShape(IBlockData iblockdata, EnumDirection enumdirection, IBlockData iblockdata1, GeneratorAccess generatoraccess, BlockPosition blockposition, BlockPosition blockposition1) {
        if (enumdirection == EnumDirection.DOWN && !iblockdata.canSurvive(generatoraccess, blockposition)) {
            return Blocks.AIR.defaultBlockState();
        }
        if (iblockdata.getValue(WATERLOGGED).booleanValue()) {
            generatoraccess.scheduleTick(blockposition, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(generatoraccess));
        }
        return enumdirection == EnumDirection.UP && iblockdata1.is(this) ? Blocks.BIG_DRIPLEAF_STEM.withPropertiesOf(iblockdata) : super.updateShape(iblockdata, enumdirection, iblockdata1, generatoraccess, blockposition, blockposition1);
    }

    @Override
    public boolean isValidBonemealTarget(IWorldReader iworldreader, BlockPosition blockposition, IBlockData iblockdata) {
        IBlockData iblockdata1 = iworldreader.getBlockState(blockposition.above());
        return BigDripleafBlock.canReplace(iblockdata1);
    }

    @Override
    public boolean isBonemealSuccess(World world, RandomSource randomsource, BlockPosition blockposition, IBlockData iblockdata) {
        return true;
    }

    @Override
    public void performBonemeal(WorldServer worldserver, RandomSource randomsource, BlockPosition blockposition, IBlockData iblockdata) {
        IBlockData iblockdata1;
        BlockPosition blockposition1 = blockposition.above();
        if (BigDripleafBlock.canPlaceAt(worldserver, blockposition1, iblockdata1 = worldserver.getBlockState(blockposition1))) {
            EnumDirection enumdirection = iblockdata.getValue(FACING);
            BigDripleafStemBlock.place(worldserver, blockposition, iblockdata.getFluidState(), enumdirection);
            BigDripleafBlock.place(worldserver, blockposition1, iblockdata1.getFluidState(), enumdirection);
        }
    }

    @Override
    protected void entityInside(IBlockData iblockdata, World world, BlockPosition blockposition, net.minecraft.world.entity.Entity entity) {
        if (!world.isClientSide && iblockdata.getValue(TILT) == Tilt.NONE && BigDripleafBlock.canEntityTilt(blockposition, entity) && !world.hasNeighborSignal(blockposition)) {
            PlayerInteractEvent cancellable;
            if (entity instanceof EntityHuman) {
                cancellable = CraftEventFactory.callPlayerInteractEvent((EntityHuman)entity, Action.PHYSICAL, blockposition, null, null, null);
            } else {
                cancellable = new EntityInteractEvent((Entity)entity.getBukkitEntity(), world.getWorld().getBlockAt(blockposition.getX(), blockposition.getY(), blockposition.getZ()));
                world.getCraftServer().getPluginManager().callEvent((Event)((EntityInteractEvent)cancellable));
            }
            if (cancellable.isCancelled()) {
                return;
            }
            this.setTiltAndScheduleTick(iblockdata, world, blockposition, Tilt.UNSTABLE, null, entity);
        }
    }

    @Override
    protected void tick(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        if (worldserver.hasNeighborSignal(blockposition)) {
            BigDripleafBlock.resetTilt(iblockdata, worldserver, blockposition);
        } else {
            Tilt tilt = iblockdata.getValue(TILT);
            if (tilt == Tilt.UNSTABLE) {
                this.setTiltAndScheduleTick(iblockdata, worldserver, blockposition, Tilt.PARTIAL, SoundEffects.BIG_DRIPLEAF_TILT_DOWN, null);
            } else if (tilt == Tilt.PARTIAL) {
                this.setTiltAndScheduleTick(iblockdata, worldserver, blockposition, Tilt.FULL, SoundEffects.BIG_DRIPLEAF_TILT_DOWN, null);
            } else if (tilt == Tilt.FULL) {
                BigDripleafBlock.resetTilt(iblockdata, worldserver, blockposition);
            }
        }
    }

    @Override
    protected void neighborChanged(IBlockData iblockdata, World world, BlockPosition blockposition, Block block, BlockPosition blockposition1, boolean flag) {
        if (world.hasNeighborSignal(blockposition)) {
            BigDripleafBlock.resetTilt(iblockdata, world, blockposition);
        }
    }

    private static void playTiltSound(World world, BlockPosition blockposition, SoundEffect soundeffect) {
        float f2 = MathHelper.randomBetween(world.random, 0.8f, 1.2f);
        world.playSound((EntityHuman)null, blockposition, soundeffect, SoundCategory.BLOCKS, 1.0f, f2);
    }

    private static boolean canEntityTilt(BlockPosition blockposition, net.minecraft.world.entity.Entity entity) {
        return entity.onGround() && entity.position().y > (double)((float)blockposition.getY() + 0.6875f);
    }

    private void setTiltAndScheduleTick(IBlockData iblockdata, World world, BlockPosition blockposition, Tilt tilt, @Nullable SoundEffect soundeffect, @Nullable net.minecraft.world.entity.Entity entity) {
        int i2;
        if (!BigDripleafBlock.setTilt(iblockdata, world, blockposition, tilt, entity)) {
            return;
        }
        if (soundeffect != null) {
            BigDripleafBlock.playTiltSound(world, blockposition, soundeffect);
        }
        if ((i2 = DELAY_UNTIL_NEXT_TILT_STATE.getInt((Object)tilt)) != -1) {
            world.scheduleTick(blockposition, this, i2);
        }
    }

    private static void resetTilt(IBlockData iblockdata, World world, BlockPosition blockposition) {
        BigDripleafBlock.setTilt(iblockdata, world, blockposition, Tilt.NONE, null);
        if (iblockdata.getValue(TILT) != Tilt.NONE) {
            BigDripleafBlock.playTiltSound(world, blockposition, SoundEffects.BIG_DRIPLEAF_TILT_UP);
        }
    }

    private static boolean setTilt(IBlockData iblockdata, World world, BlockPosition blockposition, Tilt tilt, @Nullable net.minecraft.world.entity.Entity entity) {
        if (entity != null && !CraftEventFactory.callEntityChangeBlockEvent(entity, blockposition, (IBlockData)iblockdata.setValue(TILT, tilt))) {
            return false;
        }
        Tilt tilt1 = iblockdata.getValue(TILT);
        world.setBlock(blockposition, (IBlockData)iblockdata.setValue(TILT, tilt), 2);
        if (tilt.causesVibration() && tilt != tilt1) {
            world.gameEvent((net.minecraft.world.entity.Entity)null, GameEvent.BLOCK_CHANGE, blockposition);
        }
        return true;
    }

    @Override
    protected VoxelShape getCollisionShape(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return LEAF_SHAPES.get(iblockdata.getValue(TILT));
    }

    @Override
    protected VoxelShape getShape(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return this.shapesCache.get(iblockdata);
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext blockactioncontext) {
        IBlockData iblockdata = blockactioncontext.getLevel().getBlockState(blockactioncontext.getClickedPos().below());
        Fluid fluid = blockactioncontext.getLevel().getFluidState(blockactioncontext.getClickedPos());
        boolean flag = iblockdata.is(Blocks.BIG_DRIPLEAF) || iblockdata.is(Blocks.BIG_DRIPLEAF_STEM);
        return (IBlockData)((IBlockData)this.defaultBlockState().setValue(WATERLOGGED, fluid.isSourceOfType(FluidTypes.WATER))).setValue(FACING, flag ? iblockdata.getValue(FACING) : blockactioncontext.getHorizontalDirection().getOpposite());
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.add(WATERLOGGED, FACING, TILT);
    }
}

