/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemSword;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyBambooSize;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;

public class BlockBamboo
extends Block
implements IBlockFragilePlantElement {
    public static final MapCodec<BlockBamboo> CODEC = BlockBamboo.simpleCodec(BlockBamboo::new);
    protected static final float SMALL_LEAVES_AABB_OFFSET = 3.0f;
    protected static final float LARGE_LEAVES_AABB_OFFSET = 5.0f;
    protected static final float COLLISION_AABB_OFFSET = 1.5f;
    protected static final VoxelShape SMALL_SHAPE = Block.box(5.0, 0.0, 5.0, 11.0, 16.0, 11.0);
    protected static final VoxelShape LARGE_SHAPE = Block.box(3.0, 0.0, 3.0, 13.0, 16.0, 13.0);
    protected static final VoxelShape COLLISION_SHAPE = Block.box(6.5, 0.0, 6.5, 9.5, 16.0, 9.5);
    public static final BlockStateInteger AGE = BlockProperties.AGE_1;
    public static final BlockStateEnum<BlockPropertyBambooSize> LEAVES = BlockProperties.BAMBOO_LEAVES;
    public static final BlockStateInteger STAGE = BlockProperties.STAGE;
    public static final int MAX_HEIGHT = 16;
    public static final int STAGE_GROWING = 0;
    public static final int STAGE_DONE_GROWING = 1;
    public static final int AGE_THIN_BAMBOO = 0;
    public static final int AGE_THICK_BAMBOO = 1;

    public MapCodec<BlockBamboo> codec() {
        return CODEC;
    }

    public BlockBamboo(BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(AGE, 0)).setValue(LEAVES, BlockPropertyBambooSize.NONE)).setValue(STAGE, 0));
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.add(AGE, LEAVES, STAGE);
    }

    @Override
    protected boolean propagatesSkylightDown(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition) {
        return true;
    }

    @Override
    protected VoxelShape getShape(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        VoxelShape voxelshape = iblockdata.getValue(LEAVES) == BlockPropertyBambooSize.LARGE ? LARGE_SHAPE : SMALL_SHAPE;
        Vec3D vec3d = iblockdata.getOffset(iblockaccess, blockposition);
        return voxelshape.move(vec3d.x, vec3d.y, vec3d.z);
    }

    @Override
    protected boolean isPathfindable(IBlockData iblockdata, PathMode pathmode) {
        return false;
    }

    @Override
    protected VoxelShape getCollisionShape(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        Vec3D vec3d = iblockdata.getOffset(iblockaccess, blockposition);
        return COLLISION_SHAPE.move(vec3d.x, vec3d.y, vec3d.z);
    }

    @Override
    protected boolean isCollisionShapeFullBlock(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition) {
        return false;
    }

    @Override
    @Nullable
    public IBlockData getStateForPlacement(BlockActionContext blockactioncontext) {
        Fluid fluid = blockactioncontext.getLevel().getFluidState(blockactioncontext.getClickedPos());
        if (!fluid.isEmpty()) {
            return null;
        }
        IBlockData iblockdata = blockactioncontext.getLevel().getBlockState(blockactioncontext.getClickedPos().below());
        if (iblockdata.is(TagsBlock.BAMBOO_PLANTABLE_ON)) {
            if (iblockdata.is(Blocks.BAMBOO_SAPLING)) {
                return (IBlockData)this.defaultBlockState().setValue(AGE, 0);
            }
            if (iblockdata.is(Blocks.BAMBOO)) {
                int i2 = iblockdata.getValue(AGE) > 0 ? 1 : 0;
                return (IBlockData)this.defaultBlockState().setValue(AGE, i2);
            }
            IBlockData iblockdata1 = blockactioncontext.getLevel().getBlockState(blockactioncontext.getClickedPos().above());
            return iblockdata1.is(Blocks.BAMBOO) ? (IBlockData)this.defaultBlockState().setValue(AGE, iblockdata1.getValue(AGE)) : Blocks.BAMBOO_SAPLING.defaultBlockState();
        }
        return null;
    }

    @Override
    protected void tick(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        if (!iblockdata.canSurvive(worldserver, blockposition)) {
            worldserver.destroyBlock(blockposition, true);
        }
    }

    @Override
    protected boolean isRandomlyTicking(IBlockData iblockdata) {
        return iblockdata.getValue(STAGE) == 0;
    }

    @Override
    protected void randomTick(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        int i2;
        if (iblockdata.getValue(STAGE) == 0 && randomsource.nextFloat() < (float)worldserver.spigotConfig.bambooModifier / 300.0f && worldserver.isEmptyBlock(blockposition.above()) && worldserver.getRawBrightness(blockposition.above(), 0) >= 9 && (i2 = this.getHeightBelowUpToMax(worldserver, blockposition) + 1) < 16) {
            this.growBamboo(iblockdata, worldserver, blockposition, randomsource, i2);
        }
    }

    @Override
    protected boolean canSurvive(IBlockData iblockdata, IWorldReader iworldreader, BlockPosition blockposition) {
        return iworldreader.getBlockState(blockposition.below()).is(TagsBlock.BAMBOO_PLANTABLE_ON);
    }

    @Override
    protected IBlockData updateShape(IBlockData iblockdata, EnumDirection enumdirection, IBlockData iblockdata1, GeneratorAccess generatoraccess, BlockPosition blockposition, BlockPosition blockposition1) {
        if (!iblockdata.canSurvive(generatoraccess, blockposition)) {
            generatoraccess.scheduleTick(blockposition, this, 1);
        }
        if (enumdirection == EnumDirection.UP && iblockdata1.is(Blocks.BAMBOO) && iblockdata1.getValue(AGE) > iblockdata.getValue(AGE)) {
            generatoraccess.setBlock(blockposition, (IBlockData)iblockdata.cycle(AGE), 2);
        }
        return super.updateShape(iblockdata, enumdirection, iblockdata1, generatoraccess, blockposition, blockposition1);
    }

    @Override
    public boolean isValidBonemealTarget(IWorldReader iworldreader, BlockPosition blockposition, IBlockData iblockdata) {
        int j2;
        int i2 = this.getHeightAboveUpToMax(iworldreader, blockposition);
        return i2 + (j2 = this.getHeightBelowUpToMax(iworldreader, blockposition)) + 1 < 16 && iworldreader.getBlockState(blockposition.above(i2)).getValue(STAGE) != 1;
    }

    @Override
    public boolean isBonemealSuccess(World world, RandomSource randomsource, BlockPosition blockposition, IBlockData iblockdata) {
        return true;
    }

    @Override
    public void performBonemeal(WorldServer worldserver, RandomSource randomsource, BlockPosition blockposition, IBlockData iblockdata) {
        int i2 = this.getHeightAboveUpToMax(worldserver, blockposition);
        int j2 = this.getHeightBelowUpToMax(worldserver, blockposition);
        int k2 = i2 + j2 + 1;
        int l2 = 1 + randomsource.nextInt(2);
        for (int i1 = 0; i1 < l2; ++i1) {
            BlockPosition blockposition1 = blockposition.above(i2);
            IBlockData iblockdata1 = worldserver.getBlockState(blockposition1);
            if (k2 >= 16 || !iblockdata1.is(Blocks.BAMBOO) || iblockdata1.getValue(STAGE) == 1 || !worldserver.isEmptyBlock(blockposition1.above())) {
                return;
            }
            this.growBamboo(iblockdata1, worldserver, blockposition1, randomsource, k2);
            ++i2;
            ++k2;
        }
    }

    @Override
    protected float getDestroyProgress(IBlockData iblockdata, EntityHuman entityhuman, IBlockAccess iblockaccess, BlockPosition blockposition) {
        return entityhuman.getMainHandItem().getItem() instanceof ItemSword ? 1.0f : super.getDestroyProgress(iblockdata, entityhuman, iblockaccess, blockposition);
    }

    protected void growBamboo(IBlockData iblockdata, World world, BlockPosition blockposition, RandomSource randomsource, int i2) {
        int k2;
        IBlockData iblockdata1 = world.getBlockState(blockposition.below());
        BlockPosition blockposition1 = blockposition.below(2);
        IBlockData iblockdata2 = world.getBlockState(blockposition1);
        BlockPropertyBambooSize blockpropertybamboosize = BlockPropertyBambooSize.NONE;
        boolean shouldUpdateOthers = false;
        if (i2 >= 1) {
            if (iblockdata1.is(Blocks.BAMBOO) && iblockdata1.getValue(LEAVES) != BlockPropertyBambooSize.NONE) {
                if (iblockdata1.is(Blocks.BAMBOO) && iblockdata1.getValue(LEAVES) != BlockPropertyBambooSize.NONE) {
                    blockpropertybamboosize = BlockPropertyBambooSize.LARGE;
                    if (iblockdata2.is(Blocks.BAMBOO)) {
                        shouldUpdateOthers = true;
                    }
                }
            } else {
                blockpropertybamboosize = BlockPropertyBambooSize.SMALL;
            }
        }
        int j2 = iblockdata.getValue(AGE) != 1 && !iblockdata2.is(Blocks.BAMBOO) ? 0 : 1;
        int n2 = k2 = (i2 < 11 || randomsource.nextFloat() >= 0.25f) && i2 != 15 ? 0 : 1;
        if (CraftEventFactory.handleBlockSpreadEvent(world, blockposition, blockposition.above(), (IBlockData)((IBlockData)((IBlockData)this.defaultBlockState().setValue(AGE, j2)).setValue(LEAVES, blockpropertybamboosize)).setValue(STAGE, k2), 3) && shouldUpdateOthers) {
            world.setBlock(blockposition.below(), (IBlockData)iblockdata1.setValue(LEAVES, BlockPropertyBambooSize.SMALL), 3);
            world.setBlock(blockposition1, (IBlockData)iblockdata2.setValue(LEAVES, BlockPropertyBambooSize.NONE), 3);
        }
    }

    protected int getHeightAboveUpToMax(IBlockAccess iblockaccess, BlockPosition blockposition) {
        int i2;
        for (i2 = 0; i2 < 16 && iblockaccess.getBlockState(blockposition.above(i2 + 1)).is(Blocks.BAMBOO); ++i2) {
        }
        return i2;
    }

    protected int getHeightBelowUpToMax(IBlockAccess iblockaccess, BlockPosition blockposition) {
        int i2;
        for (i2 = 0; i2 < 16 && iblockaccess.getBlockState(blockposition.below(i2 + 1)).is(Blocks.BAMBOO); ++i2) {
        }
        return i2;
    }
}

