/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoubleBlockFinder;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.ITileEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBed;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyBedPart;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.apache.commons.lang3.ArrayUtils;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;

public class BlockBed
extends BlockFacingHorizontal
implements ITileEntity {
    public static final MapCodec<BlockBed> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)EnumColor.CODEC.fieldOf("color").forGetter(BlockBed::getColor), BlockBed.propertiesCodec()).apply((Applicative)instance, BlockBed::new));
    public static final BlockStateEnum<BlockPropertyBedPart> PART = BlockProperties.BED_PART;
    public static final BlockStateBoolean OCCUPIED = BlockProperties.OCCUPIED;
    protected static final int HEIGHT = 9;
    protected static final VoxelShape BASE = Block.box(0.0, 3.0, 0.0, 16.0, 9.0, 16.0);
    private static final int LEG_WIDTH = 3;
    protected static final VoxelShape LEG_NORTH_WEST = Block.box(0.0, 0.0, 0.0, 3.0, 3.0, 3.0);
    protected static final VoxelShape LEG_SOUTH_WEST = Block.box(0.0, 0.0, 13.0, 3.0, 3.0, 16.0);
    protected static final VoxelShape LEG_NORTH_EAST = Block.box(13.0, 0.0, 0.0, 16.0, 3.0, 3.0);
    protected static final VoxelShape LEG_SOUTH_EAST = Block.box(13.0, 0.0, 13.0, 16.0, 3.0, 16.0);
    protected static final VoxelShape NORTH_SHAPE = VoxelShapes.or(BASE, LEG_NORTH_WEST, LEG_NORTH_EAST);
    protected static final VoxelShape SOUTH_SHAPE = VoxelShapes.or(BASE, LEG_SOUTH_WEST, LEG_SOUTH_EAST);
    protected static final VoxelShape WEST_SHAPE = VoxelShapes.or(BASE, LEG_NORTH_WEST, LEG_SOUTH_WEST);
    protected static final VoxelShape EAST_SHAPE = VoxelShapes.or(BASE, LEG_NORTH_EAST, LEG_SOUTH_EAST);
    private final EnumColor color;

    public MapCodec<BlockBed> codec() {
        return CODEC;
    }

    public BlockBed(EnumColor enumcolor, BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.color = enumcolor;
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(PART, BlockPropertyBedPart.FOOT)).setValue(OCCUPIED, false));
    }

    @Nullable
    public static EnumDirection getBedOrientation(IBlockAccess iblockaccess, BlockPosition blockposition) {
        IBlockData iblockdata = iblockaccess.getBlockState(blockposition);
        return iblockdata.getBlock() instanceof BlockBed ? iblockdata.getValue(FACING) : null;
    }

    @Override
    protected EnumInteractionResult useWithoutItem(IBlockData iblockdata, World world, BlockPosition blockposition, EntityHuman entityhuman, MovingObjectPositionBlock movingobjectpositionblock) {
        if (world.isClientSide) {
            return EnumInteractionResult.CONSUME;
        }
        if (iblockdata.getValue(PART) != BlockPropertyBedPart.HEAD && !(iblockdata = world.getBlockState(blockposition = blockposition.relative(iblockdata.getValue(FACING)))).is(this)) {
            return EnumInteractionResult.CONSUME;
        }
        if (iblockdata.getValue(OCCUPIED).booleanValue()) {
            if (!this.kickVillagerOutOfBed(world, blockposition)) {
                entityhuman.displayClientMessage(IChatBaseComponent.translatable("block.minecraft.bed.occupied"), true);
            }
            return EnumInteractionResult.SUCCESS;
        }
        IBlockData finaliblockdata = iblockdata;
        BlockPosition finalblockposition = blockposition;
        entityhuman.startSleepInBed(blockposition).ifLeft(entityhuman_enumbedresult -> {
            if (!world.dimensionType().bedWorks()) {
                this.explodeBed(finaliblockdata, world, finalblockposition);
            } else if (entityhuman_enumbedresult.getMessage() != null) {
                entityhuman.displayClientMessage(entityhuman_enumbedresult.getMessage(), true);
            }
        });
        return EnumInteractionResult.SUCCESS;
    }

    private EnumInteractionResult explodeBed(IBlockData iblockdata, World world, BlockPosition blockposition) {
        BlockState blockState = CraftBlock.at(world, blockposition).getState();
        world.removeBlock(blockposition, false);
        BlockPosition blockposition1 = blockposition.relative(iblockdata.getValue(FACING).getOpposite());
        if (world.getBlockState(blockposition1).getBlock() == this) {
            world.removeBlock(blockposition1, false);
        }
        Vec3D vec3d = blockposition.getCenter();
        world.explode((Entity)null, world.damageSources().badRespawnPointExplosion(vec3d, blockState), null, vec3d, 5.0f, true, World.a.BLOCK);
        return EnumInteractionResult.SUCCESS;
    }

    public static boolean canSetSpawn(World world) {
        return true;
    }

    private boolean kickVillagerOutOfBed(World world, BlockPosition blockposition) {
        List<EntityVillager> list = world.getEntitiesOfClass(EntityVillager.class, new AxisAlignedBB(blockposition), EntityLiving::isSleeping);
        if (list.isEmpty()) {
            return false;
        }
        list.get(0).stopSleeping();
        return true;
    }

    @Override
    public void fallOn(World world, IBlockData iblockdata, BlockPosition blockposition, Entity entity, float f2) {
        super.fallOn(world, iblockdata, blockposition, entity, f2 * 0.5f);
    }

    @Override
    public void updateEntityAfterFallOn(IBlockAccess iblockaccess, Entity entity) {
        if (entity.isSuppressingBounce()) {
            super.updateEntityAfterFallOn(iblockaccess, entity);
        } else {
            this.bounceUp(entity);
        }
    }

    private void bounceUp(Entity entity) {
        Vec3D vec3d = entity.getDeltaMovement();
        if (vec3d.y < 0.0) {
            double d0 = entity instanceof EntityLiving ? 1.0 : 0.8;
            entity.setDeltaMovement(vec3d.x, -vec3d.y * (double)0.66f * d0, vec3d.z);
        }
    }

    @Override
    protected IBlockData updateShape(IBlockData iblockdata, EnumDirection enumdirection, IBlockData iblockdata1, GeneratorAccess generatoraccess, BlockPosition blockposition, BlockPosition blockposition1) {
        return enumdirection == BlockBed.getNeighbourDirection(iblockdata.getValue(PART), iblockdata.getValue(FACING)) ? (iblockdata1.is(this) && iblockdata1.getValue(PART) != iblockdata.getValue(PART) ? (IBlockData)iblockdata.setValue(OCCUPIED, iblockdata1.getValue(OCCUPIED)) : Blocks.AIR.defaultBlockState()) : super.updateShape(iblockdata, enumdirection, iblockdata1, generatoraccess, blockposition, blockposition1);
    }

    private static EnumDirection getNeighbourDirection(BlockPropertyBedPart blockpropertybedpart, EnumDirection enumdirection) {
        return blockpropertybedpart == BlockPropertyBedPart.FOOT ? enumdirection : enumdirection.getOpposite();
    }

    @Override
    public IBlockData playerWillDestroy(World world, BlockPosition blockposition, IBlockData iblockdata, EntityHuman entityhuman) {
        BlockPosition blockposition1;
        IBlockData iblockdata1;
        BlockPropertyBedPart blockpropertybedpart;
        if (!world.isClientSide && entityhuman.isCreative() && (blockpropertybedpart = iblockdata.getValue(PART)) == BlockPropertyBedPart.FOOT && (iblockdata1 = world.getBlockState(blockposition1 = blockposition.relative(BlockBed.getNeighbourDirection(blockpropertybedpart, iblockdata.getValue(FACING))))).is(this) && iblockdata1.getValue(PART) == BlockPropertyBedPart.HEAD) {
            world.setBlock(blockposition1, Blocks.AIR.defaultBlockState(), 35);
            world.levelEvent(entityhuman, 2001, blockposition1, Block.getId(iblockdata1));
        }
        return super.playerWillDestroy(world, blockposition, iblockdata, entityhuman);
    }

    @Override
    @Nullable
    public IBlockData getStateForPlacement(BlockActionContext blockactioncontext) {
        EnumDirection enumdirection = blockactioncontext.getHorizontalDirection();
        BlockPosition blockposition = blockactioncontext.getClickedPos();
        BlockPosition blockposition1 = blockposition.relative(enumdirection);
        World world = blockactioncontext.getLevel();
        return world.getBlockState(blockposition1).canBeReplaced(blockactioncontext) && world.getWorldBorder().isWithinBounds(blockposition1) ? (IBlockData)this.defaultBlockState().setValue(FACING, enumdirection) : null;
    }

    @Override
    protected VoxelShape getShape(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        EnumDirection enumdirection = BlockBed.getConnectedDirection(iblockdata).getOpposite();
        switch (enumdirection) {
            case NORTH: {
                return NORTH_SHAPE;
            }
            case SOUTH: {
                return SOUTH_SHAPE;
            }
            case WEST: {
                return WEST_SHAPE;
            }
        }
        return EAST_SHAPE;
    }

    public static EnumDirection getConnectedDirection(IBlockData iblockdata) {
        EnumDirection enumdirection = iblockdata.getValue(FACING);
        return iblockdata.getValue(PART) == BlockPropertyBedPart.HEAD ? enumdirection.getOpposite() : enumdirection;
    }

    public static DoubleBlockFinder.BlockType getBlockType(IBlockData iblockdata) {
        BlockPropertyBedPart blockpropertybedpart = iblockdata.getValue(PART);
        return blockpropertybedpart == BlockPropertyBedPart.HEAD ? DoubleBlockFinder.BlockType.FIRST : DoubleBlockFinder.BlockType.SECOND;
    }

    private static boolean isBunkBed(IBlockAccess iblockaccess, BlockPosition blockposition) {
        return iblockaccess.getBlockState(blockposition.below()).getBlock() instanceof BlockBed;
    }

    public static Optional<Vec3D> findStandUpPosition(EntityTypes<?> entitytypes, ICollisionAccess icollisionaccess, BlockPosition blockposition, EnumDirection enumdirection, float f2) {
        EnumDirection enumdirection2;
        EnumDirection enumdirection1 = enumdirection.getClockWise();
        EnumDirection enumDirection = enumdirection2 = enumdirection1.isFacingAngle(f2) ? enumdirection1.getOpposite() : enumdirection1;
        if (BlockBed.isBunkBed(icollisionaccess, blockposition)) {
            return BlockBed.findBunkBedStandUpPosition(entitytypes, icollisionaccess, blockposition, enumdirection, enumdirection2);
        }
        int[][] aint = BlockBed.bedStandUpOffsets(enumdirection, enumdirection2);
        Optional<Vec3D> optional = BlockBed.findStandUpPositionAtOffset(entitytypes, icollisionaccess, blockposition, aint, true);
        return optional.isPresent() ? optional : BlockBed.findStandUpPositionAtOffset(entitytypes, icollisionaccess, blockposition, aint, false);
    }

    private static Optional<Vec3D> findBunkBedStandUpPosition(EntityTypes<?> entitytypes, ICollisionAccess icollisionaccess, BlockPosition blockposition, EnumDirection enumdirection, EnumDirection enumdirection1) {
        int[][] aint = BlockBed.bedSurroundStandUpOffsets(enumdirection, enumdirection1);
        Optional<Vec3D> optional = BlockBed.findStandUpPositionAtOffset(entitytypes, icollisionaccess, blockposition, aint, true);
        if (optional.isPresent()) {
            return optional;
        }
        BlockPosition blockposition1 = blockposition.below();
        Optional<Vec3D> optional1 = BlockBed.findStandUpPositionAtOffset(entitytypes, icollisionaccess, blockposition1, aint, true);
        if (optional1.isPresent()) {
            return optional1;
        }
        int[][] aint1 = BlockBed.bedAboveStandUpOffsets(enumdirection);
        Optional<Vec3D> optional2 = BlockBed.findStandUpPositionAtOffset(entitytypes, icollisionaccess, blockposition, aint1, true);
        if (optional2.isPresent()) {
            return optional2;
        }
        Optional<Vec3D> optional3 = BlockBed.findStandUpPositionAtOffset(entitytypes, icollisionaccess, blockposition, aint, false);
        if (optional3.isPresent()) {
            return optional3;
        }
        Optional<Vec3D> optional4 = BlockBed.findStandUpPositionAtOffset(entitytypes, icollisionaccess, blockposition1, aint, false);
        return optional4.isPresent() ? optional4 : BlockBed.findStandUpPositionAtOffset(entitytypes, icollisionaccess, blockposition, aint1, false);
    }

    private static Optional<Vec3D> findStandUpPositionAtOffset(EntityTypes<?> entitytypes, ICollisionAccess icollisionaccess, BlockPosition blockposition, int[][] aint, boolean flag) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        int[][] aint1 = aint;
        int i2 = aint.length;
        for (int j2 = 0; j2 < i2; ++j2) {
            int[] aint2 = aint1[j2];
            blockposition_mutableblockposition.set(blockposition.getX() + aint2[0], blockposition.getY(), blockposition.getZ() + aint2[1]);
            Vec3D vec3d = DismountUtil.findSafeDismountLocation(entitytypes, icollisionaccess, blockposition_mutableblockposition, flag);
            if (vec3d == null) continue;
            return Optional.of(vec3d);
        }
        return Optional.empty();
    }

    @Override
    protected EnumRenderType getRenderShape(IBlockData iblockdata) {
        return EnumRenderType.ENTITYBLOCK_ANIMATED;
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.add(FACING, PART, OCCUPIED);
    }

    @Override
    public TileEntity newBlockEntity(BlockPosition blockposition, IBlockData iblockdata) {
        return new TileEntityBed(blockposition, iblockdata, this.color);
    }

    @Override
    public void setPlacedBy(World world, BlockPosition blockposition, IBlockData iblockdata, @Nullable EntityLiving entityliving, ItemStack itemstack) {
        super.setPlacedBy(world, blockposition, iblockdata, entityliving, itemstack);
        if (!world.isClientSide) {
            BlockPosition blockposition1 = blockposition.relative(iblockdata.getValue(FACING));
            world.setBlock(blockposition1, (IBlockData)iblockdata.setValue(PART, BlockPropertyBedPart.HEAD), 3);
            if (world.captureBlockStates) {
                return;
            }
            world.blockUpdated(blockposition, Blocks.AIR);
            iblockdata.updateNeighbourShapes(world, blockposition, 3);
        }
    }

    public EnumColor getColor() {
        return this.color;
    }

    @Override
    protected long getSeed(IBlockData iblockdata, BlockPosition blockposition) {
        BlockPosition blockposition1 = blockposition.relative(iblockdata.getValue(FACING), iblockdata.getValue(PART) == BlockPropertyBedPart.HEAD ? 0 : 1);
        return MathHelper.getSeed(blockposition1.getX(), blockposition.getY(), blockposition1.getZ());
    }

    @Override
    protected boolean isPathfindable(IBlockData iblockdata, PathMode pathmode) {
        return false;
    }

    private static int[][] bedStandUpOffsets(EnumDirection enumdirection, EnumDirection enumdirection1) {
        return (int[][])ArrayUtils.addAll((Object[])BlockBed.bedSurroundStandUpOffsets(enumdirection, enumdirection1), (Object[])BlockBed.bedAboveStandUpOffsets(enumdirection));
    }

    private static int[][] bedSurroundStandUpOffsets(EnumDirection enumdirection, EnumDirection enumdirection1) {
        return new int[][]{{enumdirection1.getStepX(), enumdirection1.getStepZ()}, {enumdirection1.getStepX() - enumdirection.getStepX(), enumdirection1.getStepZ() - enumdirection.getStepZ()}, {enumdirection1.getStepX() - enumdirection.getStepX() * 2, enumdirection1.getStepZ() - enumdirection.getStepZ() * 2}, {-enumdirection.getStepX() * 2, -enumdirection.getStepZ() * 2}, {-enumdirection1.getStepX() - enumdirection.getStepX() * 2, -enumdirection1.getStepZ() - enumdirection.getStepZ() * 2}, {-enumdirection1.getStepX() - enumdirection.getStepX(), -enumdirection1.getStepZ() - enumdirection.getStepZ()}, {-enumdirection1.getStepX(), -enumdirection1.getStepZ()}, {-enumdirection1.getStepX() + enumdirection.getStepX(), -enumdirection1.getStepZ() + enumdirection.getStepZ()}, {enumdirection.getStepX(), enumdirection.getStepZ()}, {enumdirection1.getStepX() + enumdirection.getStepX(), enumdirection1.getStepZ() + enumdirection.getStepZ()}};
    }

    private static int[][] bedAboveStandUpOffsets(EnumDirection enumdirection) {
        return new int[][]{{0, 0}, {-enumdirection.getStepX(), -enumdirection.getStepZ()}};
    }
}

