/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockAttachable;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBell;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyBellAttach;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateDirection;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;

public class BlockBell
extends BlockTileEntity {
    public static final MapCodec<BlockBell> CODEC = BlockBell.simpleCodec(BlockBell::new);
    public static final BlockStateDirection FACING = BlockFacingHorizontal.FACING;
    public static final BlockStateEnum<BlockPropertyBellAttach> ATTACHMENT = BlockProperties.BELL_ATTACHMENT;
    public static final BlockStateBoolean POWERED = BlockProperties.POWERED;
    private static final VoxelShape NORTH_SOUTH_FLOOR_SHAPE = Block.box(0.0, 0.0, 4.0, 16.0, 16.0, 12.0);
    private static final VoxelShape EAST_WEST_FLOOR_SHAPE = Block.box(4.0, 0.0, 0.0, 12.0, 16.0, 16.0);
    private static final VoxelShape BELL_TOP_SHAPE = Block.box(5.0, 6.0, 5.0, 11.0, 13.0, 11.0);
    private static final VoxelShape BELL_BOTTOM_SHAPE = Block.box(4.0, 4.0, 4.0, 12.0, 6.0, 12.0);
    private static final VoxelShape BELL_SHAPE = VoxelShapes.or(BELL_BOTTOM_SHAPE, BELL_TOP_SHAPE);
    private static final VoxelShape NORTH_SOUTH_BETWEEN = VoxelShapes.or(BELL_SHAPE, Block.box(7.0, 13.0, 0.0, 9.0, 15.0, 16.0));
    private static final VoxelShape EAST_WEST_BETWEEN = VoxelShapes.or(BELL_SHAPE, Block.box(0.0, 13.0, 7.0, 16.0, 15.0, 9.0));
    private static final VoxelShape TO_WEST = VoxelShapes.or(BELL_SHAPE, Block.box(0.0, 13.0, 7.0, 13.0, 15.0, 9.0));
    private static final VoxelShape TO_EAST = VoxelShapes.or(BELL_SHAPE, Block.box(3.0, 13.0, 7.0, 16.0, 15.0, 9.0));
    private static final VoxelShape TO_NORTH = VoxelShapes.or(BELL_SHAPE, Block.box(7.0, 13.0, 0.0, 9.0, 15.0, 13.0));
    private static final VoxelShape TO_SOUTH = VoxelShapes.or(BELL_SHAPE, Block.box(7.0, 13.0, 3.0, 9.0, 15.0, 16.0));
    private static final VoxelShape CEILING_SHAPE = VoxelShapes.or(BELL_SHAPE, Block.box(7.0, 13.0, 7.0, 9.0, 16.0, 9.0));
    public static final int EVENT_BELL_RING = 1;

    public MapCodec<BlockBell> codec() {
        return CODEC;
    }

    public BlockBell(BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(FACING, EnumDirection.NORTH)).setValue(ATTACHMENT, BlockPropertyBellAttach.FLOOR)).setValue(POWERED, false));
    }

    @Override
    protected void neighborChanged(IBlockData iblockdata, World world, BlockPosition blockposition, Block block, BlockPosition blockposition1, boolean flag) {
        boolean flag1 = world.hasNeighborSignal(blockposition);
        if (flag1 != iblockdata.getValue(POWERED)) {
            if (flag1) {
                this.attemptToRing(world, blockposition, null);
            }
            world.setBlock(blockposition, (IBlockData)iblockdata.setValue(POWERED, flag1), 3);
        }
    }

    @Override
    protected void onProjectileHit(World world, IBlockData iblockdata, MovingObjectPositionBlock movingobjectpositionblock, IProjectile iprojectile) {
        Entity entity = iprojectile.getOwner();
        EntityHuman entityhuman = entity instanceof EntityHuman ? (EntityHuman)entity : null;
        this.onHit(world, iblockdata, movingobjectpositionblock, entityhuman, true);
    }

    @Override
    protected EnumInteractionResult useWithoutItem(IBlockData iblockdata, World world, BlockPosition blockposition, EntityHuman entityhuman, MovingObjectPositionBlock movingobjectpositionblock) {
        return this.onHit(world, iblockdata, movingobjectpositionblock, entityhuman, true) ? EnumInteractionResult.sidedSuccess(world.isClientSide) : EnumInteractionResult.PASS;
    }

    public boolean onHit(World world, IBlockData iblockdata, MovingObjectPositionBlock movingobjectpositionblock, @Nullable EntityHuman entityhuman, boolean flag) {
        boolean flag1;
        EnumDirection enumdirection = movingobjectpositionblock.getDirection();
        BlockPosition blockposition = movingobjectpositionblock.getBlockPos();
        boolean bl = flag1 = !flag || this.isProperHit(iblockdata, enumdirection, movingobjectpositionblock.getLocation().y - (double)blockposition.getY());
        if (flag1) {
            boolean flag2 = this.attemptToRing(entityhuman, world, blockposition, enumdirection);
            if (flag2 && entityhuman != null) {
                entityhuman.awardStat(StatisticList.BELL_RING);
            }
            return true;
        }
        return false;
    }

    private boolean isProperHit(IBlockData iblockdata, EnumDirection enumdirection, double d0) {
        if (enumdirection.getAxis() != EnumDirection.EnumAxis.Y && d0 <= (double)0.8124f) {
            EnumDirection enumdirection1 = iblockdata.getValue(FACING);
            BlockPropertyBellAttach blockpropertybellattach = iblockdata.getValue(ATTACHMENT);
            switch (blockpropertybellattach) {
                case FLOOR: {
                    return enumdirection1.getAxis() == enumdirection.getAxis();
                }
                case SINGLE_WALL: 
                case DOUBLE_WALL: {
                    return enumdirection1.getAxis() != enumdirection.getAxis();
                }
                case CEILING: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public boolean attemptToRing(World world, BlockPosition blockposition, @Nullable EnumDirection enumdirection) {
        return this.attemptToRing(null, world, blockposition, enumdirection);
    }

    public boolean attemptToRing(@Nullable Entity entity, World world, BlockPosition blockposition, @Nullable EnumDirection enumdirection) {
        TileEntity tileentity = world.getBlockEntity(blockposition);
        if (!world.isClientSide && tileentity instanceof TileEntityBell) {
            if (enumdirection == null) {
                enumdirection = world.getBlockState(blockposition).getValue(FACING);
            }
            if (!CraftEventFactory.handleBellRingEvent(world, blockposition, enumdirection, entity)) {
                return false;
            }
            ((TileEntityBell)tileentity).onHit(enumdirection);
            world.playSound((EntityHuman)null, blockposition, SoundEffects.BELL_BLOCK, SoundCategory.BLOCKS, 2.0f, 1.0f);
            world.gameEvent(entity, GameEvent.BLOCK_CHANGE, blockposition);
            return true;
        }
        return false;
    }

    private VoxelShape getVoxelShape(IBlockData iblockdata) {
        EnumDirection enumdirection = iblockdata.getValue(FACING);
        BlockPropertyBellAttach blockpropertybellattach = iblockdata.getValue(ATTACHMENT);
        return blockpropertybellattach == BlockPropertyBellAttach.FLOOR ? (enumdirection != EnumDirection.NORTH && enumdirection != EnumDirection.SOUTH ? EAST_WEST_FLOOR_SHAPE : NORTH_SOUTH_FLOOR_SHAPE) : (blockpropertybellattach == BlockPropertyBellAttach.CEILING ? CEILING_SHAPE : (blockpropertybellattach == BlockPropertyBellAttach.DOUBLE_WALL ? (enumdirection != EnumDirection.NORTH && enumdirection != EnumDirection.SOUTH ? EAST_WEST_BETWEEN : NORTH_SOUTH_BETWEEN) : (enumdirection == EnumDirection.NORTH ? TO_NORTH : (enumdirection == EnumDirection.SOUTH ? TO_SOUTH : (enumdirection == EnumDirection.EAST ? TO_EAST : TO_WEST)))));
    }

    @Override
    protected VoxelShape getCollisionShape(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return this.getVoxelShape(iblockdata);
    }

    @Override
    protected VoxelShape getShape(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return this.getVoxelShape(iblockdata);
    }

    @Override
    protected EnumRenderType getRenderShape(IBlockData iblockdata) {
        return EnumRenderType.MODEL;
    }

    @Override
    @Nullable
    public IBlockData getStateForPlacement(BlockActionContext blockactioncontext) {
        EnumDirection enumdirection = blockactioncontext.getClickedFace();
        BlockPosition blockposition = blockactioncontext.getClickedPos();
        World world = blockactioncontext.getLevel();
        EnumDirection.EnumAxis enumdirection_enumaxis = enumdirection.getAxis();
        if (enumdirection_enumaxis == EnumDirection.EnumAxis.Y) {
            IBlockData iblockdata = (IBlockData)((IBlockData)this.defaultBlockState().setValue(ATTACHMENT, enumdirection == EnumDirection.DOWN ? BlockPropertyBellAttach.CEILING : BlockPropertyBellAttach.FLOOR)).setValue(FACING, blockactioncontext.getHorizontalDirection());
            if (iblockdata.canSurvive(blockactioncontext.getLevel(), blockposition)) {
                return iblockdata;
            }
        } else {
            boolean flag = enumdirection_enumaxis == EnumDirection.EnumAxis.X && world.getBlockState(blockposition.west()).isFaceSturdy(world, blockposition.west(), EnumDirection.EAST) && world.getBlockState(blockposition.east()).isFaceSturdy(world, blockposition.east(), EnumDirection.WEST) || enumdirection_enumaxis == EnumDirection.EnumAxis.Z && world.getBlockState(blockposition.north()).isFaceSturdy(world, blockposition.north(), EnumDirection.SOUTH) && world.getBlockState(blockposition.south()).isFaceSturdy(world, blockposition.south(), EnumDirection.NORTH);
            IBlockData iblockdata = (IBlockData)((IBlockData)this.defaultBlockState().setValue(FACING, enumdirection.getOpposite())).setValue(ATTACHMENT, flag ? BlockPropertyBellAttach.DOUBLE_WALL : BlockPropertyBellAttach.SINGLE_WALL);
            if (iblockdata.canSurvive(blockactioncontext.getLevel(), blockactioncontext.getClickedPos())) {
                return iblockdata;
            }
            boolean flag1 = world.getBlockState(blockposition.below()).isFaceSturdy(world, blockposition.below(), EnumDirection.UP);
            if ((iblockdata = (IBlockData)iblockdata.setValue(ATTACHMENT, flag1 ? BlockPropertyBellAttach.FLOOR : BlockPropertyBellAttach.CEILING)).canSurvive(blockactioncontext.getLevel(), blockactioncontext.getClickedPos())) {
                return iblockdata;
            }
        }
        return null;
    }

    @Override
    protected void onExplosionHit(IBlockData iblockdata, World world, BlockPosition blockposition, Explosion explosion, BiConsumer<ItemStack, BlockPosition> biconsumer) {
        if (explosion.canTriggerBlocks()) {
            this.attemptToRing(world, blockposition, null);
        }
        super.onExplosionHit(iblockdata, world, blockposition, explosion, biconsumer);
    }

    @Override
    protected IBlockData updateShape(IBlockData iblockdata, EnumDirection enumdirection, IBlockData iblockdata1, GeneratorAccess generatoraccess, BlockPosition blockposition, BlockPosition blockposition1) {
        BlockPropertyBellAttach blockpropertybellattach = iblockdata.getValue(ATTACHMENT);
        EnumDirection enumdirection1 = BlockBell.getConnectedDirection(iblockdata).getOpposite();
        if (enumdirection1 == enumdirection && !iblockdata.canSurvive(generatoraccess, blockposition) && blockpropertybellattach != BlockPropertyBellAttach.DOUBLE_WALL) {
            return Blocks.AIR.defaultBlockState();
        }
        if (enumdirection.getAxis() == iblockdata.getValue(FACING).getAxis()) {
            if (blockpropertybellattach == BlockPropertyBellAttach.DOUBLE_WALL && !iblockdata1.isFaceSturdy(generatoraccess, blockposition1, enumdirection)) {
                return (IBlockData)((IBlockData)iblockdata.setValue(ATTACHMENT, BlockPropertyBellAttach.SINGLE_WALL)).setValue(FACING, enumdirection.getOpposite());
            }
            if (blockpropertybellattach == BlockPropertyBellAttach.SINGLE_WALL && enumdirection1.getOpposite() == enumdirection && iblockdata1.isFaceSturdy(generatoraccess, blockposition1, iblockdata.getValue(FACING))) {
                return (IBlockData)iblockdata.setValue(ATTACHMENT, BlockPropertyBellAttach.DOUBLE_WALL);
            }
        }
        return super.updateShape(iblockdata, enumdirection, iblockdata1, generatoraccess, blockposition, blockposition1);
    }

    @Override
    protected boolean canSurvive(IBlockData iblockdata, IWorldReader iworldreader, BlockPosition blockposition) {
        EnumDirection enumdirection = BlockBell.getConnectedDirection(iblockdata).getOpposite();
        return enumdirection == EnumDirection.UP ? Block.canSupportCenter(iworldreader, blockposition.above(), EnumDirection.DOWN) : BlockAttachable.canAttach(iworldreader, blockposition, enumdirection);
    }

    private static EnumDirection getConnectedDirection(IBlockData iblockdata) {
        switch (iblockdata.getValue(ATTACHMENT)) {
            case FLOOR: {
                return EnumDirection.UP;
            }
            case CEILING: {
                return EnumDirection.DOWN;
            }
        }
        return iblockdata.getValue(FACING).getOpposite();
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.add(FACING, ATTACHMENT, POWERED);
    }

    @Override
    @Nullable
    public TileEntity newBlockEntity(BlockPosition blockposition, IBlockData iblockdata) {
        return new TileEntityBell(blockposition, iblockdata);
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> getTicker(World world, IBlockData iblockdata, TileEntityTypes<T> tileentitytypes) {
        return BlockBell.createTickerHelper(tileentitytypes, TileEntityTypes.BELL, world.isClientSide ? TileEntityBell::clientTick : TileEntityBell::serverTick);
    }

    @Override
    protected boolean isPathfindable(IBlockData iblockdata, PathMode pathmode) {
        return false;
    }

    @Override
    public IBlockData rotate(IBlockData iblockdata, EnumBlockRotation enumblockrotation) {
        return (IBlockData)iblockdata.setValue(FACING, enumblockrotation.rotate(iblockdata.getValue(FACING)));
    }

    @Override
    public IBlockData mirror(IBlockData iblockdata, EnumBlockMirror enumblockmirror) {
        return iblockdata.rotate(enumblockmirror.getRotation(iblockdata.getValue(FACING)));
    }
}

