/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.Iterator;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;

public class BlockCactus
extends Block {
    public static final MapCodec<BlockCactus> CODEC = BlockCactus.simpleCodec(BlockCactus::new);
    public static final BlockStateInteger AGE = BlockProperties.AGE_15;
    public static final int MAX_AGE = 15;
    protected static final int AABB_OFFSET = 1;
    protected static final VoxelShape COLLISION_SHAPE = Block.box(1.0, 0.0, 1.0, 15.0, 15.0, 15.0);
    protected static final VoxelShape OUTLINE_SHAPE = Block.box(1.0, 0.0, 1.0, 15.0, 16.0, 15.0);

    public MapCodec<BlockCactus> codec() {
        return CODEC;
    }

    protected BlockCactus(BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(AGE, 0));
    }

    @Override
    protected void tick(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        if (!iblockdata.canSurvive(worldserver, blockposition)) {
            worldserver.destroyBlock(blockposition, true);
        }
    }

    @Override
    protected void randomTick(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        BlockPosition blockposition1 = blockposition.above();
        if (worldserver.isEmptyBlock(blockposition1)) {
            int i2 = 1;
            while (worldserver.getBlockState(blockposition.below(i2)).is(this)) {
                ++i2;
            }
            if (i2 < 3) {
                int j2 = iblockdata.getValue(AGE);
                int modifier = worldserver.spigotConfig.cactusModifier;
                if (j2 >= 15 || modifier != 100 && randomsource.nextFloat() < (float)modifier / 1600.0f) {
                    CraftEventFactory.handleBlockGrowEvent(worldserver, blockposition1, this.defaultBlockState());
                    IBlockData iblockdata1 = (IBlockData)iblockdata.setValue(AGE, 0);
                    worldserver.setBlock(blockposition, iblockdata1, 4);
                    worldserver.neighborChanged(iblockdata1, blockposition1, this, blockposition, false);
                } else if (modifier == 100 || randomsource.nextFloat() < (float)modifier / 1600.0f) {
                    worldserver.setBlock(blockposition, (IBlockData)iblockdata.setValue(AGE, j2 + 1), 4);
                }
            }
        }
    }

    @Override
    protected VoxelShape getCollisionShape(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return COLLISION_SHAPE;
    }

    @Override
    protected VoxelShape getShape(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return OUTLINE_SHAPE;
    }

    @Override
    protected IBlockData updateShape(IBlockData iblockdata, EnumDirection enumdirection, IBlockData iblockdata1, GeneratorAccess generatoraccess, BlockPosition blockposition, BlockPosition blockposition1) {
        if (!iblockdata.canSurvive(generatoraccess, blockposition)) {
            generatoraccess.scheduleTick(blockposition, this, 1);
        }
        return super.updateShape(iblockdata, enumdirection, iblockdata1, generatoraccess, blockposition, blockposition1);
    }

    @Override
    protected boolean canSurvive(IBlockData iblockdata, IWorldReader iworldreader, BlockPosition blockposition) {
        EnumDirection enumdirection;
        IBlockData iblockdata1;
        Iterator<EnumDirection> iterator = EnumDirection.EnumDirectionLimit.HORIZONTAL.iterator();
        do {
            if (iterator.hasNext()) continue;
            IBlockData iblockdata2 = iworldreader.getBlockState(blockposition.below());
            return (iblockdata2.is(Blocks.CACTUS) || iblockdata2.is(TagsBlock.SAND)) && !iworldreader.getBlockState(blockposition.above()).liquid();
        } while (!(iblockdata1 = iworldreader.getBlockState(blockposition.relative(enumdirection = iterator.next()))).isSolid() && !iworldreader.getFluidState(blockposition.relative(enumdirection)).is(TagsFluid.LAVA));
        return false;
    }

    @Override
    protected void entityInside(IBlockData iblockdata, World world, BlockPosition blockposition, Entity entity) {
        entity.hurt(world.damageSources().cactus().directBlock(world, blockposition), 1.0f);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.add(AGE);
    }

    @Override
    protected boolean isPathfindable(IBlockData iblockdata, PathMode pathmode) {
        return false;
    }
}

