/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.Particles;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.item.crafting.RecipeCampfire;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityCampfire;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateDirection;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;

public class BlockCampfire
extends BlockTileEntity
implements IBlockWaterlogged {
    public static final MapCodec<BlockCampfire> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.fieldOf("spawn_particles").forGetter(blockcampfire -> blockcampfire.spawnParticles), (App)Codec.intRange((int)0, (int)1000).fieldOf("fire_damage").forGetter(blockcampfire -> blockcampfire.fireDamage), BlockCampfire.propertiesCodec()).apply((Applicative)instance, BlockCampfire::new));
    protected static final VoxelShape SHAPE = Block.box(0.0, 0.0, 0.0, 16.0, 7.0, 16.0);
    public static final BlockStateBoolean LIT = BlockProperties.LIT;
    public static final BlockStateBoolean SIGNAL_FIRE = BlockProperties.SIGNAL_FIRE;
    public static final BlockStateBoolean WATERLOGGED = BlockProperties.WATERLOGGED;
    public static final BlockStateDirection FACING = BlockProperties.HORIZONTAL_FACING;
    private static final VoxelShape VIRTUAL_FENCE_POST = Block.box(6.0, 0.0, 6.0, 10.0, 16.0, 10.0);
    private static final int SMOKE_DISTANCE = 5;
    private final boolean spawnParticles;
    private final int fireDamage;

    public MapCodec<BlockCampfire> codec() {
        return CODEC;
    }

    public BlockCampfire(boolean flag, int i2, BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.spawnParticles = flag;
        this.fireDamage = i2;
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(LIT, true)).setValue(SIGNAL_FIRE, false)).setValue(WATERLOGGED, false)).setValue(FACING, EnumDirection.NORTH));
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack itemstack, IBlockData iblockdata, World world, BlockPosition blockposition, EntityHuman entityhuman, EnumHand enumhand, MovingObjectPositionBlock movingobjectpositionblock) {
        ItemStack itemstack1;
        TileEntityCampfire tileentitycampfire;
        Optional<RecipeHolder<RecipeCampfire>> optional;
        TileEntity tileentity = world.getBlockEntity(blockposition);
        if (tileentity instanceof TileEntityCampfire && (optional = (tileentitycampfire = (TileEntityCampfire)tileentity).getCookableRecipe(itemstack1 = entityhuman.getItemInHand(enumhand))).isPresent()) {
            if (!world.isClientSide && tileentitycampfire.placeFood(entityhuman, itemstack1, optional.get().value().getCookingTime())) {
                entityhuman.awardStat(StatisticList.INTERACT_WITH_CAMPFIRE);
                return ItemInteractionResult.SUCCESS;
            }
            return ItemInteractionResult.CONSUME;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Override
    protected void entityInside(IBlockData iblockdata, World world, BlockPosition blockposition, Entity entity) {
        if (iblockdata.getValue(LIT).booleanValue() && entity instanceof EntityLiving) {
            entity.hurt(world.damageSources().campfire().directBlock(world, blockposition), this.fireDamage);
        }
        super.entityInside(iblockdata, world, blockposition, entity);
    }

    @Override
    protected void onRemove(IBlockData iblockdata, World world, BlockPosition blockposition, IBlockData iblockdata1, boolean flag) {
        if (!iblockdata.is(iblockdata1.getBlock())) {
            TileEntity tileentity = world.getBlockEntity(blockposition);
            if (tileentity instanceof TileEntityCampfire) {
                InventoryUtils.dropContents(world, blockposition, ((TileEntityCampfire)tileentity).getItems());
            }
            super.onRemove(iblockdata, world, blockposition, iblockdata1, flag);
        }
    }

    @Override
    @Nullable
    public IBlockData getStateForPlacement(BlockActionContext blockactioncontext) {
        BlockPosition blockposition;
        World world = blockactioncontext.getLevel();
        boolean flag = world.getFluidState(blockposition = blockactioncontext.getClickedPos()).getType() == FluidTypes.WATER;
        return (IBlockData)((IBlockData)((IBlockData)((IBlockData)this.defaultBlockState().setValue(WATERLOGGED, flag)).setValue(SIGNAL_FIRE, this.isSmokeSource(world.getBlockState(blockposition.below())))).setValue(LIT, !flag)).setValue(FACING, blockactioncontext.getHorizontalDirection());
    }

    @Override
    protected IBlockData updateShape(IBlockData iblockdata, EnumDirection enumdirection, IBlockData iblockdata1, GeneratorAccess generatoraccess, BlockPosition blockposition, BlockPosition blockposition1) {
        if (iblockdata.getValue(WATERLOGGED).booleanValue()) {
            generatoraccess.scheduleTick(blockposition, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(generatoraccess));
        }
        return enumdirection == EnumDirection.DOWN ? (IBlockData)iblockdata.setValue(SIGNAL_FIRE, this.isSmokeSource(iblockdata1)) : super.updateShape(iblockdata, enumdirection, iblockdata1, generatoraccess, blockposition, blockposition1);
    }

    private boolean isSmokeSource(IBlockData iblockdata) {
        return iblockdata.is(Blocks.HAY_BLOCK);
    }

    @Override
    protected VoxelShape getShape(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return SHAPE;
    }

    @Override
    protected EnumRenderType getRenderShape(IBlockData iblockdata) {
        return EnumRenderType.MODEL;
    }

    @Override
    public void animateTick(IBlockData iblockdata, World world, BlockPosition blockposition, RandomSource randomsource) {
        if (iblockdata.getValue(LIT).booleanValue()) {
            if (randomsource.nextInt(10) == 0) {
                world.playLocalSound((double)blockposition.getX() + 0.5, (double)blockposition.getY() + 0.5, (double)blockposition.getZ() + 0.5, SoundEffects.CAMPFIRE_CRACKLE, SoundCategory.BLOCKS, 0.5f + randomsource.nextFloat(), randomsource.nextFloat() * 0.7f + 0.6f, false);
            }
            if (this.spawnParticles && randomsource.nextInt(5) == 0) {
                for (int i2 = 0; i2 < randomsource.nextInt(1) + 1; ++i2) {
                    world.addParticle(Particles.LAVA, (double)blockposition.getX() + 0.5, (double)blockposition.getY() + 0.5, (double)blockposition.getZ() + 0.5, randomsource.nextFloat() / 2.0f, 5.0E-5, randomsource.nextFloat() / 2.0f);
                }
            }
        }
    }

    public static void dowse(@Nullable Entity entity, GeneratorAccess generatoraccess, BlockPosition blockposition, IBlockData iblockdata) {
        TileEntity tileentity;
        if (generatoraccess.isClientSide()) {
            for (int i2 = 0; i2 < 20; ++i2) {
                BlockCampfire.makeParticles((World)generatoraccess, blockposition, iblockdata.getValue(SIGNAL_FIRE), true);
            }
        }
        if ((tileentity = generatoraccess.getBlockEntity(blockposition)) instanceof TileEntityCampfire) {
            ((TileEntityCampfire)tileentity).dowse();
        }
        generatoraccess.gameEvent(entity, GameEvent.BLOCK_CHANGE, blockposition);
    }

    @Override
    public boolean placeLiquid(GeneratorAccess generatoraccess, BlockPosition blockposition, IBlockData iblockdata, Fluid fluid) {
        if (!iblockdata.getValue(BlockProperties.WATERLOGGED).booleanValue() && fluid.getType() == FluidTypes.WATER) {
            boolean flag = iblockdata.getValue(LIT);
            if (flag) {
                if (!generatoraccess.isClientSide()) {
                    generatoraccess.playSound(null, blockposition, SoundEffects.GENERIC_EXTINGUISH_FIRE, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                BlockCampfire.dowse(null, generatoraccess, blockposition, iblockdata);
            }
            generatoraccess.setBlock(blockposition, (IBlockData)((IBlockData)iblockdata.setValue(WATERLOGGED, true)).setValue(LIT, false), 3);
            generatoraccess.scheduleTick(blockposition, fluid.getType(), fluid.getType().getTickDelay(generatoraccess));
            return true;
        }
        return false;
    }

    @Override
    protected void onProjectileHit(World world, IBlockData iblockdata, MovingObjectPositionBlock movingobjectpositionblock, IProjectile iprojectile) {
        BlockPosition blockposition = movingobjectpositionblock.getBlockPos();
        if (!world.isClientSide && iprojectile.isOnFire() && iprojectile.mayInteract(world, blockposition) && !iblockdata.getValue(LIT).booleanValue() && !iblockdata.getValue(WATERLOGGED).booleanValue()) {
            if (CraftEventFactory.callBlockIgniteEvent(world, blockposition, iprojectile).isCancelled()) {
                return;
            }
            world.setBlock(blockposition, (IBlockData)iblockdata.setValue(BlockProperties.LIT, true), 11);
        }
    }

    public static void makeParticles(World world, BlockPosition blockposition, boolean flag, boolean flag1) {
        RandomSource randomsource = world.getRandom();
        ParticleType particletype = flag ? Particles.CAMPFIRE_SIGNAL_SMOKE : Particles.CAMPFIRE_COSY_SMOKE;
        world.addAlwaysVisibleParticle(particletype, true, (double)blockposition.getX() + 0.5 + randomsource.nextDouble() / 3.0 * (double)(randomsource.nextBoolean() ? 1 : -1), (double)blockposition.getY() + randomsource.nextDouble() + randomsource.nextDouble(), (double)blockposition.getZ() + 0.5 + randomsource.nextDouble() / 3.0 * (double)(randomsource.nextBoolean() ? 1 : -1), 0.0, 0.07, 0.0);
        if (flag1) {
            world.addParticle(Particles.SMOKE, (double)blockposition.getX() + 0.5 + randomsource.nextDouble() / 4.0 * (double)(randomsource.nextBoolean() ? 1 : -1), (double)blockposition.getY() + 0.4, (double)blockposition.getZ() + 0.5 + randomsource.nextDouble() / 4.0 * (double)(randomsource.nextBoolean() ? 1 : -1), 0.0, 0.005, 0.0);
        }
    }

    public static boolean isSmokeyPos(World world, BlockPosition blockposition) {
        for (int i2 = 1; i2 <= 5; ++i2) {
            BlockPosition blockposition1 = blockposition.below(i2);
            IBlockData iblockdata = world.getBlockState(blockposition1);
            if (BlockCampfire.isLitCampfire(iblockdata)) {
                return true;
            }
            boolean flag = VoxelShapes.joinIsNotEmpty(VIRTUAL_FENCE_POST, iblockdata.getCollisionShape(world, blockposition, VoxelShapeCollision.empty()), OperatorBoolean.AND);
            if (!flag) continue;
            IBlockData iblockdata1 = world.getBlockState(blockposition1.below());
            return BlockCampfire.isLitCampfire(iblockdata1);
        }
        return false;
    }

    public static boolean isLitCampfire(IBlockData iblockdata) {
        return iblockdata.hasProperty(LIT) && iblockdata.is(TagsBlock.CAMPFIRES) && iblockdata.getValue(LIT) != false;
    }

    @Override
    protected Fluid getFluidState(IBlockData iblockdata) {
        return iblockdata.getValue(WATERLOGGED) != false ? FluidTypes.WATER.getSource(false) : super.getFluidState(iblockdata);
    }

    @Override
    protected IBlockData rotate(IBlockData iblockdata, EnumBlockRotation enumblockrotation) {
        return (IBlockData)iblockdata.setValue(FACING, enumblockrotation.rotate(iblockdata.getValue(FACING)));
    }

    @Override
    protected IBlockData mirror(IBlockData iblockdata, EnumBlockMirror enumblockmirror) {
        return iblockdata.rotate(enumblockmirror.getRotation(iblockdata.getValue(FACING)));
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.add(LIT, SIGNAL_FIRE, WATERLOGGED, FACING);
    }

    @Override
    public TileEntity newBlockEntity(BlockPosition blockposition, IBlockData iblockdata) {
        return new TileEntityCampfire(blockposition, iblockdata);
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> getTicker(World world, IBlockData iblockdata, TileEntityTypes<T> tileentitytypes) {
        return world.isClientSide ? (iblockdata.getValue(LIT).booleanValue() ? BlockCampfire.createTickerHelper(tileentitytypes, TileEntityTypes.CAMPFIRE, TileEntityCampfire::particleTick) : null) : (iblockdata.getValue(LIT) != false ? BlockCampfire.createTickerHelper(tileentitytypes, TileEntityTypes.CAMPFIRE, TileEntityCampfire::cookTick) : BlockCampfire.createTickerHelper(tileentitytypes, TileEntityTypes.CAMPFIRE, TileEntityCampfire::cooldownTick));
    }

    @Override
    protected boolean isPathfindable(IBlockData iblockdata, PathMode pathmode) {
        return false;
    }

    public static boolean canLight(IBlockData iblockdata) {
        return iblockdata.is(TagsBlock.CAMPFIRES, blockbase_blockdata -> blockbase_blockdata.hasProperty(WATERLOGGED) && blockbase_blockdata.hasProperty(LIT)) && iblockdata.getValue(WATERLOGGED) == false && iblockdata.getValue(LIT) == false;
    }
}

