/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.TileInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerCartography;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.MovingObjectPositionBlock;

public class BlockCartographyTable
extends Block {
    public static final MapCodec<BlockCartographyTable> CODEC = BlockCartographyTable.simpleCodec(BlockCartographyTable::new);
    private static final IChatBaseComponent CONTAINER_TITLE = IChatBaseComponent.translatable("container.cartography_table");

    public MapCodec<BlockCartographyTable> codec() {
        return CODEC;
    }

    protected BlockCartographyTable(BlockBase.Info var0) {
        super(var0);
    }

    @Override
    protected EnumInteractionResult useWithoutItem(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, MovingObjectPositionBlock var4) {
        if (var1.isClientSide) {
            return EnumInteractionResult.SUCCESS;
        }
        var3.openMenu(var0.getMenuProvider(var1, var2));
        var3.awardStat(StatisticList.INTERACT_WITH_CARTOGRAPHY_TABLE);
        return EnumInteractionResult.CONSUME;
    }

    @Override
    @Nullable
    protected ITileInventory getMenuProvider(IBlockData var0, World var1, BlockPosition var22) {
        return new TileInventory((var2, var3, var4) -> new ContainerCartography(var2, var3, ContainerAccess.create(var1, var22)), CONTAINER_TITLE);
    }
}

