/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import org.bukkit.event.block.CauldronLevelChangeEvent;

public class BlockCauldron
extends AbstractCauldronBlock {
    public static final MapCodec<BlockCauldron> CODEC = BlockCauldron.simpleCodec(BlockCauldron::new);
    private static final float RAIN_FILL_CHANCE = 0.05f;
    private static final float POWDER_SNOW_FILL_CHANCE = 0.1f;

    public MapCodec<BlockCauldron> codec() {
        return CODEC;
    }

    public BlockCauldron(BlockBase.Info blockbase_info) {
        super(blockbase_info, CauldronInteraction.EMPTY);
    }

    @Override
    public boolean isFull(IBlockData iblockdata) {
        return false;
    }

    protected static boolean shouldHandlePrecipitation(World world, BiomeBase.Precipitation biomebase_precipitation) {
        return biomebase_precipitation == BiomeBase.Precipitation.RAIN ? world.getRandom().nextFloat() < 0.05f : (biomebase_precipitation == BiomeBase.Precipitation.SNOW ? world.getRandom().nextFloat() < 0.1f : false);
    }

    @Override
    public void handlePrecipitation(IBlockData iblockdata, World world, BlockPosition blockposition, BiomeBase.Precipitation biomebase_precipitation) {
        if (BlockCauldron.shouldHandlePrecipitation(world, biomebase_precipitation)) {
            if (biomebase_precipitation == BiomeBase.Precipitation.RAIN) {
                world.setBlockAndUpdate(blockposition, Blocks.WATER_CAULDRON.defaultBlockState());
                world.gameEvent((Entity)null, GameEvent.BLOCK_CHANGE, blockposition);
            } else if (biomebase_precipitation == BiomeBase.Precipitation.SNOW) {
                world.setBlockAndUpdate(blockposition, Blocks.POWDER_SNOW_CAULDRON.defaultBlockState());
                world.gameEvent((Entity)null, GameEvent.BLOCK_CHANGE, blockposition);
            }
        }
    }

    @Override
    protected boolean canReceiveStalactiteDrip(FluidType fluidtype) {
        return true;
    }

    @Override
    protected void receiveStalactiteDrip(IBlockData iblockdata, World world, BlockPosition blockposition, FluidType fluidtype) {
        if (fluidtype == FluidTypes.WATER) {
            IBlockData iblockdata1 = Blocks.WATER_CAULDRON.defaultBlockState();
            LayeredCauldronBlock.changeLevel(iblockdata, world, blockposition, iblockdata1, null, CauldronLevelChangeEvent.ChangeReason.NATURAL_FILL);
            world.levelEvent(1047, blockposition, 0);
        } else if (fluidtype == FluidTypes.LAVA) {
            IBlockData iblockdata1 = Blocks.LAVA_CAULDRON.defaultBlockState();
            LayeredCauldronBlock.changeLevel(iblockdata, world, blockposition, iblockdata1, null, CauldronLevelChangeEvent.ChangeReason.NATURAL_FILL);
            world.levelEvent(1046, blockposition, 0);
        }
    }
}

