/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockChorusFruit;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;

public class BlockChorusFlower
extends Block {
    public static final MapCodec<BlockChorusFlower> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("plant").forGetter(blockchorusflower -> blockchorusflower.plant), BlockChorusFlower.propertiesCodec()).apply((Applicative)instance, BlockChorusFlower::new));
    public static final int DEAD_AGE = 5;
    public static final BlockStateInteger AGE = BlockProperties.AGE_5;
    protected static final VoxelShape BLOCK_SUPPORT_SHAPE = Block.box(1.0, 0.0, 1.0, 15.0, 15.0, 15.0);
    private final Block plant;

    public MapCodec<BlockChorusFlower> codec() {
        return CODEC;
    }

    protected BlockChorusFlower(Block block, BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.plant = block;
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(AGE, 0));
    }

    @Override
    protected void tick(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        if (!iblockdata.canSurvive(worldserver, blockposition)) {
            worldserver.destroyBlock(blockposition, true);
        }
    }

    @Override
    protected boolean isRandomlyTicking(IBlockData iblockdata) {
        return iblockdata.getValue(AGE) < 5;
    }

    @Override
    public VoxelShape getBlockSupportShape(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition) {
        return BLOCK_SUPPORT_SHAPE;
    }

    @Override
    protected void randomTick(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        int i2;
        BlockPosition blockposition1 = blockposition.above();
        if (worldserver.isEmptyBlock(blockposition1) && blockposition1.getY() < worldserver.getMaxBuildHeight() && (i2 = iblockdata.getValue(AGE).intValue()) < 5) {
            int j2;
            boolean flag = false;
            boolean flag1 = false;
            IBlockData iblockdata1 = worldserver.getBlockState(blockposition.below());
            if (iblockdata1.is(Blocks.END_STONE)) {
                flag = true;
            } else if (iblockdata1.is(this.plant)) {
                j2 = 1;
                for (int k2 = 0; k2 < 4; ++k2) {
                    IBlockData iblockdata2 = worldserver.getBlockState(blockposition.below(j2 + 1));
                    if (!iblockdata2.is(this.plant)) {
                        if (!iblockdata2.is(Blocks.END_STONE)) break;
                        flag1 = true;
                        break;
                    }
                    ++j2;
                }
                if (j2 < 2 || j2 <= randomsource.nextInt(flag1 ? 5 : 4)) {
                    flag = true;
                }
            } else if (iblockdata1.isAir()) {
                flag = true;
            }
            if (flag && BlockChorusFlower.allNeighborsEmpty(worldserver, blockposition1, null) && worldserver.isEmptyBlock(blockposition.above(2))) {
                if (CraftEventFactory.handleBlockSpreadEvent(worldserver, blockposition, blockposition1, (IBlockData)this.defaultBlockState().setValue(AGE, i2), 2)) {
                    worldserver.setBlock(blockposition, BlockChorusFruit.getStateWithConnections(worldserver, blockposition, this.plant.defaultBlockState()), 2);
                    this.placeGrownFlower(worldserver, blockposition1, i2);
                }
            } else if (i2 < 4) {
                j2 = randomsource.nextInt(4);
                if (flag1) {
                    ++j2;
                }
                boolean flag2 = false;
                for (int l2 = 0; l2 < j2; ++l2) {
                    EnumDirection enumdirection = EnumDirection.EnumDirectionLimit.HORIZONTAL.getRandomDirection(randomsource);
                    BlockPosition blockposition2 = blockposition.relative(enumdirection);
                    if (!worldserver.isEmptyBlock(blockposition2) || !worldserver.isEmptyBlock(blockposition2.below()) || !BlockChorusFlower.allNeighborsEmpty(worldserver, blockposition2, enumdirection.getOpposite()) || !CraftEventFactory.handleBlockSpreadEvent(worldserver, blockposition, blockposition2, (IBlockData)this.defaultBlockState().setValue(AGE, i2 + 1), 2)) continue;
                    this.placeGrownFlower(worldserver, blockposition2, i2 + 1);
                    flag2 = true;
                }
                if (flag2) {
                    worldserver.setBlock(blockposition, BlockChorusFruit.getStateWithConnections(worldserver, blockposition, this.plant.defaultBlockState()), 2);
                } else if (CraftEventFactory.handleBlockGrowEvent(worldserver, blockposition, (IBlockData)this.defaultBlockState().setValue(AGE, 5), 2)) {
                    this.placeDeadFlower(worldserver, blockposition);
                }
            } else if (CraftEventFactory.handleBlockGrowEvent(worldserver, blockposition, (IBlockData)this.defaultBlockState().setValue(AGE, 5), 2)) {
                this.placeDeadFlower(worldserver, blockposition);
            }
        }
    }

    private void placeGrownFlower(World world, BlockPosition blockposition, int i2) {
        world.setBlock(blockposition, (IBlockData)this.defaultBlockState().setValue(AGE, i2), 2);
        world.levelEvent(1033, blockposition, 0);
    }

    private void placeDeadFlower(World world, BlockPosition blockposition) {
        world.setBlock(blockposition, (IBlockData)this.defaultBlockState().setValue(AGE, 5), 2);
        world.levelEvent(1034, blockposition, 0);
    }

    private static boolean allNeighborsEmpty(IWorldReader iworldreader, BlockPosition blockposition, @Nullable EnumDirection enumdirection) {
        EnumDirection enumdirection1;
        Iterator<EnumDirection> iterator = EnumDirection.EnumDirectionLimit.HORIZONTAL.iterator();
        do {
            if (iterator.hasNext()) continue;
            return true;
        } while ((enumdirection1 = iterator.next()) == enumdirection || iworldreader.isEmptyBlock(blockposition.relative(enumdirection1)));
        return false;
    }

    @Override
    protected IBlockData updateShape(IBlockData iblockdata, EnumDirection enumdirection, IBlockData iblockdata1, GeneratorAccess generatoraccess, BlockPosition blockposition, BlockPosition blockposition1) {
        if (enumdirection != EnumDirection.UP && !iblockdata.canSurvive(generatoraccess, blockposition)) {
            generatoraccess.scheduleTick(blockposition, this, 1);
        }
        return super.updateShape(iblockdata, enumdirection, iblockdata1, generatoraccess, blockposition, blockposition1);
    }

    @Override
    protected boolean canSurvive(IBlockData iblockdata, IWorldReader iworldreader, BlockPosition blockposition) {
        IBlockData iblockdata1 = iworldreader.getBlockState(blockposition.below());
        if (!iblockdata1.is(this.plant) && !iblockdata1.is(Blocks.END_STONE)) {
            if (!iblockdata1.isAir()) {
                return false;
            }
            boolean flag = false;
            for (EnumDirection enumdirection : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
                IBlockData iblockdata2 = iworldreader.getBlockState(blockposition.relative(enumdirection));
                if (iblockdata2.is(this.plant)) {
                    if (flag) {
                        return false;
                    }
                    flag = true;
                    continue;
                }
                if (iblockdata2.isAir()) continue;
                return false;
            }
            return flag;
        }
        return true;
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.add(AGE);
    }

    public static void generatePlant(GeneratorAccess generatoraccess, BlockPosition blockposition, RandomSource randomsource, int i2) {
        generatoraccess.setBlock(blockposition, BlockChorusFruit.getStateWithConnections(generatoraccess, blockposition, Blocks.CHORUS_PLANT.defaultBlockState()), 2);
        BlockChorusFlower.growTreeRecursive(generatoraccess, blockposition, randomsource, blockposition, i2, 0);
    }

    private static void growTreeRecursive(GeneratorAccess generatoraccess, BlockPosition blockposition, RandomSource randomsource, BlockPosition blockposition1, int i2, int j2) {
        Block block = Blocks.CHORUS_PLANT;
        int k2 = randomsource.nextInt(4) + 1;
        if (j2 == 0) {
            ++k2;
        }
        for (int l2 = 0; l2 < k2; ++l2) {
            BlockPosition blockposition2 = blockposition.above(l2 + 1);
            if (!BlockChorusFlower.allNeighborsEmpty(generatoraccess, blockposition2, null)) {
                return;
            }
            generatoraccess.setBlock(blockposition2, BlockChorusFruit.getStateWithConnections(generatoraccess, blockposition2, block.defaultBlockState()), 2);
            generatoraccess.setBlock(blockposition2.below(), BlockChorusFruit.getStateWithConnections(generatoraccess, blockposition2.below(), block.defaultBlockState()), 2);
        }
        boolean flag = false;
        if (j2 < 4) {
            int i1 = randomsource.nextInt(4);
            if (j2 == 0) {
                ++i1;
            }
            for (int j1 = 0; j1 < i1; ++j1) {
                EnumDirection enumdirection = EnumDirection.EnumDirectionLimit.HORIZONTAL.getRandomDirection(randomsource);
                BlockPosition blockposition3 = blockposition.above(k2).relative(enumdirection);
                if (Math.abs(blockposition3.getX() - blockposition1.getX()) >= i2 || Math.abs(blockposition3.getZ() - blockposition1.getZ()) >= i2 || !generatoraccess.isEmptyBlock(blockposition3) || !generatoraccess.isEmptyBlock(blockposition3.below()) || !BlockChorusFlower.allNeighborsEmpty(generatoraccess, blockposition3, enumdirection.getOpposite())) continue;
                flag = true;
                generatoraccess.setBlock(blockposition3, BlockChorusFruit.getStateWithConnections(generatoraccess, blockposition3, block.defaultBlockState()), 2);
                generatoraccess.setBlock(blockposition3.relative(enumdirection.getOpposite()), BlockChorusFruit.getStateWithConnections(generatoraccess, blockposition3.relative(enumdirection.getOpposite()), block.defaultBlockState()), 2);
                BlockChorusFlower.growTreeRecursive(generatoraccess, blockposition3, randomsource, blockposition1, i2, j2 + 1);
            }
        }
        if (!flag) {
            generatoraccess.setBlock(blockposition.above(k2), (IBlockData)Blocks.CHORUS_FLOWER.defaultBlockState().setValue(AGE, 5), 2);
        }
    }

    @Override
    protected void onProjectileHit(World world, IBlockData iblockdata, MovingObjectPositionBlock movingobjectpositionblock, IProjectile iprojectile) {
        BlockPosition blockposition = movingobjectpositionblock.getBlockPos();
        if (!world.isClientSide && iprojectile.mayInteract(world, blockposition) && iprojectile.mayBreak(world)) {
            if (!CraftEventFactory.callEntityChangeBlockEvent(iprojectile, blockposition, Blocks.AIR.defaultBlockState())) {
                return;
            }
            world.destroyBlock(blockposition, true, iprojectile);
        }
    }
}

