/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventoryHolder;
import net.minecraft.world.IWorldInventory;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftBlockInventoryHolder;
import org.bukkit.craftbukkit.v1_21_R1.util.DummyGeneratorAccess;

public class BlockComposter
extends Block
implements IInventoryHolder {
    public static final MapCodec<BlockComposter> CODEC = BlockComposter.simpleCodec(BlockComposter::new);
    public static final int READY = 8;
    public static final int MIN_LEVEL = 0;
    public static final int MAX_LEVEL = 7;
    public static final BlockStateInteger LEVEL = BlockProperties.LEVEL_COMPOSTER;
    public static final Object2FloatMap<IMaterial> COMPOSTABLES = new Object2FloatOpenHashMap();
    private static final int AABB_SIDE_THICKNESS = 2;
    private static final VoxelShape OUTER_SHAPE = VoxelShapes.block();
    private static final VoxelShape[] SHAPES = SystemUtils.make(new VoxelShape[9], avoxelshape -> {
        for (int i2 = 0; i2 < 8; ++i2) {
            avoxelshape[i2] = VoxelShapes.join(OUTER_SHAPE, Block.box(2.0, Math.max(2, 1 + i2 * 2), 2.0, 14.0, 16.0, 14.0), OperatorBoolean.ONLY_FIRST);
        }
        avoxelshape[8] = avoxelshape[7];
    });

    public MapCodec<BlockComposter> codec() {
        return CODEC;
    }

    public static void bootStrap() {
        COMPOSTABLES.defaultReturnValue(-1.0f);
        float f2 = 0.3f;
        float f1 = 0.5f;
        float f22 = 0.65f;
        float f3 = 0.85f;
        float f4 = 1.0f;
        BlockComposter.add(0.3f, Items.JUNGLE_LEAVES);
        BlockComposter.add(0.3f, Items.OAK_LEAVES);
        BlockComposter.add(0.3f, Items.SPRUCE_LEAVES);
        BlockComposter.add(0.3f, Items.DARK_OAK_LEAVES);
        BlockComposter.add(0.3f, Items.ACACIA_LEAVES);
        BlockComposter.add(0.3f, Items.CHERRY_LEAVES);
        BlockComposter.add(0.3f, Items.BIRCH_LEAVES);
        BlockComposter.add(0.3f, Items.AZALEA_LEAVES);
        BlockComposter.add(0.3f, Items.MANGROVE_LEAVES);
        BlockComposter.add(0.3f, Items.OAK_SAPLING);
        BlockComposter.add(0.3f, Items.SPRUCE_SAPLING);
        BlockComposter.add(0.3f, Items.BIRCH_SAPLING);
        BlockComposter.add(0.3f, Items.JUNGLE_SAPLING);
        BlockComposter.add(0.3f, Items.ACACIA_SAPLING);
        BlockComposter.add(0.3f, Items.CHERRY_SAPLING);
        BlockComposter.add(0.3f, Items.DARK_OAK_SAPLING);
        BlockComposter.add(0.3f, Items.MANGROVE_PROPAGULE);
        BlockComposter.add(0.3f, Items.BEETROOT_SEEDS);
        BlockComposter.add(0.3f, Items.DRIED_KELP);
        BlockComposter.add(0.3f, Items.SHORT_GRASS);
        BlockComposter.add(0.3f, Items.KELP);
        BlockComposter.add(0.3f, Items.MELON_SEEDS);
        BlockComposter.add(0.3f, Items.PUMPKIN_SEEDS);
        BlockComposter.add(0.3f, Items.SEAGRASS);
        BlockComposter.add(0.3f, Items.SWEET_BERRIES);
        BlockComposter.add(0.3f, Items.GLOW_BERRIES);
        BlockComposter.add(0.3f, Items.WHEAT_SEEDS);
        BlockComposter.add(0.3f, Items.MOSS_CARPET);
        BlockComposter.add(0.3f, Items.PINK_PETALS);
        BlockComposter.add(0.3f, Items.SMALL_DRIPLEAF);
        BlockComposter.add(0.3f, Items.HANGING_ROOTS);
        BlockComposter.add(0.3f, Items.MANGROVE_ROOTS);
        BlockComposter.add(0.3f, Items.TORCHFLOWER_SEEDS);
        BlockComposter.add(0.3f, Items.PITCHER_POD);
        BlockComposter.add(0.5f, Items.DRIED_KELP_BLOCK);
        BlockComposter.add(0.5f, Items.TALL_GRASS);
        BlockComposter.add(0.5f, Items.FLOWERING_AZALEA_LEAVES);
        BlockComposter.add(0.5f, Items.CACTUS);
        BlockComposter.add(0.5f, Items.SUGAR_CANE);
        BlockComposter.add(0.5f, Items.VINE);
        BlockComposter.add(0.5f, Items.NETHER_SPROUTS);
        BlockComposter.add(0.5f, Items.WEEPING_VINES);
        BlockComposter.add(0.5f, Items.TWISTING_VINES);
        BlockComposter.add(0.5f, Items.MELON_SLICE);
        BlockComposter.add(0.5f, Items.GLOW_LICHEN);
        BlockComposter.add(0.65f, Items.SEA_PICKLE);
        BlockComposter.add(0.65f, Items.LILY_PAD);
        BlockComposter.add(0.65f, Items.PUMPKIN);
        BlockComposter.add(0.65f, Items.CARVED_PUMPKIN);
        BlockComposter.add(0.65f, Items.MELON);
        BlockComposter.add(0.65f, Items.APPLE);
        BlockComposter.add(0.65f, Items.BEETROOT);
        BlockComposter.add(0.65f, Items.CARROT);
        BlockComposter.add(0.65f, Items.COCOA_BEANS);
        BlockComposter.add(0.65f, Items.POTATO);
        BlockComposter.add(0.65f, Items.WHEAT);
        BlockComposter.add(0.65f, Items.BROWN_MUSHROOM);
        BlockComposter.add(0.65f, Items.RED_MUSHROOM);
        BlockComposter.add(0.65f, Items.MUSHROOM_STEM);
        BlockComposter.add(0.65f, Items.CRIMSON_FUNGUS);
        BlockComposter.add(0.65f, Items.WARPED_FUNGUS);
        BlockComposter.add(0.65f, Items.NETHER_WART);
        BlockComposter.add(0.65f, Items.CRIMSON_ROOTS);
        BlockComposter.add(0.65f, Items.WARPED_ROOTS);
        BlockComposter.add(0.65f, Items.SHROOMLIGHT);
        BlockComposter.add(0.65f, Items.DANDELION);
        BlockComposter.add(0.65f, Items.POPPY);
        BlockComposter.add(0.65f, Items.BLUE_ORCHID);
        BlockComposter.add(0.65f, Items.ALLIUM);
        BlockComposter.add(0.65f, Items.AZURE_BLUET);
        BlockComposter.add(0.65f, Items.RED_TULIP);
        BlockComposter.add(0.65f, Items.ORANGE_TULIP);
        BlockComposter.add(0.65f, Items.WHITE_TULIP);
        BlockComposter.add(0.65f, Items.PINK_TULIP);
        BlockComposter.add(0.65f, Items.OXEYE_DAISY);
        BlockComposter.add(0.65f, Items.CORNFLOWER);
        BlockComposter.add(0.65f, Items.LILY_OF_THE_VALLEY);
        BlockComposter.add(0.65f, Items.WITHER_ROSE);
        BlockComposter.add(0.65f, Items.FERN);
        BlockComposter.add(0.65f, Items.SUNFLOWER);
        BlockComposter.add(0.65f, Items.LILAC);
        BlockComposter.add(0.65f, Items.ROSE_BUSH);
        BlockComposter.add(0.65f, Items.PEONY);
        BlockComposter.add(0.65f, Items.LARGE_FERN);
        BlockComposter.add(0.65f, Items.SPORE_BLOSSOM);
        BlockComposter.add(0.65f, Items.AZALEA);
        BlockComposter.add(0.65f, Items.MOSS_BLOCK);
        BlockComposter.add(0.65f, Items.BIG_DRIPLEAF);
        BlockComposter.add(0.85f, Items.HAY_BLOCK);
        BlockComposter.add(0.85f, Items.BROWN_MUSHROOM_BLOCK);
        BlockComposter.add(0.85f, Items.RED_MUSHROOM_BLOCK);
        BlockComposter.add(0.85f, Items.NETHER_WART_BLOCK);
        BlockComposter.add(0.85f, Items.WARPED_WART_BLOCK);
        BlockComposter.add(0.85f, Items.FLOWERING_AZALEA);
        BlockComposter.add(0.85f, Items.BREAD);
        BlockComposter.add(0.85f, Items.BAKED_POTATO);
        BlockComposter.add(0.85f, Items.COOKIE);
        BlockComposter.add(0.85f, Items.TORCHFLOWER);
        BlockComposter.add(0.85f, Items.PITCHER_PLANT);
        BlockComposter.add(1.0f, Items.CAKE);
        BlockComposter.add(1.0f, Items.PUMPKIN_PIE);
    }

    private static void add(float f2, IMaterial imaterial) {
        COMPOSTABLES.put((Object)imaterial.asItem(), f2);
    }

    public BlockComposter(BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(LEVEL, 0));
    }

    public static void handleFill(World world, BlockPosition blockposition, boolean flag) {
        IBlockData iblockdata = world.getBlockState(blockposition);
        world.playLocalSound(blockposition, flag ? SoundEffects.COMPOSTER_FILL_SUCCESS : SoundEffects.COMPOSTER_FILL, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
        double d0 = iblockdata.getShape(world, blockposition).max(EnumDirection.EnumAxis.Y, 0.5, 0.5) + 0.03125;
        double d1 = 0.13125f;
        double d2 = 0.7375f;
        RandomSource randomsource = world.getRandom();
        for (int i2 = 0; i2 < 10; ++i2) {
            double d3 = randomsource.nextGaussian() * 0.02;
            double d4 = randomsource.nextGaussian() * 0.02;
            double d5 = randomsource.nextGaussian() * 0.02;
            world.addParticle(Particles.COMPOSTER, (double)blockposition.getX() + (double)0.13125f + (double)0.7375f * (double)randomsource.nextFloat(), (double)blockposition.getY() + d0 + (double)randomsource.nextFloat() * (1.0 - d0), (double)blockposition.getZ() + (double)0.13125f + (double)0.7375f * (double)randomsource.nextFloat(), d3, d4, d5);
        }
    }

    @Override
    protected VoxelShape getShape(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return SHAPES[iblockdata.getValue(LEVEL)];
    }

    @Override
    protected VoxelShape getInteractionShape(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition) {
        return OUTER_SHAPE;
    }

    @Override
    protected VoxelShape getCollisionShape(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return SHAPES[0];
    }

    @Override
    protected void onPlace(IBlockData iblockdata, World world, BlockPosition blockposition, IBlockData iblockdata1, boolean flag) {
        if (iblockdata.getValue(LEVEL) == 7) {
            world.scheduleTick(blockposition, iblockdata.getBlock(), 20);
        }
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack itemstack, IBlockData iblockdata, World world, BlockPosition blockposition, EntityHuman entityhuman, EnumHand enumhand, MovingObjectPositionBlock movingobjectpositionblock) {
        int i2 = iblockdata.getValue(LEVEL);
        if (i2 < 8 && COMPOSTABLES.containsKey((Object)itemstack.getItem())) {
            if (i2 < 7 && !world.isClientSide) {
                IBlockData iblockdata1 = BlockComposter.addItem(entityhuman, iblockdata, world, blockposition, itemstack);
                world.levelEvent(1500, blockposition, iblockdata != iblockdata1 ? 1 : 0);
                entityhuman.awardStat(StatisticList.ITEM_USED.get(itemstack.getItem()));
                itemstack.consume(1, entityhuman);
            }
            return ItemInteractionResult.sidedSuccess(world.isClientSide);
        }
        return super.useItemOn(itemstack, iblockdata, world, blockposition, entityhuman, enumhand, movingobjectpositionblock);
    }

    @Override
    protected EnumInteractionResult useWithoutItem(IBlockData iblockdata, World world, BlockPosition blockposition, EntityHuman entityhuman, MovingObjectPositionBlock movingobjectpositionblock) {
        int i2 = iblockdata.getValue(LEVEL);
        if (i2 == 8) {
            BlockComposter.extractProduce(entityhuman, iblockdata, world, blockposition);
            return EnumInteractionResult.sidedSuccess(world.isClientSide);
        }
        return EnumInteractionResult.PASS;
    }

    public static IBlockData insertItem(Entity entity, IBlockData iblockdata, WorldServer worldserver, ItemStack itemstack, BlockPosition blockposition) {
        int i2 = iblockdata.getValue(LEVEL);
        if (i2 < 7 && COMPOSTABLES.containsKey((Object)itemstack.getItem())) {
            double rand = worldserver.getRandom().nextDouble();
            IBlockData iblockdata1 = BlockComposter.addItem(entity, iblockdata, DummyGeneratorAccess.INSTANCE, blockposition, itemstack, rand);
            if (iblockdata == iblockdata1 || !CraftEventFactory.callEntityChangeBlockEvent(entity, blockposition, iblockdata1)) {
                return iblockdata;
            }
            iblockdata1 = BlockComposter.addItem(entity, iblockdata, worldserver, blockposition, itemstack, rand);
            itemstack.shrink(1);
            return iblockdata1;
        }
        return iblockdata;
    }

    public static IBlockData extractProduce(Entity entity, IBlockData iblockdata, World world, BlockPosition blockposition) {
        IBlockData iblockdata1;
        if (entity != null && !(entity instanceof EntityHuman) && !CraftEventFactory.callEntityChangeBlockEvent(entity, blockposition, iblockdata1 = BlockComposter.empty(entity, iblockdata, DummyGeneratorAccess.INSTANCE, blockposition))) {
            return iblockdata;
        }
        if (!world.isClientSide) {
            Vec3D vec3d = Vec3D.atLowerCornerWithOffset(blockposition, 0.5, 1.01, 0.5).offsetRandom(world.random, 0.7f);
            EntityItem entityitem = new EntityItem(world, vec3d.x(), vec3d.y(), vec3d.z(), new ItemStack(Items.BONE_MEAL));
            entityitem.setDefaultPickUpDelay();
            world.addFreshEntity(entityitem);
        }
        iblockdata1 = BlockComposter.empty(entity, iblockdata, world, blockposition);
        world.playSound((EntityHuman)null, blockposition, SoundEffects.COMPOSTER_EMPTY, SoundCategory.BLOCKS, 1.0f, 1.0f);
        return iblockdata1;
    }

    static IBlockData empty(@Nullable Entity entity, IBlockData iblockdata, GeneratorAccess generatoraccess, BlockPosition blockposition) {
        IBlockData iblockdata1 = (IBlockData)iblockdata.setValue(LEVEL, 0);
        generatoraccess.setBlock(blockposition, iblockdata1, 3);
        generatoraccess.gameEvent(GameEvent.BLOCK_CHANGE, blockposition, GameEvent.a.of(entity, iblockdata1));
        return iblockdata1;
    }

    static IBlockData addItem(@Nullable Entity entity, IBlockData iblockdata, GeneratorAccess generatoraccess, BlockPosition blockposition, ItemStack itemstack) {
        return BlockComposter.addItem(entity, iblockdata, generatoraccess, blockposition, itemstack, generatoraccess.getRandom().nextDouble());
    }

    static IBlockData addItem(@Nullable Entity entity, IBlockData iblockdata, GeneratorAccess generatoraccess, BlockPosition blockposition, ItemStack itemstack, double rand) {
        int i2 = iblockdata.getValue(LEVEL);
        float f2 = COMPOSTABLES.getFloat((Object)itemstack.getItem());
        if ((i2 != 0 || f2 <= 0.0f) && rand >= (double)f2) {
            return iblockdata;
        }
        int j2 = i2 + 1;
        IBlockData iblockdata1 = (IBlockData)iblockdata.setValue(LEVEL, j2);
        generatoraccess.setBlock(blockposition, iblockdata1, 3);
        generatoraccess.gameEvent(GameEvent.BLOCK_CHANGE, blockposition, GameEvent.a.of(entity, iblockdata1));
        if (j2 == 7) {
            generatoraccess.scheduleTick(blockposition, iblockdata.getBlock(), 20);
        }
        return iblockdata1;
    }

    @Override
    protected void tick(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        if (iblockdata.getValue(LEVEL) == 7) {
            worldserver.setBlock(blockposition, (IBlockData)iblockdata.cycle(LEVEL), 3);
            worldserver.playSound((EntityHuman)null, blockposition, SoundEffects.COMPOSTER_READY, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    @Override
    protected boolean hasAnalogOutputSignal(IBlockData iblockdata) {
        return true;
    }

    @Override
    protected int getAnalogOutputSignal(IBlockData iblockdata, World world, BlockPosition blockposition) {
        return iblockdata.getValue(LEVEL);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.add(LEVEL);
    }

    @Override
    protected boolean isPathfindable(IBlockData iblockdata, PathMode pathmode) {
        return false;
    }

    @Override
    public IWorldInventory getContainer(IBlockData iblockdata, GeneratorAccess generatoraccess, BlockPosition blockposition) {
        int i2 = iblockdata.getValue(LEVEL);
        return (IWorldInventory)((Object)(i2 == 8 ? new ContainerOutput(iblockdata, generatoraccess, blockposition, new ItemStack(Items.BONE_MEAL)) : (i2 < 7 ? new ContainerInput(iblockdata, generatoraccess, blockposition) : new ContainerEmpty(generatoraccess, blockposition))));
    }

    public static class ContainerOutput
    extends InventorySubcontainer
    implements IWorldInventory {
        private final IBlockData state;
        private final GeneratorAccess level;
        private final BlockPosition pos;
        private boolean changed;

        public ContainerOutput(IBlockData iblockdata, GeneratorAccess generatoraccess, BlockPosition blockposition, ItemStack itemstack) {
            super(itemstack);
            this.state = iblockdata;
            this.level = generatoraccess;
            this.pos = blockposition;
            this.bukkitOwner = new CraftBlockInventoryHolder(generatoraccess, blockposition, this);
        }

        @Override
        public int getMaxStackSize() {
            return 1;
        }

        @Override
        public int[] getSlotsForFace(EnumDirection enumdirection) {
            int[] nArray;
            if (enumdirection == EnumDirection.DOWN) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 0;
            } else {
                nArray = new int[]{};
            }
            return nArray;
        }

        @Override
        public boolean canPlaceItemThroughFace(int i2, ItemStack itemstack, @Nullable EnumDirection enumdirection) {
            return false;
        }

        @Override
        public boolean canTakeItemThroughFace(int i2, ItemStack itemstack, EnumDirection enumdirection) {
            return !this.changed && enumdirection == EnumDirection.DOWN && itemstack.is(Items.BONE_MEAL);
        }

        @Override
        public void setChanged() {
            if (this.isEmpty()) {
                BlockComposter.empty(null, this.state, this.level, this.pos);
                this.changed = true;
            } else {
                this.level.setBlock(this.pos, this.state, 3);
                this.changed = false;
            }
        }
    }

    public static class ContainerInput
    extends InventorySubcontainer
    implements IWorldInventory {
        private final IBlockData state;
        private final GeneratorAccess level;
        private final BlockPosition pos;
        private boolean changed;

        public ContainerInput(IBlockData iblockdata, GeneratorAccess generatoraccess, BlockPosition blockposition) {
            super(1);
            this.bukkitOwner = new CraftBlockInventoryHolder(generatoraccess, blockposition, this);
            this.state = iblockdata;
            this.level = generatoraccess;
            this.pos = blockposition;
        }

        @Override
        public int getMaxStackSize() {
            return 1;
        }

        @Override
        public int[] getSlotsForFace(EnumDirection enumdirection) {
            int[] nArray;
            if (enumdirection == EnumDirection.UP) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 0;
            } else {
                nArray = new int[]{};
            }
            return nArray;
        }

        @Override
        public boolean canPlaceItemThroughFace(int i2, ItemStack itemstack, @Nullable EnumDirection enumdirection) {
            return !this.changed && enumdirection == EnumDirection.UP && COMPOSTABLES.containsKey((Object)itemstack.getItem());
        }

        @Override
        public boolean canTakeItemThroughFace(int i2, ItemStack itemstack, EnumDirection enumdirection) {
            return false;
        }

        @Override
        public void setChanged() {
            ItemStack itemstack = this.getItem(0);
            if (!itemstack.isEmpty()) {
                this.changed = true;
                IBlockData iblockdata = BlockComposter.addItem(null, this.state, this.level, this.pos, itemstack);
                this.level.levelEvent(1500, this.pos, iblockdata != this.state ? 1 : 0);
                this.removeItemNoUpdate(0);
            }
        }
    }

    public static class ContainerEmpty
    extends InventorySubcontainer
    implements IWorldInventory {
        public ContainerEmpty(GeneratorAccess generatoraccess, BlockPosition blockposition) {
            super(0);
            this.bukkitOwner = new CraftBlockInventoryHolder(generatoraccess, blockposition, this);
        }

        @Override
        public int[] getSlotsForFace(EnumDirection enumdirection) {
            return new int[0];
        }

        @Override
        public boolean canPlaceItemThroughFace(int i2, ItemStack itemstack, @Nullable EnumDirection enumdirection) {
            return false;
        }

        @Override
        public boolean canTakeItemThroughFace(int i2, ItemStack itemstack, EnumDirection enumdirection) {
            return false;
        }
    }
}

