/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.entity.item.EntityFallingBlock;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFalling;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockFormEvent;

public class BlockConcretePowder
extends BlockFalling {
    public static final MapCodec<BlockConcretePowder> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("concrete").forGetter(blockconcretepowder -> blockconcretepowder.concrete), BlockConcretePowder.propertiesCodec()).apply((Applicative)instance, BlockConcretePowder::new));
    private final Block concrete;

    public MapCodec<BlockConcretePowder> codec() {
        return CODEC;
    }

    public BlockConcretePowder(Block block, BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.concrete = block;
    }

    @Override
    public void onLand(World world, BlockPosition blockposition, IBlockData iblockdata, IBlockData iblockdata1, EntityFallingBlock entityfallingblock) {
        if (BlockConcretePowder.shouldSolidify(world, blockposition, iblockdata1)) {
            CraftEventFactory.handleBlockFormEvent(world, blockposition, this.concrete.defaultBlockState(), 3);
        }
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext blockactioncontext) {
        IBlockData iblockdata;
        BlockPosition blockposition;
        World world = blockactioncontext.getLevel();
        if (!BlockConcretePowder.shouldSolidify(world, blockposition = blockactioncontext.getClickedPos(), iblockdata = world.getBlockState(blockposition))) {
            return super.getStateForPlacement(blockactioncontext);
        }
        CraftBlockState blockState = CraftBlockStates.getBlockState(world, blockposition);
        blockState.setData(this.concrete.defaultBlockState());
        BlockFormEvent event = new BlockFormEvent((org.bukkit.block.Block)blockState.getBlock(), (BlockState)blockState);
        world.getServer().server.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            return blockState.getHandle();
        }
        return super.getStateForPlacement(blockactioncontext);
    }

    private static boolean shouldSolidify(IBlockAccess iblockaccess, BlockPosition blockposition, IBlockData iblockdata) {
        return BlockConcretePowder.canSolidify(iblockdata) || BlockConcretePowder.touchesLiquid(iblockaccess, blockposition);
    }

    private static boolean touchesLiquid(IBlockAccess iblockaccess, BlockPosition blockposition) {
        boolean flag = false;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = blockposition.mutable();
        for (EnumDirection enumdirection : EnumDirection.values()) {
            IBlockData iblockdata = iblockaccess.getBlockState(blockposition_mutableblockposition);
            if (enumdirection == EnumDirection.DOWN && !BlockConcretePowder.canSolidify(iblockdata)) continue;
            blockposition_mutableblockposition.setWithOffset((BaseBlockPosition)blockposition, enumdirection);
            iblockdata = iblockaccess.getBlockState(blockposition_mutableblockposition);
            if (!BlockConcretePowder.canSolidify(iblockdata) || iblockdata.isFaceSturdy(iblockaccess, blockposition, enumdirection.getOpposite())) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private static boolean canSolidify(IBlockData iblockdata) {
        return iblockdata.getFluidState().is(TagsFluid.WATER);
    }

    @Override
    protected IBlockData updateShape(IBlockData iblockdata, EnumDirection enumdirection, IBlockData iblockdata1, GeneratorAccess generatoraccess, BlockPosition blockposition, BlockPosition blockposition1) {
        if (BlockConcretePowder.touchesLiquid(generatoraccess, blockposition)) {
            if (!(generatoraccess instanceof World)) {
                return this.concrete.defaultBlockState();
            }
            CraftBlockState blockState = CraftBlockStates.getBlockState(generatoraccess, blockposition);
            blockState.setData(this.concrete.defaultBlockState());
            BlockFormEvent event = new BlockFormEvent((org.bukkit.block.Block)blockState.getBlock(), (BlockState)blockState);
            ((World)generatoraccess).getCraftServer().getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                return blockState.getHandle();
            }
        }
        return super.updateShape(iblockdata, enumdirection, iblockdata1, generatoraccess, blockposition, blockposition1);
    }

    @Override
    public int getDustColor(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition) {
        return iblockdata.getMapColor((IBlockAccess)iblockaccess, (BlockPosition)blockposition).col;
    }
}

