/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCoral;
import net.minecraft.world.level.block.BlockCoralFanAbstract;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.FluidTypes;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;

public class BlockCoralFan
extends BlockCoralFanAbstract {
    public static final MapCodec<BlockCoralFan> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockCoral.DEAD_CORAL_FIELD.forGetter(blockcoralfan -> blockcoralfan.deadBlock), BlockCoralFan.propertiesCodec()).apply((Applicative)instance, BlockCoralFan::new));
    private final Block deadBlock;

    public MapCodec<BlockCoralFan> codec() {
        return CODEC;
    }

    protected BlockCoralFan(Block block, BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.deadBlock = block;
    }

    @Override
    protected void onPlace(IBlockData iblockdata, World world, BlockPosition blockposition, IBlockData iblockdata1, boolean flag) {
        this.tryScheduleDieTick(iblockdata, world, blockposition);
    }

    @Override
    protected void tick(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        if (!BlockCoralFan.scanForWater(iblockdata, worldserver, blockposition)) {
            if (CraftEventFactory.callBlockFadeEvent(worldserver, blockposition, (IBlockData)this.deadBlock.defaultBlockState().setValue(WATERLOGGED, false)).isCancelled()) {
                return;
            }
            worldserver.setBlock(blockposition, (IBlockData)this.deadBlock.defaultBlockState().setValue(WATERLOGGED, false), 2);
        }
    }

    @Override
    protected IBlockData updateShape(IBlockData iblockdata, EnumDirection enumdirection, IBlockData iblockdata1, GeneratorAccess generatoraccess, BlockPosition blockposition, BlockPosition blockposition1) {
        if (enumdirection == EnumDirection.DOWN && !iblockdata.canSurvive(generatoraccess, blockposition)) {
            return Blocks.AIR.defaultBlockState();
        }
        this.tryScheduleDieTick(iblockdata, generatoraccess, blockposition);
        if (iblockdata.getValue(WATERLOGGED).booleanValue()) {
            generatoraccess.scheduleTick(blockposition, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(generatoraccess));
        }
        return super.updateShape(iblockdata, enumdirection, iblockdata1, generatoraccess, blockposition, blockposition1);
    }
}

