/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCoral;
import net.minecraft.world.level.block.BlockCoralFanWallAbstract;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.FluidTypes;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;

public class BlockCoralFanWall
extends BlockCoralFanWallAbstract {
    public static final MapCodec<BlockCoralFanWall> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockCoral.DEAD_CORAL_FIELD.forGetter(blockcoralfanwall -> blockcoralfanwall.deadBlock), BlockCoralFanWall.propertiesCodec()).apply((Applicative)instance, BlockCoralFanWall::new));
    private final Block deadBlock;

    public MapCodec<BlockCoralFanWall> codec() {
        return CODEC;
    }

    protected BlockCoralFanWall(Block block, BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.deadBlock = block;
    }

    @Override
    protected void onPlace(IBlockData iblockdata, World world, BlockPosition blockposition, IBlockData iblockdata1, boolean flag) {
        this.tryScheduleDieTick(iblockdata, world, blockposition);
    }

    @Override
    protected void tick(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        if (!BlockCoralFanWall.scanForWater(iblockdata, worldserver, blockposition)) {
            if (CraftEventFactory.callBlockFadeEvent(worldserver, blockposition, (IBlockData)((IBlockData)this.deadBlock.defaultBlockState().setValue(WATERLOGGED, false)).setValue(FACING, iblockdata.getValue(FACING))).isCancelled()) {
                return;
            }
            worldserver.setBlock(blockposition, (IBlockData)((IBlockData)this.deadBlock.defaultBlockState().setValue(WATERLOGGED, false)).setValue(FACING, iblockdata.getValue(FACING)), 2);
        }
    }

    @Override
    protected IBlockData updateShape(IBlockData iblockdata, EnumDirection enumdirection, IBlockData iblockdata1, GeneratorAccess generatoraccess, BlockPosition blockposition, BlockPosition blockposition1) {
        if (enumdirection.getOpposite() == iblockdata.getValue(FACING) && !iblockdata.canSurvive(generatoraccess, blockposition)) {
            return Blocks.AIR.defaultBlockState();
        }
        if (iblockdata.getValue(WATERLOGGED).booleanValue()) {
            generatoraccess.scheduleTick(blockposition, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(generatoraccess));
        }
        this.tryScheduleDieTick(iblockdata, generatoraccess, blockposition);
        return super.updateShape(iblockdata, enumdirection, iblockdata1, generatoraccess, blockposition, blockposition1);
    }
}

