/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCoral;
import net.minecraft.world.level.block.BlockCoralBase;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;

public class BlockCoralPlant
extends BlockCoralBase {
    public static final MapCodec<BlockCoralPlant> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockCoral.DEAD_CORAL_FIELD.forGetter(blockcoralplant -> blockcoralplant.deadBlock), BlockCoralPlant.propertiesCodec()).apply((Applicative)instance, BlockCoralPlant::new));
    private final Block deadBlock;
    protected static final float AABB_OFFSET = 6.0f;
    protected static final VoxelShape SHAPE = Block.box(2.0, 0.0, 2.0, 14.0, 15.0, 14.0);

    public MapCodec<BlockCoralPlant> codec() {
        return CODEC;
    }

    protected BlockCoralPlant(Block block, BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.deadBlock = block;
    }

    @Override
    protected void onPlace(IBlockData iblockdata, World world, BlockPosition blockposition, IBlockData iblockdata1, boolean flag) {
        this.tryScheduleDieTick(iblockdata, world, blockposition);
    }

    @Override
    protected void tick(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        if (!BlockCoralPlant.scanForWater(iblockdata, worldserver, blockposition)) {
            if (CraftEventFactory.callBlockFadeEvent(worldserver, blockposition, (IBlockData)this.deadBlock.defaultBlockState().setValue(WATERLOGGED, false)).isCancelled()) {
                return;
            }
            worldserver.setBlock(blockposition, (IBlockData)this.deadBlock.defaultBlockState().setValue(WATERLOGGED, false), 2);
        }
    }

    @Override
    protected IBlockData updateShape(IBlockData iblockdata, EnumDirection enumdirection, IBlockData iblockdata1, GeneratorAccess generatoraccess, BlockPosition blockposition, BlockPosition blockposition1) {
        if (enumdirection == EnumDirection.DOWN && !iblockdata.canSurvive(generatoraccess, blockposition)) {
            return Blocks.AIR.defaultBlockState();
        }
        this.tryScheduleDieTick(iblockdata, generatoraccess, blockposition);
        if (iblockdata.getValue(WATERLOGGED).booleanValue()) {
            generatoraccess.scheduleTick(blockposition, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(generatoraccess));
        }
        return super.updateShape(iblockdata, enumdirection, iblockdata1, generatoraccess, blockposition, blockposition1);
    }

    @Override
    protected VoxelShape getShape(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return SHAPE;
    }
}

