/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.EntityRavager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockPlant;
import net.minecraft.world.level.block.BlockSoil;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;

public class BlockCrops
extends BlockPlant
implements IBlockFragilePlantElement {
    public static final MapCodec<BlockCrops> CODEC = BlockCrops.simpleCodec(BlockCrops::new);
    public static final int MAX_AGE = 7;
    public static final BlockStateInteger AGE = BlockProperties.AGE_7;
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.box(0.0, 0.0, 0.0, 16.0, 2.0, 16.0), Block.box(0.0, 0.0, 0.0, 16.0, 4.0, 16.0), Block.box(0.0, 0.0, 0.0, 16.0, 6.0, 16.0), Block.box(0.0, 0.0, 0.0, 16.0, 8.0, 16.0), Block.box(0.0, 0.0, 0.0, 16.0, 10.0, 16.0), Block.box(0.0, 0.0, 0.0, 16.0, 12.0, 16.0), Block.box(0.0, 0.0, 0.0, 16.0, 14.0, 16.0), Block.box(0.0, 0.0, 0.0, 16.0, 16.0, 16.0)};

    public MapCodec<? extends BlockCrops> codec() {
        return CODEC;
    }

    protected BlockCrops(BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(this.getAgeProperty(), 0));
    }

    @Override
    protected VoxelShape getShape(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return SHAPE_BY_AGE[this.getAge(iblockdata)];
    }

    @Override
    protected boolean mayPlaceOn(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition) {
        return iblockdata.is(Blocks.FARMLAND);
    }

    protected BlockStateInteger getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 7;
    }

    public int getAge(IBlockData iblockdata) {
        return iblockdata.getValue(this.getAgeProperty());
    }

    public IBlockData getStateForAge(int i2) {
        return (IBlockData)this.defaultBlockState().setValue(this.getAgeProperty(), i2);
    }

    public final boolean isMaxAge(IBlockData iblockdata) {
        return this.getAge(iblockdata) >= this.getMaxAge();
    }

    @Override
    protected boolean isRandomlyTicking(IBlockData iblockdata) {
        return !this.isMaxAge(iblockdata);
    }

    @Override
    protected void randomTick(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        int i2;
        if (worldserver.getRawBrightness(blockposition, 0) >= 9 && (i2 = this.getAge(iblockdata)) < this.getMaxAge()) {
            float f2 = BlockCrops.getGrowthSpeed(this, worldserver, blockposition);
            int modifier = this == Blocks.BEETROOTS ? worldserver.spigotConfig.beetrootModifier : (this == Blocks.CARROTS ? worldserver.spigotConfig.carrotModifier : (this == Blocks.POTATOES ? worldserver.spigotConfig.potatoModifier : worldserver.spigotConfig.wheatModifier));
            if ((double)randomsource.nextFloat() < (double)modifier / (100.0 * Math.floor(25.0f / f2 + 1.0f))) {
                CraftEventFactory.handleBlockGrowEvent(worldserver, blockposition, this.getStateForAge(i2 + 1), 2);
            }
        }
    }

    public void growCrops(World world, BlockPosition blockposition, IBlockData iblockdata) {
        int j2;
        int i2 = this.getAge(iblockdata) + this.getBonemealAgeIncrease(world);
        if (i2 > (j2 = this.getMaxAge())) {
            i2 = j2;
        }
        CraftEventFactory.handleBlockGrowEvent(world, blockposition, this.getStateForAge(i2), 2);
    }

    protected int getBonemealAgeIncrease(World world) {
        return MathHelper.nextInt(world.random, 2, 5);
    }

    protected static float getGrowthSpeed(Block block, IBlockAccess iblockaccess, BlockPosition blockposition) {
        boolean flag1;
        float f2 = 1.0f;
        BlockPosition blockposition1 = blockposition.below();
        for (int i2 = -1; i2 <= 1; ++i2) {
            for (int j2 = -1; j2 <= 1; ++j2) {
                float f1 = 0.0f;
                IBlockData iblockdata = iblockaccess.getBlockState(blockposition1.offset(i2, 0, j2));
                if (iblockdata.is(Blocks.FARMLAND)) {
                    f1 = 1.0f;
                    if (iblockdata.getValue(BlockSoil.MOISTURE) > 0) {
                        f1 = 3.0f;
                    }
                }
                if (i2 != 0 || j2 != 0) {
                    f1 /= 4.0f;
                }
                f2 += f1;
            }
        }
        BlockPosition blockposition2 = blockposition.north();
        BlockPosition blockposition3 = blockposition.south();
        BlockPosition blockposition4 = blockposition.west();
        BlockPosition blockposition5 = blockposition.east();
        boolean flag = iblockaccess.getBlockState(blockposition4).is(block) || iblockaccess.getBlockState(blockposition5).is(block);
        boolean bl = flag1 = iblockaccess.getBlockState(blockposition2).is(block) || iblockaccess.getBlockState(blockposition3).is(block);
        if (flag && flag1) {
            f2 /= 2.0f;
        } else {
            boolean flag2;
            boolean bl2 = flag2 = iblockaccess.getBlockState(blockposition4.north()).is(block) || iblockaccess.getBlockState(blockposition5.north()).is(block) || iblockaccess.getBlockState(blockposition5.south()).is(block) || iblockaccess.getBlockState(blockposition4.south()).is(block);
            if (flag2) {
                f2 /= 2.0f;
            }
        }
        return f2;
    }

    @Override
    protected boolean canSurvive(IBlockData iblockdata, IWorldReader iworldreader, BlockPosition blockposition) {
        return BlockCrops.hasSufficientLight(iworldreader, blockposition) && super.canSurvive(iblockdata, iworldreader, blockposition);
    }

    protected static boolean hasSufficientLight(IWorldReader iworldreader, BlockPosition blockposition) {
        return iworldreader.getRawBrightness(blockposition, 0) >= 8;
    }

    @Override
    protected void entityInside(IBlockData iblockdata, World world, BlockPosition blockposition, Entity entity) {
        if (entity instanceof EntityRavager && CraftEventFactory.callEntityChangeBlockEvent(entity, blockposition, Blocks.AIR.defaultBlockState(), !world.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING))) {
            world.destroyBlock(blockposition, true, entity);
        }
        super.entityInside(iblockdata, world, blockposition, entity);
    }

    protected IMaterial getBaseSeedId() {
        return Items.WHEAT_SEEDS;
    }

    @Override
    public ItemStack getCloneItemStack(IWorldReader iworldreader, BlockPosition blockposition, IBlockData iblockdata) {
        return new ItemStack(this.getBaseSeedId());
    }

    @Override
    public boolean isValidBonemealTarget(IWorldReader iworldreader, BlockPosition blockposition, IBlockData iblockdata) {
        return !this.isMaxAge(iblockdata);
    }

    @Override
    public boolean isBonemealSuccess(World world, RandomSource randomsource, BlockPosition blockposition, IBlockData iblockdata) {
        return true;
    }

    @Override
    public void performBonemeal(WorldServer worldserver, RandomSource randomsource, BlockPosition blockposition, IBlockData iblockdata) {
        this.growCrops(worldserver, blockposition, iblockdata);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.add(AGE);
    }
}

