/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.block.BlockDirtSnow;
import net.minecraft.world.level.block.BlockSnow;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.lighting.LightEngine;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;

public abstract class BlockDirtSnowSpreadable
extends BlockDirtSnow {
    protected BlockDirtSnowSpreadable(BlockBase.Info blockbase_info) {
        super(blockbase_info);
    }

    private static boolean canBeGrass(IBlockData iblockdata, IWorldReader iworldreader, BlockPosition blockposition) {
        BlockPosition blockposition1 = blockposition.above();
        IBlockData iblockdata1 = iworldreader.getBlockState(blockposition1);
        if (iblockdata1.is(Blocks.SNOW) && iblockdata1.getValue(BlockSnow.LAYERS) == 1) {
            return true;
        }
        if (iblockdata1.getFluidState().getAmount() == 8) {
            return false;
        }
        int i2 = LightEngine.getLightBlockInto(iworldreader, iblockdata, blockposition, iblockdata1, blockposition1, EnumDirection.UP, iblockdata1.getLightBlock(iworldreader, blockposition1));
        return i2 < iworldreader.getMaxLightLevel();
    }

    protected abstract MapCodec<? extends BlockDirtSnowSpreadable> codec();

    private static boolean canPropagate(IBlockData iblockdata, IWorldReader iworldreader, BlockPosition blockposition) {
        BlockPosition blockposition1 = blockposition.above();
        return BlockDirtSnowSpreadable.canBeGrass(iblockdata, iworldreader, blockposition) && !iworldreader.getFluidState(blockposition1).is(TagsFluid.WATER);
    }

    @Override
    protected void randomTick(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        if (!BlockDirtSnowSpreadable.canBeGrass(iblockdata, worldserver, blockposition)) {
            if (CraftEventFactory.callBlockFadeEvent(worldserver, blockposition, Blocks.DIRT.defaultBlockState()).isCancelled()) {
                return;
            }
            worldserver.setBlockAndUpdate(blockposition, Blocks.DIRT.defaultBlockState());
        } else if (worldserver.getMaxLocalRawBrightness(blockposition.above()) >= 9) {
            IBlockData iblockdata1 = this.defaultBlockState();
            for (int i2 = 0; i2 < 4; ++i2) {
                BlockPosition blockposition1 = blockposition.offset(randomsource.nextInt(3) - 1, randomsource.nextInt(5) - 3, randomsource.nextInt(3) - 1);
                if (!worldserver.getBlockState(blockposition1).is(Blocks.DIRT) || !BlockDirtSnowSpreadable.canPropagate(iblockdata1, worldserver, blockposition1)) continue;
                CraftEventFactory.handleBlockSpreadEvent(worldserver, blockposition, blockposition1, (IBlockData)iblockdata1.setValue(SNOWY, worldserver.getBlockState(blockposition1.above()).is(Blocks.SNOW)));
            }
        }
    }
}

