/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFalling;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockFromToEvent;

public class BlockDragonEgg
extends BlockFalling {
    public static final MapCodec<BlockDragonEgg> CODEC = BlockDragonEgg.simpleCodec(BlockDragonEgg::new);
    protected static final VoxelShape SHAPE = Block.box(1.0, 0.0, 1.0, 15.0, 16.0, 15.0);

    public MapCodec<BlockDragonEgg> codec() {
        return CODEC;
    }

    public BlockDragonEgg(BlockBase.Info blockbase_info) {
        super(blockbase_info);
    }

    @Override
    protected VoxelShape getShape(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return SHAPE;
    }

    @Override
    protected EnumInteractionResult useWithoutItem(IBlockData iblockdata, World world, BlockPosition blockposition, EntityHuman entityhuman, MovingObjectPositionBlock movingobjectpositionblock) {
        this.teleport(iblockdata, world, blockposition);
        return EnumInteractionResult.sidedSuccess(world.isClientSide);
    }

    @Override
    protected void attack(IBlockData iblockdata, World world, BlockPosition blockposition, EntityHuman entityhuman) {
        this.teleport(iblockdata, world, blockposition);
    }

    private void teleport(IBlockData iblockdata, World world, BlockPosition blockposition) {
        WorldBorder worldborder = world.getWorldBorder();
        for (int i2 = 0; i2 < 1000; ++i2) {
            BlockPosition blockposition1 = blockposition.offset(world.random.nextInt(16) - world.random.nextInt(16), world.random.nextInt(8) - world.random.nextInt(8), world.random.nextInt(16) - world.random.nextInt(16));
            if (!world.getBlockState(blockposition1).isAir() || !worldborder.isWithinBounds(blockposition1)) continue;
            org.bukkit.block.Block from = world.getWorld().getBlockAt(blockposition.getX(), blockposition.getY(), blockposition.getZ());
            org.bukkit.block.Block to = world.getWorld().getBlockAt(blockposition1.getX(), blockposition1.getY(), blockposition1.getZ());
            BlockFromToEvent event = new BlockFromToEvent(from, to);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            blockposition1 = new BlockPosition(event.getToBlock().getX(), event.getToBlock().getY(), event.getToBlock().getZ());
            if (world.isClientSide) {
                for (int j2 = 0; j2 < 128; ++j2) {
                    double d0 = world.random.nextDouble();
                    float f2 = (world.random.nextFloat() - 0.5f) * 0.2f;
                    float f1 = (world.random.nextFloat() - 0.5f) * 0.2f;
                    float f22 = (world.random.nextFloat() - 0.5f) * 0.2f;
                    double d1 = MathHelper.lerp(d0, (double)blockposition1.getX(), (double)blockposition.getX()) + (world.random.nextDouble() - 0.5) + 0.5;
                    double d2 = MathHelper.lerp(d0, (double)blockposition1.getY(), (double)blockposition.getY()) + world.random.nextDouble() - 0.5;
                    double d3 = MathHelper.lerp(d0, (double)blockposition1.getZ(), (double)blockposition.getZ()) + (world.random.nextDouble() - 0.5) + 0.5;
                    world.addParticle(Particles.PORTAL, d1, d2, d3, f2, f1, f22);
                }
            } else {
                world.setBlock(blockposition1, iblockdata, 2);
                world.removeBlock(blockposition, false);
            }
            return;
        }
    }

    @Override
    protected int getDelayAfterPlace() {
        return 5;
    }

    @Override
    protected boolean isPathfindable(IBlockData iblockdata, PathMode pathmode) {
        return false;
    }
}

