/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.dispenser.DispenseBehaviorItem;
import net.minecraft.core.dispenser.IDispenseBehavior;
import net.minecraft.core.dispenser.SourceBlock;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.IInventory;
import net.minecraft.world.InventoryLargeChest;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockDispenser;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityDispenser;
import net.minecraft.world.level.block.entity.TileEntityDropper;
import net.minecraft.world.level.block.entity.TileEntityHopper;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryDoubleChest;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.slf4j.Logger;

public class BlockDropper
extends BlockDispenser {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final MapCodec<BlockDropper> CODEC = BlockDropper.simpleCodec(BlockDropper::new);
    private static final IDispenseBehavior DISPENSE_BEHAVIOUR = new DispenseBehaviorItem(true);

    public MapCodec<BlockDropper> codec() {
        return CODEC;
    }

    public BlockDropper(BlockBase.Info blockbase_info) {
        super(blockbase_info);
    }

    @Override
    protected IDispenseBehavior getDispenseMethod(World world, net.minecraft.world.item.ItemStack itemstack) {
        return DISPENSE_BEHAVIOUR;
    }

    @Override
    public TileEntity newBlockEntity(BlockPosition blockposition, IBlockData iblockdata) {
        return new TileEntityDropper(blockposition, iblockdata);
    }

    @Override
    public void dispenseFrom(WorldServer worldserver, IBlockData iblockdata, BlockPosition blockposition) {
        TileEntityDispenser tileentitydispenser = worldserver.getBlockEntity(blockposition, TileEntityTypes.DROPPER).orElse(null);
        if (tileentitydispenser == null) {
            LOGGER.warn("Ignoring dispensing attempt for Dropper without matching block entity at {}", (Object)blockposition);
        } else {
            SourceBlock sourceblock = new SourceBlock(worldserver, blockposition, iblockdata, tileentitydispenser);
            int i2 = tileentitydispenser.getRandomSlot(worldserver.random);
            if (i2 < 0) {
                worldserver.levelEvent(1001, blockposition, 0);
            } else {
                net.minecraft.world.item.ItemStack itemstack = tileentitydispenser.getItem(i2);
                if (!itemstack.isEmpty()) {
                    net.minecraft.world.item.ItemStack itemstack1;
                    EnumDirection enumdirection = worldserver.getBlockState(blockposition).getValue(FACING);
                    IInventory iinventory = TileEntityHopper.getContainerAt(worldserver, blockposition.relative(enumdirection));
                    if (iinventory == null) {
                        itemstack1 = DISPENSE_BEHAVIOUR.dispense(sourceblock, itemstack);
                    } else {
                        CraftItemStack oitemstack = CraftItemStack.asCraftMirror(itemstack.copyWithCount(1));
                        Inventory destinationInventory = iinventory instanceof InventoryLargeChest ? new CraftInventoryDoubleChest((InventoryLargeChest)iinventory) : iinventory.getOwner().getInventory();
                        InventoryMoveItemEvent event = new InventoryMoveItemEvent(tileentitydispenser.getOwner().getInventory(), (ItemStack)oitemstack, destinationInventory, true);
                        worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                        if (event.isCancelled()) {
                            return;
                        }
                        itemstack1 = TileEntityHopper.addItem(tileentitydispenser, iinventory, CraftItemStack.asNMSCopy(event.getItem()), enumdirection.getOpposite());
                        if (event.getItem().equals((Object)oitemstack) && itemstack1.isEmpty()) {
                            itemstack1 = itemstack.copy();
                            itemstack1.shrink(1);
                        } else {
                            itemstack1 = itemstack.copy();
                        }
                    }
                    tileentitydispenser.setItem(i2, itemstack1);
                }
            }
        }
    }
}

