/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.EntityEnderPearl;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityEndGateway;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.player.PlayerTeleportEvent;

public class BlockEndGateway
extends BlockTileEntity
implements Portal {
    public static final MapCodec<BlockEndGateway> CODEC = BlockEndGateway.simpleCodec(BlockEndGateway::new);

    public MapCodec<BlockEndGateway> codec() {
        return CODEC;
    }

    protected BlockEndGateway(BlockBase.Info blockbase_info) {
        super(blockbase_info);
    }

    @Override
    public TileEntity newBlockEntity(BlockPosition blockposition, IBlockData iblockdata) {
        return new TileEntityEndGateway(blockposition, iblockdata);
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> getTicker(World world, IBlockData iblockdata, TileEntityTypes<T> tileentitytypes) {
        return BlockEndGateway.createTickerHelper(tileentitytypes, TileEntityTypes.END_GATEWAY, world.isClientSide ? TileEntityEndGateway::beamAnimationTick : TileEntityEndGateway::portalTick);
    }

    @Override
    public void animateTick(IBlockData iblockdata, World world, BlockPosition blockposition, RandomSource randomsource) {
        TileEntity tileentity = world.getBlockEntity(blockposition);
        if (tileentity instanceof TileEntityEndGateway) {
            int i2 = ((TileEntityEndGateway)tileentity).getParticleAmount();
            for (int j2 = 0; j2 < i2; ++j2) {
                double d0 = (double)blockposition.getX() + randomsource.nextDouble();
                double d1 = (double)blockposition.getY() + randomsource.nextDouble();
                double d2 = (double)blockposition.getZ() + randomsource.nextDouble();
                double d3 = (randomsource.nextDouble() - 0.5) * 0.5;
                double d4 = (randomsource.nextDouble() - 0.5) * 0.5;
                double d5 = (randomsource.nextDouble() - 0.5) * 0.5;
                int k2 = randomsource.nextInt(2) * 2 - 1;
                if (randomsource.nextBoolean()) {
                    d2 = (double)blockposition.getZ() + 0.5 + 0.25 * (double)k2;
                    d5 = randomsource.nextFloat() * 2.0f * (float)k2;
                } else {
                    d0 = (double)blockposition.getX() + 0.5 + 0.25 * (double)k2;
                    d3 = randomsource.nextFloat() * 2.0f * (float)k2;
                }
                world.addParticle(Particles.PORTAL, d0, d1, d2, d3, d4, d5);
            }
        }
    }

    @Override
    public ItemStack getCloneItemStack(IWorldReader iworldreader, BlockPosition blockposition, IBlockData iblockdata) {
        return ItemStack.EMPTY;
    }

    @Override
    protected boolean canBeReplaced(IBlockData iblockdata, FluidType fluidtype) {
        return false;
    }

    @Override
    protected void entityInside(IBlockData iblockdata, World world, BlockPosition blockposition, Entity entity) {
        if (entity.canUsePortal(false)) {
            TileEntityEndGateway tileentityendgateway;
            TileEntity tileentity = world.getBlockEntity(blockposition);
            if (!world.isClientSide && tileentity instanceof TileEntityEndGateway && !(tileentityendgateway = (TileEntityEndGateway)tileentity).isCoolingDown()) {
                entity.setAsInsidePortal(this, blockposition);
                TileEntityEndGateway.triggerCooldown(world, blockposition, iblockdata, tileentityendgateway);
            }
        }
    }

    @Override
    @Nullable
    public DimensionTransition getPortalDestination(WorldServer worldserver, Entity entity, BlockPosition blockposition) {
        TileEntity tileentity = worldserver.getBlockEntity(blockposition);
        if (tileentity instanceof TileEntityEndGateway) {
            TileEntityEndGateway tileentityendgateway = (TileEntityEndGateway)tileentity;
            Vec3D vec3d = tileentityendgateway.getPortalPosition(worldserver, blockposition);
            return vec3d != null ? new DimensionTransition(worldserver, vec3d, BlockEndGateway.calculateExitMovement(entity), entity.getYRot(), entity.getXRot(), DimensionTransition.PLACE_PORTAL_TICKET, PlayerTeleportEvent.TeleportCause.END_GATEWAY) : null;
        }
        return null;
    }

    private static Vec3D calculateExitMovement(Entity entity) {
        return entity instanceof EntityEnderPearl ? new Vec3D(0.0, -1.0, 0.0) : entity.getDeltaMovement();
    }
}

