/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockGrowingAbstract;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;

public abstract class BlockGrowingTop
extends BlockGrowingAbstract
implements IBlockFragilePlantElement {
    public static final BlockStateInteger AGE = BlockProperties.AGE_25;
    public static final int MAX_AGE = 25;
    private final double growPerTickProbability;

    protected BlockGrowingTop(BlockBase.Info blockbase_info, EnumDirection enumdirection, VoxelShape voxelshape, boolean flag, double d0) {
        super(blockbase_info, enumdirection, voxelshape, flag);
        this.growPerTickProbability = d0;
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(AGE, 0));
    }

    protected abstract MapCodec<? extends BlockGrowingTop> codec();

    @Override
    public IBlockData getStateForPlacement(GeneratorAccess generatoraccess) {
        return (IBlockData)this.defaultBlockState().setValue(AGE, generatoraccess.getRandom().nextInt(25));
    }

    @Override
    protected boolean isRandomlyTicking(IBlockData iblockdata) {
        return iblockdata.getValue(AGE) < 25;
    }

    @Override
    protected void randomTick(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        BlockPosition blockposition1;
        int modifier = this == Blocks.KELP ? worldserver.spigotConfig.kelpModifier : (this == Blocks.TWISTING_VINES ? worldserver.spigotConfig.twistingVinesModifier : (this == Blocks.WEEPING_VINES ? worldserver.spigotConfig.weepingVinesModifier : worldserver.spigotConfig.caveVinesModifier));
        if (iblockdata.getValue(AGE) < 25 && randomsource.nextDouble() < (double)modifier / 100.0 * this.growPerTickProbability && this.canGrowInto(worldserver.getBlockState(blockposition1 = blockposition.relative(this.growthDirection)))) {
            CraftEventFactory.handleBlockSpreadEvent(worldserver, blockposition, blockposition1, this.getGrowIntoState(iblockdata, worldserver.random));
        }
    }

    protected IBlockData getGrowIntoState(IBlockData iblockdata, RandomSource randomsource) {
        return (IBlockData)iblockdata.cycle(AGE);
    }

    public IBlockData getMaxAgeState(IBlockData iblockdata) {
        return (IBlockData)iblockdata.setValue(AGE, 25);
    }

    public boolean isMaxAge(IBlockData iblockdata) {
        return iblockdata.getValue(AGE) == 25;
    }

    protected IBlockData updateBodyAfterConvertedFromHead(IBlockData iblockdata, IBlockData iblockdata1) {
        return iblockdata1;
    }

    @Override
    protected IBlockData updateShape(IBlockData iblockdata, EnumDirection enumdirection, IBlockData iblockdata1, GeneratorAccess generatoraccess, BlockPosition blockposition, BlockPosition blockposition1) {
        if (enumdirection == this.growthDirection.getOpposite() && !iblockdata.canSurvive(generatoraccess, blockposition)) {
            generatoraccess.scheduleTick(blockposition, this, 1);
        }
        if (enumdirection == this.growthDirection && (iblockdata1.is(this) || iblockdata1.is(this.getBodyBlock()))) {
            return this.updateBodyAfterConvertedFromHead(iblockdata, this.getBodyBlock().defaultBlockState());
        }
        if (this.scheduleFluidTicks) {
            generatoraccess.scheduleTick(blockposition, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(generatoraccess));
        }
        return super.updateShape(iblockdata, enumdirection, iblockdata1, generatoraccess, blockposition, blockposition1);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.add(AGE);
    }

    @Override
    public boolean isValidBonemealTarget(IWorldReader iworldreader, BlockPosition blockposition, IBlockData iblockdata) {
        return this.canGrowInto(iworldreader.getBlockState(blockposition.relative(this.growthDirection)));
    }

    @Override
    public boolean isBonemealSuccess(World world, RandomSource randomsource, BlockPosition blockposition, IBlockData iblockdata) {
        return true;
    }

    @Override
    public void performBonemeal(WorldServer worldserver, RandomSource randomsource, BlockPosition blockposition, IBlockData iblockdata) {
        BlockPosition blockposition1 = blockposition.relative(this.growthDirection);
        int i2 = Math.min(iblockdata.getValue(AGE) + 1, 25);
        int j2 = this.getBlocksToGrowWhenBonemealed(randomsource);
        for (int k2 = 0; k2 < j2 && this.canGrowInto(worldserver.getBlockState(blockposition1)); ++k2) {
            worldserver.setBlockAndUpdate(blockposition1, (IBlockData)iblockdata.setValue(AGE, i2));
            blockposition1 = blockposition1.relative(this.growthDirection);
            i2 = Math.min(i2 + 1, 25);
        }
    }

    protected abstract int getBlocksToGrowWhenBonemealed(RandomSource var1);

    protected abstract boolean canGrowInto(IBlockData var1);

    @Override
    protected BlockGrowingTop getHeadBlock() {
        return this;
    }
}

