/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityHopper;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateDirection;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class BlockHopper
extends BlockTileEntity {
    public static final MapCodec<BlockHopper> CODEC = BlockHopper.simpleCodec(BlockHopper::new);
    public static final BlockStateDirection FACING = BlockProperties.FACING_HOPPER;
    public static final BlockStateBoolean ENABLED = BlockProperties.ENABLED;
    private static final VoxelShape TOP = Block.box(0.0, 10.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape FUNNEL = Block.box(4.0, 4.0, 4.0, 12.0, 10.0, 12.0);
    private static final VoxelShape CONVEX_BASE = VoxelShapes.or(FUNNEL, TOP);
    private static final VoxelShape INSIDE = BlockHopper.box(2.0, 11.0, 2.0, 14.0, 16.0, 14.0);
    private static final VoxelShape BASE = VoxelShapes.join(CONVEX_BASE, INSIDE, OperatorBoolean.ONLY_FIRST);
    private static final VoxelShape DOWN_SHAPE = VoxelShapes.or(BASE, Block.box(6.0, 0.0, 6.0, 10.0, 4.0, 10.0));
    private static final VoxelShape EAST_SHAPE = VoxelShapes.or(BASE, Block.box(12.0, 4.0, 6.0, 16.0, 8.0, 10.0));
    private static final VoxelShape NORTH_SHAPE = VoxelShapes.or(BASE, Block.box(6.0, 4.0, 0.0, 10.0, 8.0, 4.0));
    private static final VoxelShape SOUTH_SHAPE = VoxelShapes.or(BASE, Block.box(6.0, 4.0, 12.0, 10.0, 8.0, 16.0));
    private static final VoxelShape WEST_SHAPE = VoxelShapes.or(BASE, Block.box(0.0, 4.0, 6.0, 4.0, 8.0, 10.0));
    private static final VoxelShape DOWN_INTERACTION_SHAPE = INSIDE;
    private static final VoxelShape EAST_INTERACTION_SHAPE = VoxelShapes.or(INSIDE, Block.box(12.0, 8.0, 6.0, 16.0, 10.0, 10.0));
    private static final VoxelShape NORTH_INTERACTION_SHAPE = VoxelShapes.or(INSIDE, Block.box(6.0, 8.0, 0.0, 10.0, 10.0, 4.0));
    private static final VoxelShape SOUTH_INTERACTION_SHAPE = VoxelShapes.or(INSIDE, Block.box(6.0, 8.0, 12.0, 10.0, 10.0, 16.0));
    private static final VoxelShape WEST_INTERACTION_SHAPE = VoxelShapes.or(INSIDE, Block.box(0.0, 8.0, 6.0, 4.0, 10.0, 10.0));

    public MapCodec<BlockHopper> codec() {
        return CODEC;
    }

    public BlockHopper(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(FACING, EnumDirection.DOWN)).setValue(ENABLED, true));
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        switch (var0.getValue(FACING)) {
            case DOWN: {
                return DOWN_SHAPE;
            }
            case NORTH: {
                return NORTH_SHAPE;
            }
            case SOUTH: {
                return SOUTH_SHAPE;
            }
            case WEST: {
                return WEST_SHAPE;
            }
            case EAST: {
                return EAST_SHAPE;
            }
        }
        return BASE;
    }

    @Override
    protected VoxelShape getInteractionShape(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        switch (var0.getValue(FACING)) {
            case DOWN: {
                return DOWN_INTERACTION_SHAPE;
            }
            case NORTH: {
                return NORTH_INTERACTION_SHAPE;
            }
            case SOUTH: {
                return SOUTH_INTERACTION_SHAPE;
            }
            case WEST: {
                return WEST_INTERACTION_SHAPE;
            }
            case EAST: {
                return EAST_INTERACTION_SHAPE;
            }
        }
        return INSIDE;
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        EnumDirection var1 = var0.getClickedFace().getOpposite();
        return (IBlockData)((IBlockData)this.defaultBlockState().setValue(FACING, var1.getAxis() == EnumDirection.EnumAxis.Y ? EnumDirection.DOWN : var1)).setValue(ENABLED, true);
    }

    @Override
    public TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        return new TileEntityHopper(var0, var1);
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> getTicker(World var0, IBlockData var1, TileEntityTypes<T> var2) {
        return var0.isClientSide ? null : BlockHopper.createTickerHelper(var2, TileEntityTypes.HOPPER, TileEntityHopper::pushItemsTick);
    }

    @Override
    protected void onPlace(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        if (var3.is(var0.getBlock())) {
            return;
        }
        this.checkPoweredState(var1, var2, var0);
    }

    @Override
    protected EnumInteractionResult useWithoutItem(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, MovingObjectPositionBlock var4) {
        if (var1.isClientSide) {
            return EnumInteractionResult.SUCCESS;
        }
        TileEntity var5 = var1.getBlockEntity(var2);
        if (var5 instanceof TileEntityHopper) {
            var3.openMenu((TileEntityHopper)var5);
            var3.awardStat(StatisticList.INSPECT_HOPPER);
        }
        return EnumInteractionResult.CONSUME;
    }

    @Override
    protected void neighborChanged(IBlockData var0, World var1, BlockPosition var2, Block var3, BlockPosition var4, boolean var5) {
        this.checkPoweredState(var1, var2, var0);
    }

    private void checkPoweredState(World var0, BlockPosition var1, IBlockData var2) {
        boolean var3;
        boolean bl = var3 = !var0.hasNeighborSignal(var1);
        if (var3 != var2.getValue(ENABLED)) {
            var0.setBlock(var1, (IBlockData)var2.setValue(ENABLED, var3), 2);
        }
    }

    @Override
    protected void onRemove(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        InventoryUtils.dropContentsOnDestroy(var0, var3, var1, var2);
        super.onRemove(var0, var1, var2, var3, var4);
    }

    @Override
    protected EnumRenderType getRenderShape(IBlockData var0) {
        return EnumRenderType.MODEL;
    }

    @Override
    protected boolean hasAnalogOutputSignal(IBlockData var0) {
        return true;
    }

    @Override
    protected int getAnalogOutputSignal(IBlockData var0, World var1, BlockPosition var2) {
        return Container.getRedstoneSignalFromBlockEntity(var1.getBlockEntity(var2));
    }

    @Override
    protected IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        return (IBlockData)var0.setValue(FACING, var1.rotate(var0.getValue(FACING)));
    }

    @Override
    protected IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        return var0.rotate(var1.getRotation(var0.getValue(FACING)));
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(FACING, ENABLED);
    }

    @Override
    protected void entityInside(IBlockData var0, World var1, BlockPosition var2, Entity var3) {
        TileEntity var4 = var1.getBlockEntity(var2);
        if (var4 instanceof TileEntityHopper) {
            TileEntityHopper.entityInside(var1, var2, var0, var3, (TileEntityHopper)var4);
        }
    }

    @Override
    protected boolean isPathfindable(IBlockData var0, PathMode var1) {
        return false;
    }
}

