/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockHalfTransparent;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;

public class BlockIce
extends BlockHalfTransparent {
    public static final MapCodec<BlockIce> CODEC = BlockIce.simpleCodec(BlockIce::new);

    public MapCodec<? extends BlockIce> codec() {
        return CODEC;
    }

    public BlockIce(BlockBase.Info blockbase_info) {
        super(blockbase_info);
    }

    public static IBlockData meltsInto() {
        return Blocks.WATER.defaultBlockState();
    }

    @Override
    public void playerDestroy(World world, EntityHuman entityhuman, BlockPosition blockposition, IBlockData iblockdata, @Nullable TileEntity tileentity, ItemStack itemstack) {
        super.playerDestroy(world, entityhuman, blockposition, iblockdata, tileentity, itemstack);
        if (!EnchantmentManager.hasTag(itemstack, EnchantmentTags.PREVENTS_ICE_MELTING)) {
            if (world.dimensionType().ultraWarm()) {
                world.removeBlock(blockposition, false);
                return;
            }
            IBlockData iblockdata1 = world.getBlockState(blockposition.below());
            if (iblockdata1.blocksMotion() || iblockdata1.liquid()) {
                world.setBlockAndUpdate(blockposition, BlockIce.meltsInto());
            }
        }
    }

    @Override
    protected void randomTick(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        if (worldserver.getBrightness(EnumSkyBlock.BLOCK, blockposition) > 11 - iblockdata.getLightBlock(worldserver, blockposition)) {
            this.melt(iblockdata, worldserver, blockposition);
        }
    }

    protected void melt(IBlockData iblockdata, World world, BlockPosition blockposition) {
        if (CraftEventFactory.callBlockFadeEvent(world, blockposition, world.dimensionType().ultraWarm() ? Blocks.AIR.defaultBlockState() : Blocks.WATER.defaultBlockState()).isCancelled()) {
            return;
        }
        if (world.dimensionType().ultraWarm()) {
            world.removeBlock(blockposition, false);
        } else {
            world.setBlockAndUpdate(blockposition, BlockIce.meltsInto());
            world.neighborChanged(blockposition, BlockIce.meltsInto().getBlock(), blockposition);
        }
    }
}

