/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.OptionalInt;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.event.Event;
import org.bukkit.event.block.LeavesDecayEvent;

public class BlockLeaves
extends Block
implements IBlockWaterlogged {
    public static final MapCodec<BlockLeaves> CODEC = BlockLeaves.simpleCodec(BlockLeaves::new);
    public static final int DECAY_DISTANCE = 7;
    public static final BlockStateInteger DISTANCE = BlockProperties.DISTANCE;
    public static final BlockStateBoolean PERSISTENT = BlockProperties.PERSISTENT;
    public static final BlockStateBoolean WATERLOGGED = BlockProperties.WATERLOGGED;
    private static final int TICK_DELAY = 1;

    public MapCodec<? extends BlockLeaves> codec() {
        return CODEC;
    }

    public BlockLeaves(BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(DISTANCE, 7)).setValue(PERSISTENT, false)).setValue(WATERLOGGED, false));
    }

    @Override
    protected VoxelShape getBlockSupportShape(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition) {
        return VoxelShapes.empty();
    }

    @Override
    protected boolean isRandomlyTicking(IBlockData iblockdata) {
        return iblockdata.getValue(DISTANCE) == 7 && iblockdata.getValue(PERSISTENT) == false;
    }

    @Override
    protected void randomTick(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        if (this.decaying(iblockdata)) {
            LeavesDecayEvent event = new LeavesDecayEvent(worldserver.getWorld().getBlockAt(blockposition.getX(), blockposition.getY(), blockposition.getZ()));
            worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled() || worldserver.getBlockState(blockposition).getBlock() != this) {
                return;
            }
            BlockLeaves.dropResources(iblockdata, worldserver, blockposition);
            worldserver.removeBlock(blockposition, false);
        }
    }

    protected boolean decaying(IBlockData iblockdata) {
        return iblockdata.getValue(PERSISTENT) == false && iblockdata.getValue(DISTANCE) == 7;
    }

    @Override
    protected void tick(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        worldserver.setBlock(blockposition, BlockLeaves.updateDistance(iblockdata, worldserver, blockposition), 3);
    }

    @Override
    protected int getLightBlock(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition) {
        return 1;
    }

    @Override
    protected IBlockData updateShape(IBlockData iblockdata, EnumDirection enumdirection, IBlockData iblockdata1, GeneratorAccess generatoraccess, BlockPosition blockposition, BlockPosition blockposition1) {
        int i2;
        if (iblockdata.getValue(WATERLOGGED).booleanValue()) {
            generatoraccess.scheduleTick(blockposition, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(generatoraccess));
        }
        if ((i2 = BlockLeaves.getDistanceAt(iblockdata1) + 1) != 1 || iblockdata.getValue(DISTANCE) != i2) {
            generatoraccess.scheduleTick(blockposition, this, 1);
        }
        return iblockdata;
    }

    private static IBlockData updateDistance(IBlockData iblockdata, GeneratorAccess generatoraccess, BlockPosition blockposition) {
        int i2 = 7;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (EnumDirection enumdirection : EnumDirection.values()) {
            blockposition_mutableblockposition.setWithOffset((BaseBlockPosition)blockposition, enumdirection);
            i2 = Math.min(i2, BlockLeaves.getDistanceAt(generatoraccess.getBlockState(blockposition_mutableblockposition)) + 1);
            if (i2 == 1) break;
        }
        return (IBlockData)iblockdata.setValue(DISTANCE, i2);
    }

    private static int getDistanceAt(IBlockData iblockdata) {
        return BlockLeaves.getOptionalDistanceAt(iblockdata).orElse(7);
    }

    public static OptionalInt getOptionalDistanceAt(IBlockData iblockdata) {
        return iblockdata.is(TagsBlock.LOGS) ? OptionalInt.of(0) : (iblockdata.hasProperty(DISTANCE) ? OptionalInt.of(iblockdata.getValue(DISTANCE)) : OptionalInt.empty());
    }

    @Override
    protected Fluid getFluidState(IBlockData iblockdata) {
        return iblockdata.getValue(WATERLOGGED) != false ? FluidTypes.WATER.getSource(false) : super.getFluidState(iblockdata);
    }

    @Override
    public void animateTick(IBlockData iblockdata, World world, BlockPosition blockposition, RandomSource randomsource) {
        BlockPosition blockposition1;
        IBlockData iblockdata1;
        if (!(!world.isRainingAt(blockposition.above()) || randomsource.nextInt(15) != 1 || (iblockdata1 = world.getBlockState(blockposition1 = blockposition.below())).canOcclude() && iblockdata1.isFaceSturdy(world, blockposition1, EnumDirection.UP))) {
            ParticleUtils.spawnParticleBelow(world, blockposition, randomsource, Particles.DRIPPING_WATER);
        }
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.add(DISTANCE, PERSISTENT, WATERLOGGED);
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext blockactioncontext) {
        Fluid fluid = blockactioncontext.getLevel().getFluidState(blockactioncontext.getClickedPos());
        IBlockData iblockdata = (IBlockData)((IBlockData)this.defaultBlockState().setValue(PERSISTENT, true)).setValue(WATERLOGGED, fluid.getType() == FluidTypes.WATER);
        return BlockLeaves.updateDistance(iblockdata, blockactioncontext.getLevel(), blockactioncontext.getClickedPos());
    }
}

