/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityLectern;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateDirection;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class BlockLectern
extends BlockTileEntity {
    public static final MapCodec<BlockLectern> CODEC = BlockLectern.simpleCodec(BlockLectern::new);
    public static final BlockStateDirection FACING = BlockFacingHorizontal.FACING;
    public static final BlockStateBoolean POWERED = BlockProperties.POWERED;
    public static final BlockStateBoolean HAS_BOOK = BlockProperties.HAS_BOOK;
    public static final VoxelShape SHAPE_BASE = Block.box(0.0, 0.0, 0.0, 16.0, 2.0, 16.0);
    public static final VoxelShape SHAPE_POST = Block.box(4.0, 2.0, 4.0, 12.0, 14.0, 12.0);
    public static final VoxelShape SHAPE_COMMON = VoxelShapes.or(SHAPE_BASE, SHAPE_POST);
    public static final VoxelShape SHAPE_TOP_PLATE = Block.box(0.0, 15.0, 0.0, 16.0, 15.0, 16.0);
    public static final VoxelShape SHAPE_COLLISION = VoxelShapes.or(SHAPE_COMMON, SHAPE_TOP_PLATE);
    public static final VoxelShape SHAPE_WEST = VoxelShapes.or(Block.box(1.0, 10.0, 0.0, 5.333333, 14.0, 16.0), Block.box(5.333333, 12.0, 0.0, 9.666667, 16.0, 16.0), Block.box(9.666667, 14.0, 0.0, 14.0, 18.0, 16.0), SHAPE_COMMON);
    public static final VoxelShape SHAPE_NORTH = VoxelShapes.or(Block.box(0.0, 10.0, 1.0, 16.0, 14.0, 5.333333), Block.box(0.0, 12.0, 5.333333, 16.0, 16.0, 9.666667), Block.box(0.0, 14.0, 9.666667, 16.0, 18.0, 14.0), SHAPE_COMMON);
    public static final VoxelShape SHAPE_EAST = VoxelShapes.or(Block.box(10.666667, 10.0, 0.0, 15.0, 14.0, 16.0), Block.box(6.333333, 12.0, 0.0, 10.666667, 16.0, 16.0), Block.box(2.0, 14.0, 0.0, 6.333333, 18.0, 16.0), SHAPE_COMMON);
    public static final VoxelShape SHAPE_SOUTH = VoxelShapes.or(Block.box(0.0, 10.0, 10.666667, 16.0, 14.0, 15.0), Block.box(0.0, 12.0, 6.333333, 16.0, 16.0, 10.666667), Block.box(0.0, 14.0, 2.0, 16.0, 18.0, 6.333333), SHAPE_COMMON);
    private static final int PAGE_CHANGE_IMPULSE_TICKS = 2;

    public MapCodec<BlockLectern> codec() {
        return CODEC;
    }

    protected BlockLectern(BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(FACING, EnumDirection.NORTH)).setValue(POWERED, false)).setValue(HAS_BOOK, false));
    }

    @Override
    protected EnumRenderType getRenderShape(IBlockData iblockdata) {
        return EnumRenderType.MODEL;
    }

    @Override
    protected VoxelShape getOcclusionShape(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition) {
        return SHAPE_COMMON;
    }

    @Override
    protected boolean useShapeForLightOcclusion(IBlockData iblockdata) {
        return true;
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext blockactioncontext) {
        CustomData customdata;
        World world = blockactioncontext.getLevel();
        ItemStack itemstack = blockactioncontext.getItemInHand();
        EntityHuman entityhuman = blockactioncontext.getPlayer();
        boolean flag = false;
        if (!world.isClientSide && entityhuman != null && entityhuman.canUseGameMasterBlocks() && (customdata = itemstack.getOrDefault(DataComponents.BLOCK_ENTITY_DATA, CustomData.EMPTY)).contains("Book")) {
            flag = true;
        }
        return (IBlockData)((IBlockData)this.defaultBlockState().setValue(FACING, blockactioncontext.getHorizontalDirection().getOpposite())).setValue(HAS_BOOK, flag);
    }

    @Override
    protected VoxelShape getCollisionShape(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return SHAPE_COLLISION;
    }

    @Override
    protected VoxelShape getShape(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        switch (iblockdata.getValue(FACING)) {
            case NORTH: {
                return SHAPE_NORTH;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case EAST: {
                return SHAPE_EAST;
            }
            case WEST: {
                return SHAPE_WEST;
            }
        }
        return SHAPE_COMMON;
    }

    @Override
    protected IBlockData rotate(IBlockData iblockdata, EnumBlockRotation enumblockrotation) {
        return (IBlockData)iblockdata.setValue(FACING, enumblockrotation.rotate(iblockdata.getValue(FACING)));
    }

    @Override
    protected IBlockData mirror(IBlockData iblockdata, EnumBlockMirror enumblockmirror) {
        return iblockdata.rotate(enumblockmirror.getRotation(iblockdata.getValue(FACING)));
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.add(FACING, POWERED, HAS_BOOK);
    }

    @Override
    public TileEntity newBlockEntity(BlockPosition blockposition, IBlockData iblockdata) {
        return new TileEntityLectern(blockposition, iblockdata);
    }

    public static boolean tryPlaceBook(@Nullable EntityLiving entityliving, World world, BlockPosition blockposition, IBlockData iblockdata, ItemStack itemstack) {
        if (!iblockdata.getValue(HAS_BOOK).booleanValue()) {
            if (!world.isClientSide) {
                BlockLectern.placeBook(entityliving, world, blockposition, iblockdata, itemstack);
            }
            return true;
        }
        return false;
    }

    private static void placeBook(@Nullable EntityLiving entityliving, World world, BlockPosition blockposition, IBlockData iblockdata, ItemStack itemstack) {
        TileEntity tileentity = world.getBlockEntity(blockposition);
        if (tileentity instanceof TileEntityLectern) {
            TileEntityLectern tileentitylectern = (TileEntityLectern)tileentity;
            tileentitylectern.setBook(itemstack.consumeAndReturn(1, entityliving));
            BlockLectern.resetBookState(entityliving, world, blockposition, iblockdata, true);
            world.playSound((EntityHuman)null, blockposition, SoundEffects.BOOK_PUT, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    public static void resetBookState(@Nullable Entity entity, World world, BlockPosition blockposition, IBlockData iblockdata, boolean flag) {
        IBlockData iblockdata1 = (IBlockData)((IBlockData)iblockdata.setValue(POWERED, false)).setValue(HAS_BOOK, flag);
        world.setBlock(blockposition, iblockdata1, 3);
        world.gameEvent(GameEvent.BLOCK_CHANGE, blockposition, GameEvent.a.of(entity, iblockdata1));
        BlockLectern.updateBelow(world, blockposition, iblockdata);
    }

    public static void signalPageChange(World world, BlockPosition blockposition, IBlockData iblockdata) {
        BlockLectern.changePowered(world, blockposition, iblockdata, true);
        world.scheduleTick(blockposition, iblockdata.getBlock(), 2);
        world.levelEvent(1043, blockposition, 0);
    }

    private static void changePowered(World world, BlockPosition blockposition, IBlockData iblockdata, boolean flag) {
        world.setBlock(blockposition, (IBlockData)iblockdata.setValue(POWERED, flag), 3);
        BlockLectern.updateBelow(world, blockposition, iblockdata);
    }

    private static void updateBelow(World world, BlockPosition blockposition, IBlockData iblockdata) {
        world.updateNeighborsAt(blockposition.below(), iblockdata.getBlock());
    }

    @Override
    protected void tick(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        BlockLectern.changePowered(worldserver, blockposition, iblockdata, false);
    }

    @Override
    protected void onRemove(IBlockData iblockdata, World world, BlockPosition blockposition, IBlockData iblockdata1, boolean flag) {
        if (!iblockdata.is(iblockdata1.getBlock())) {
            if (iblockdata.getValue(HAS_BOOK).booleanValue()) {
                this.popBook(iblockdata, world, blockposition);
            }
            super.onRemove(iblockdata, world, blockposition, iblockdata1, flag);
            if (iblockdata.getValue(POWERED).booleanValue()) {
                world.updateNeighborsAt(blockposition.below(), this);
            }
        }
    }

    private void popBook(IBlockData iblockdata, World world, BlockPosition blockposition) {
        TileEntity tileentity = world.getBlockEntity(blockposition, false);
        if (tileentity instanceof TileEntityLectern) {
            TileEntityLectern tileentitylectern = (TileEntityLectern)tileentity;
            EnumDirection enumdirection = iblockdata.getValue(FACING);
            ItemStack itemstack = tileentitylectern.getBook().copy();
            if (itemstack.isEmpty()) {
                return;
            }
            float f2 = 0.25f * (float)enumdirection.getStepX();
            float f1 = 0.25f * (float)enumdirection.getStepZ();
            EntityItem entityitem = new EntityItem(world, (double)blockposition.getX() + 0.5 + (double)f2, blockposition.getY() + 1, (double)blockposition.getZ() + 0.5 + (double)f1, itemstack);
            entityitem.setDefaultPickUpDelay();
            world.addFreshEntity(entityitem);
            tileentitylectern.clearContent();
        }
    }

    @Override
    protected boolean isSignalSource(IBlockData iblockdata) {
        return true;
    }

    @Override
    protected int getSignal(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection) {
        return iblockdata.getValue(POWERED) != false ? 15 : 0;
    }

    @Override
    protected int getDirectSignal(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection) {
        return enumdirection == EnumDirection.UP && iblockdata.getValue(POWERED) != false ? 15 : 0;
    }

    @Override
    protected boolean hasAnalogOutputSignal(IBlockData iblockdata) {
        return true;
    }

    @Override
    protected int getAnalogOutputSignal(IBlockData iblockdata, World world, BlockPosition blockposition) {
        TileEntity tileentity;
        if (iblockdata.getValue(HAS_BOOK).booleanValue() && (tileentity = world.getBlockEntity(blockposition)) instanceof TileEntityLectern) {
            return ((TileEntityLectern)tileentity).getRedstoneSignal();
        }
        return 0;
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack itemstack, IBlockData iblockdata, World world, BlockPosition blockposition, EntityHuman entityhuman, EnumHand enumhand, MovingObjectPositionBlock movingobjectpositionblock) {
        return iblockdata.getValue(HAS_BOOK).booleanValue() ? ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION : (itemstack.is(TagsItem.LECTERN_BOOKS) ? (BlockLectern.tryPlaceBook(entityhuman, world, blockposition, iblockdata, itemstack) ? ItemInteractionResult.sidedSuccess(world.isClientSide) : ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION) : (itemstack.isEmpty() && enumhand == EnumHand.MAIN_HAND ? ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION : ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION));
    }

    @Override
    protected EnumInteractionResult useWithoutItem(IBlockData iblockdata, World world, BlockPosition blockposition, EntityHuman entityhuman, MovingObjectPositionBlock movingobjectpositionblock) {
        if (iblockdata.getValue(HAS_BOOK).booleanValue()) {
            if (!world.isClientSide) {
                this.openScreen(world, blockposition, entityhuman);
            }
            return EnumInteractionResult.sidedSuccess(world.isClientSide);
        }
        return EnumInteractionResult.CONSUME;
    }

    @Override
    @Nullable
    protected ITileInventory getMenuProvider(IBlockData iblockdata, World world, BlockPosition blockposition) {
        return iblockdata.getValue(HAS_BOOK) == false ? null : super.getMenuProvider(iblockdata, world, blockposition);
    }

    private void openScreen(World world, BlockPosition blockposition, EntityHuman entityhuman) {
        TileEntity tileentity = world.getBlockEntity(blockposition);
        if (tileentity instanceof TileEntityLectern) {
            entityhuman.openMenu((TileEntityLectern)tileentity);
            entityhuman.awardStat(StatisticList.INTERACT_WITH_LECTERN);
        }
    }

    @Override
    protected boolean isPathfindable(IBlockData iblockdata, PathMode pathmode) {
        return false;
    }
}

