/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.monster.EntitySilverfish;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.IBlockState;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class BlockMonsterEggs
extends Block {
    public static final MapCodec<BlockMonsterEggs> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("host").forGetter(BlockMonsterEggs::getHostBlock), BlockMonsterEggs.propertiesCodec()).apply((Applicative)instance, BlockMonsterEggs::new));
    private final Block hostBlock;
    private static final Map<Block, Block> BLOCK_BY_HOST_BLOCK = Maps.newIdentityHashMap();
    private static final Map<IBlockData, IBlockData> HOST_TO_INFESTED_STATES = Maps.newIdentityHashMap();
    private static final Map<IBlockData, IBlockData> INFESTED_TO_HOST_STATES = Maps.newIdentityHashMap();

    public MapCodec<? extends BlockMonsterEggs> codec() {
        return CODEC;
    }

    public BlockMonsterEggs(Block block, BlockBase.Info blockbase_info) {
        super(blockbase_info.destroyTime(block.defaultDestroyTime() / 2.0f).explosionResistance(0.75f));
        this.hostBlock = block;
        BLOCK_BY_HOST_BLOCK.put(block, this);
    }

    public Block getHostBlock() {
        return this.hostBlock;
    }

    public static boolean isCompatibleHostBlock(IBlockData iblockdata) {
        return BLOCK_BY_HOST_BLOCK.containsKey(iblockdata.getBlock());
    }

    private void spawnInfestation(WorldServer worldserver, BlockPosition blockposition) {
        EntitySilverfish entitysilverfish = EntityTypes.SILVERFISH.create(worldserver);
        if (entitysilverfish != null) {
            entitysilverfish.moveTo((double)blockposition.getX() + 0.5, blockposition.getY(), (double)blockposition.getZ() + 0.5, 0.0f, 0.0f);
            worldserver.addFreshEntity(entitysilverfish, CreatureSpawnEvent.SpawnReason.SILVERFISH_BLOCK);
            entitysilverfish.spawnAnim();
        }
    }

    @Override
    protected void spawnAfterBreak(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, ItemStack itemstack, boolean flag) {
        super.spawnAfterBreak(iblockdata, worldserver, blockposition, itemstack, flag);
        if (worldserver.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS) && !EnchantmentManager.hasTag(itemstack, EnchantmentTags.PREVENTS_INFESTED_SPAWNS)) {
            this.spawnInfestation(worldserver, blockposition);
        }
    }

    public static IBlockData infestedStateByHost(IBlockData iblockdata) {
        return BlockMonsterEggs.getNewStateWithProperties(HOST_TO_INFESTED_STATES, iblockdata, () -> BLOCK_BY_HOST_BLOCK.get(iblockdata.getBlock()).defaultBlockState());
    }

    public IBlockData hostStateByInfested(IBlockData iblockdata) {
        return BlockMonsterEggs.getNewStateWithProperties(INFESTED_TO_HOST_STATES, iblockdata, () -> this.getHostBlock().defaultBlockState());
    }

    private static IBlockData getNewStateWithProperties(Map<IBlockData, IBlockData> map, IBlockData iblockdata, Supplier<IBlockData> supplier) {
        return map.computeIfAbsent(iblockdata, iblockdata1 -> {
            IBlockData iblockdata2 = (IBlockData)supplier.get();
            for (IBlockState<?> iblockstate : iblockdata1.getProperties()) {
                iblockdata2 = iblockdata2.hasProperty(iblockstate) ? (IBlockData)iblockdata2.setValue(iblockstate, iblockdata1.getValue(iblockstate)) : iblockdata2;
            }
            return iblockdata2;
        });
    }
}

