/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockDirectional;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;

public class BlockObserver
extends BlockDirectional {
    public static final MapCodec<BlockObserver> CODEC = BlockObserver.simpleCodec(BlockObserver::new);
    public static final BlockStateBoolean POWERED = BlockProperties.POWERED;

    public MapCodec<BlockObserver> codec() {
        return CODEC;
    }

    public BlockObserver(BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(FACING, EnumDirection.SOUTH)).setValue(POWERED, false));
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.add(FACING, POWERED);
    }

    @Override
    protected IBlockData rotate(IBlockData iblockdata, EnumBlockRotation enumblockrotation) {
        return (IBlockData)iblockdata.setValue(FACING, enumblockrotation.rotate(iblockdata.getValue(FACING)));
    }

    @Override
    protected IBlockData mirror(IBlockData iblockdata, EnumBlockMirror enumblockmirror) {
        return iblockdata.rotate(enumblockmirror.getRotation(iblockdata.getValue(FACING)));
    }

    @Override
    protected void tick(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        if (iblockdata.getValue(POWERED).booleanValue()) {
            if (CraftEventFactory.callRedstoneChange(worldserver, blockposition, 15, 0).getNewCurrent() != 0) {
                return;
            }
            worldserver.setBlock(blockposition, (IBlockData)iblockdata.setValue(POWERED, false), 2);
        } else {
            if (CraftEventFactory.callRedstoneChange(worldserver, blockposition, 0, 15).getNewCurrent() != 15) {
                return;
            }
            worldserver.setBlock(blockposition, (IBlockData)iblockdata.setValue(POWERED, true), 2);
            worldserver.scheduleTick(blockposition, this, 2);
        }
        this.updateNeighborsInFront(worldserver, blockposition, iblockdata);
    }

    @Override
    protected IBlockData updateShape(IBlockData iblockdata, EnumDirection enumdirection, IBlockData iblockdata1, GeneratorAccess generatoraccess, BlockPosition blockposition, BlockPosition blockposition1) {
        if (iblockdata.getValue(FACING) == enumdirection && !iblockdata.getValue(POWERED).booleanValue()) {
            this.startSignal(generatoraccess, blockposition);
        }
        return super.updateShape(iblockdata, enumdirection, iblockdata1, generatoraccess, blockposition, blockposition1);
    }

    private void startSignal(GeneratorAccess generatoraccess, BlockPosition blockposition) {
        if (!generatoraccess.isClientSide() && !generatoraccess.getBlockTicks().hasScheduledTick(blockposition, this)) {
            generatoraccess.scheduleTick(blockposition, this, 2);
        }
    }

    protected void updateNeighborsInFront(World world, BlockPosition blockposition, IBlockData iblockdata) {
        EnumDirection enumdirection = iblockdata.getValue(FACING);
        BlockPosition blockposition1 = blockposition.relative(enumdirection.getOpposite());
        world.neighborChanged(blockposition1, this, blockposition);
        world.updateNeighborsAtExceptFromFacing(blockposition1, this, enumdirection);
    }

    @Override
    protected boolean isSignalSource(IBlockData iblockdata) {
        return true;
    }

    @Override
    protected int getDirectSignal(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection) {
        return iblockdata.getSignal(iblockaccess, blockposition, enumdirection);
    }

    @Override
    protected int getSignal(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection) {
        return iblockdata.getValue(POWERED) != false && iblockdata.getValue(FACING) == enumdirection ? 15 : 0;
    }

    @Override
    protected void onPlace(IBlockData iblockdata, World world, BlockPosition blockposition, IBlockData iblockdata1, boolean flag) {
        if (!iblockdata.is(iblockdata1.getBlock()) && !world.isClientSide() && iblockdata.getValue(POWERED).booleanValue() && !world.getBlockTicks().hasScheduledTick(blockposition, this)) {
            IBlockData iblockdata2 = (IBlockData)iblockdata.setValue(POWERED, false);
            world.setBlock(blockposition, iblockdata2, 18);
            this.updateNeighborsInFront(world, blockposition, iblockdata2);
        }
    }

    @Override
    protected void onRemove(IBlockData iblockdata, World world, BlockPosition blockposition, IBlockData iblockdata1, boolean flag) {
        if (!iblockdata.is(iblockdata1.getBlock()) && !world.isClientSide && iblockdata.getValue(POWERED).booleanValue() && world.getBlockTicks().hasScheduledTick(blockposition, this)) {
            this.updateNeighborsInFront(world, blockposition, (IBlockData)iblockdata.setValue(POWERED, false));
        }
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext blockactioncontext) {
        return (IBlockData)this.defaultBlockState().setValue(FACING, blockactioncontext.getNearestLookingDirection().getOpposite().getOpposite());
    }
}

