/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockMinecartTrackAbstract;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyTrackPosition;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.IBlockState;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;

public class BlockPoweredRail
extends BlockMinecartTrackAbstract {
    public static final MapCodec<BlockPoweredRail> CODEC = BlockPoweredRail.simpleCodec(BlockPoweredRail::new);
    public static final BlockStateEnum<BlockPropertyTrackPosition> SHAPE = BlockProperties.RAIL_SHAPE_STRAIGHT;
    public static final BlockStateBoolean POWERED = BlockProperties.POWERED;

    public MapCodec<BlockPoweredRail> codec() {
        return CODEC;
    }

    protected BlockPoweredRail(BlockBase.Info blockbase_info) {
        super(true, blockbase_info);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(SHAPE, BlockPropertyTrackPosition.NORTH_SOUTH)).setValue(POWERED, false)).setValue(WATERLOGGED, false));
    }

    protected boolean findPoweredRailSignal(World world, BlockPosition blockposition, IBlockData iblockdata, boolean flag, int i2) {
        if (i2 >= 8) {
            return false;
        }
        int j2 = blockposition.getX();
        int k2 = blockposition.getY();
        int l2 = blockposition.getZ();
        boolean flag1 = true;
        BlockPropertyTrackPosition blockpropertytrackposition = iblockdata.getValue(SHAPE);
        switch (blockpropertytrackposition) {
            case NORTH_SOUTH: {
                if (flag) {
                    ++l2;
                    break;
                }
                --l2;
                break;
            }
            case EAST_WEST: {
                if (flag) {
                    --j2;
                    break;
                }
                ++j2;
                break;
            }
            case ASCENDING_EAST: {
                if (flag) {
                    --j2;
                } else {
                    ++j2;
                    ++k2;
                    flag1 = false;
                }
                blockpropertytrackposition = BlockPropertyTrackPosition.EAST_WEST;
                break;
            }
            case ASCENDING_WEST: {
                if (flag) {
                    --j2;
                    ++k2;
                    flag1 = false;
                } else {
                    ++j2;
                }
                blockpropertytrackposition = BlockPropertyTrackPosition.EAST_WEST;
                break;
            }
            case ASCENDING_NORTH: {
                if (flag) {
                    ++l2;
                } else {
                    --l2;
                    ++k2;
                    flag1 = false;
                }
                blockpropertytrackposition = BlockPropertyTrackPosition.NORTH_SOUTH;
                break;
            }
            case ASCENDING_SOUTH: {
                if (flag) {
                    ++l2;
                    ++k2;
                    flag1 = false;
                } else {
                    --l2;
                }
                blockpropertytrackposition = BlockPropertyTrackPosition.NORTH_SOUTH;
            }
        }
        return this.isSameRailWithPower(world, new BlockPosition(j2, k2, l2), flag, i2, blockpropertytrackposition) ? true : flag1 && this.isSameRailWithPower(world, new BlockPosition(j2, k2 - 1, l2), flag, i2, blockpropertytrackposition);
    }

    protected boolean isSameRailWithPower(World world, BlockPosition blockposition, boolean flag, int i2, BlockPropertyTrackPosition blockpropertytrackposition) {
        IBlockData iblockdata = world.getBlockState(blockposition);
        if (!iblockdata.is(this)) {
            return false;
        }
        BlockPropertyTrackPosition blockpropertytrackposition1 = iblockdata.getValue(SHAPE);
        return blockpropertytrackposition == BlockPropertyTrackPosition.EAST_WEST && (blockpropertytrackposition1 == BlockPropertyTrackPosition.NORTH_SOUTH || blockpropertytrackposition1 == BlockPropertyTrackPosition.ASCENDING_NORTH || blockpropertytrackposition1 == BlockPropertyTrackPosition.ASCENDING_SOUTH) ? false : (blockpropertytrackposition == BlockPropertyTrackPosition.NORTH_SOUTH && (blockpropertytrackposition1 == BlockPropertyTrackPosition.EAST_WEST || blockpropertytrackposition1 == BlockPropertyTrackPosition.ASCENDING_EAST || blockpropertytrackposition1 == BlockPropertyTrackPosition.ASCENDING_WEST) ? false : (iblockdata.getValue(POWERED).booleanValue() ? (world.hasNeighborSignal(blockposition) ? true : this.findPoweredRailSignal(world, blockposition, iblockdata, flag, i2 + 1)) : false));
    }

    @Override
    protected void updateState(IBlockData iblockdata, World world, BlockPosition blockposition, Block block) {
        boolean flag1;
        boolean flag = iblockdata.getValue(POWERED);
        boolean bl = flag1 = world.hasNeighborSignal(blockposition) || this.findPoweredRailSignal(world, blockposition, iblockdata, true, 0) || this.findPoweredRailSignal(world, blockposition, iblockdata, false, 0);
        if (flag1 != flag) {
            int power = flag ? 15 : 0;
            int newPower = CraftEventFactory.callRedstoneChange(world, blockposition, power, 15 - power).getNewCurrent();
            if (newPower == power) {
                return;
            }
            world.setBlock(blockposition, (IBlockData)iblockdata.setValue(POWERED, flag1), 3);
            world.updateNeighborsAt(blockposition.below(), this);
            if (iblockdata.getValue(SHAPE).isAscending()) {
                world.updateNeighborsAt(blockposition.above(), this);
            }
        }
    }

    @Override
    public IBlockState<BlockPropertyTrackPosition> getShapeProperty() {
        return SHAPE;
    }

    @Override
    protected IBlockData rotate(IBlockData iblockdata, EnumBlockRotation enumblockrotation) {
        switch (enumblockrotation) {
            case CLOCKWISE_180: {
                switch (iblockdata.getValue(SHAPE)) {
                    case ASCENDING_EAST: {
                        return (IBlockData)iblockdata.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_WEST);
                    }
                    case ASCENDING_WEST: {
                        return (IBlockData)iblockdata.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_EAST);
                    }
                    case ASCENDING_NORTH: {
                        return (IBlockData)iblockdata.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_SOUTH);
                    }
                    case ASCENDING_SOUTH: {
                        return (IBlockData)iblockdata.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_NORTH);
                    }
                    case SOUTH_EAST: {
                        return (IBlockData)iblockdata.setValue(SHAPE, BlockPropertyTrackPosition.NORTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return (IBlockData)iblockdata.setValue(SHAPE, BlockPropertyTrackPosition.NORTH_EAST);
                    }
                    case NORTH_WEST: {
                        return (IBlockData)iblockdata.setValue(SHAPE, BlockPropertyTrackPosition.SOUTH_EAST);
                    }
                    case NORTH_EAST: {
                        return (IBlockData)iblockdata.setValue(SHAPE, BlockPropertyTrackPosition.SOUTH_WEST);
                    }
                }
            }
            case COUNTERCLOCKWISE_90: {
                switch (iblockdata.getValue(SHAPE)) {
                    case NORTH_SOUTH: {
                        return (IBlockData)iblockdata.setValue(SHAPE, BlockPropertyTrackPosition.EAST_WEST);
                    }
                    case EAST_WEST: {
                        return (IBlockData)iblockdata.setValue(SHAPE, BlockPropertyTrackPosition.NORTH_SOUTH);
                    }
                    case ASCENDING_EAST: {
                        return (IBlockData)iblockdata.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_NORTH);
                    }
                    case ASCENDING_WEST: {
                        return (IBlockData)iblockdata.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_SOUTH);
                    }
                    case ASCENDING_NORTH: {
                        return (IBlockData)iblockdata.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_WEST);
                    }
                    case ASCENDING_SOUTH: {
                        return (IBlockData)iblockdata.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_EAST);
                    }
                    case SOUTH_EAST: {
                        return (IBlockData)iblockdata.setValue(SHAPE, BlockPropertyTrackPosition.NORTH_EAST);
                    }
                    case SOUTH_WEST: {
                        return (IBlockData)iblockdata.setValue(SHAPE, BlockPropertyTrackPosition.SOUTH_EAST);
                    }
                    case NORTH_WEST: {
                        return (IBlockData)iblockdata.setValue(SHAPE, BlockPropertyTrackPosition.SOUTH_WEST);
                    }
                    case NORTH_EAST: {
                        return (IBlockData)iblockdata.setValue(SHAPE, BlockPropertyTrackPosition.NORTH_WEST);
                    }
                }
            }
            case CLOCKWISE_90: {
                switch (iblockdata.getValue(SHAPE)) {
                    case NORTH_SOUTH: {
                        return (IBlockData)iblockdata.setValue(SHAPE, BlockPropertyTrackPosition.EAST_WEST);
                    }
                    case EAST_WEST: {
                        return (IBlockData)iblockdata.setValue(SHAPE, BlockPropertyTrackPosition.NORTH_SOUTH);
                    }
                    case ASCENDING_EAST: {
                        return (IBlockData)iblockdata.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_SOUTH);
                    }
                    case ASCENDING_WEST: {
                        return (IBlockData)iblockdata.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_NORTH);
                    }
                    case ASCENDING_NORTH: {
                        return (IBlockData)iblockdata.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_EAST);
                    }
                    case ASCENDING_SOUTH: {
                        return (IBlockData)iblockdata.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_WEST);
                    }
                    case SOUTH_EAST: {
                        return (IBlockData)iblockdata.setValue(SHAPE, BlockPropertyTrackPosition.SOUTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return (IBlockData)iblockdata.setValue(SHAPE, BlockPropertyTrackPosition.NORTH_WEST);
                    }
                    case NORTH_WEST: {
                        return (IBlockData)iblockdata.setValue(SHAPE, BlockPropertyTrackPosition.NORTH_EAST);
                    }
                    case NORTH_EAST: {
                        return (IBlockData)iblockdata.setValue(SHAPE, BlockPropertyTrackPosition.SOUTH_EAST);
                    }
                }
            }
        }
        return iblockdata;
    }

    @Override
    protected IBlockData mirror(IBlockData iblockdata, EnumBlockMirror enumblockmirror) {
        BlockPropertyTrackPosition blockpropertytrackposition = iblockdata.getValue(SHAPE);
        block0 : switch (enumblockmirror) {
            case LEFT_RIGHT: {
                switch (blockpropertytrackposition) {
                    case ASCENDING_NORTH: {
                        return (IBlockData)iblockdata.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_SOUTH);
                    }
                    case ASCENDING_SOUTH: {
                        return (IBlockData)iblockdata.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_NORTH);
                    }
                    case SOUTH_EAST: {
                        return (IBlockData)iblockdata.setValue(SHAPE, BlockPropertyTrackPosition.NORTH_EAST);
                    }
                    case SOUTH_WEST: {
                        return (IBlockData)iblockdata.setValue(SHAPE, BlockPropertyTrackPosition.NORTH_WEST);
                    }
                    case NORTH_WEST: {
                        return (IBlockData)iblockdata.setValue(SHAPE, BlockPropertyTrackPosition.SOUTH_WEST);
                    }
                    case NORTH_EAST: {
                        return (IBlockData)iblockdata.setValue(SHAPE, BlockPropertyTrackPosition.SOUTH_EAST);
                    }
                }
                return super.mirror(iblockdata, enumblockmirror);
            }
            case FRONT_BACK: {
                switch (blockpropertytrackposition) {
                    case ASCENDING_EAST: {
                        return (IBlockData)iblockdata.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_WEST);
                    }
                    case ASCENDING_WEST: {
                        return (IBlockData)iblockdata.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_EAST);
                    }
                    default: {
                        break block0;
                    }
                    case SOUTH_EAST: {
                        return (IBlockData)iblockdata.setValue(SHAPE, BlockPropertyTrackPosition.SOUTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return (IBlockData)iblockdata.setValue(SHAPE, BlockPropertyTrackPosition.SOUTH_EAST);
                    }
                    case NORTH_WEST: {
                        return (IBlockData)iblockdata.setValue(SHAPE, BlockPropertyTrackPosition.NORTH_EAST);
                    }
                    case NORTH_EAST: 
                }
                return (IBlockData)iblockdata.setValue(SHAPE, BlockPropertyTrackPosition.NORTH_WEST);
            }
        }
        return super.mirror(iblockdata, enumblockmirror);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.add(SHAPE, POWERED, WATERLOGGED);
    }
}

