/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockPressurePlateAbstract;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.PluginManager;

public class BlockPressurePlateBinary
extends BlockPressurePlateAbstract {
    public static final MapCodec<BlockPressurePlateBinary> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockSetType.CODEC.fieldOf("block_set_type").forGetter(blockpressureplatebinary -> blockpressureplatebinary.type), BlockPressurePlateBinary.propertiesCodec()).apply((Applicative)instance, BlockPressurePlateBinary::new));
    public static final BlockStateBoolean POWERED = BlockProperties.POWERED;

    public MapCodec<BlockPressurePlateBinary> codec() {
        return CODEC;
    }

    protected BlockPressurePlateBinary(BlockSetType blocksettype, BlockBase.Info blockbase_info) {
        super(blockbase_info, blocksettype);
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(POWERED, false));
    }

    @Override
    protected int getSignalForState(IBlockData iblockdata) {
        return iblockdata.getValue(POWERED) != false ? 15 : 0;
    }

    @Override
    protected IBlockData setSignalForState(IBlockData iblockdata, int i2) {
        return (IBlockData)iblockdata.setValue(POWERED, i2 > 0);
    }

    @Override
    protected int getSignalStrength(World world, BlockPosition blockposition) {
        Class<net.minecraft.world.entity.Entity> oclass = switch (this.type.pressurePlateSensitivity()) {
            case BlockSetType.a.EVERYTHING -> net.minecraft.world.entity.Entity.class;
            case BlockSetType.a.MOBS -> EntityLiving.class;
            default -> throw new MatchException(null, null);
        };
        Class<net.minecraft.world.entity.Entity> oclass1 = oclass;
        for (net.minecraft.world.entity.Entity entity : BlockPressurePlateBinary.getEntities(world, TOUCH_AABB.move(blockposition), oclass)) {
            if (this.getSignalForState(world.getBlockState(blockposition)) == 0) {
                PlayerInteractEvent cancellable;
                CraftWorld bworld = world.getWorld();
                PluginManager manager = world.getCraftServer().getPluginManager();
                if (entity instanceof EntityHuman) {
                    cancellable = CraftEventFactory.callPlayerInteractEvent((EntityHuman)entity, Action.PHYSICAL, blockposition, null, null, null);
                } else {
                    cancellable = new EntityInteractEvent((Entity)entity.getBukkitEntity(), bworld.getBlockAt(blockposition.getX(), blockposition.getY(), blockposition.getZ()));
                    manager.callEvent((Event)((EntityInteractEvent)cancellable));
                }
                if (cancellable.isCancelled()) continue;
            }
            return 15;
        }
        return 0;
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.add(POWERED);
    }
}

