/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockPressurePlateAbstract;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class BlockPressurePlateWeighted
extends BlockPressurePlateAbstract {
    public static final MapCodec<BlockPressurePlateWeighted> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.intRange((int)1, (int)1024).fieldOf("max_weight").forGetter(blockpressureplateweighted -> blockpressureplateweighted.maxWeight), (App)BlockSetType.CODEC.fieldOf("block_set_type").forGetter(blockpressureplateweighted -> blockpressureplateweighted.type), BlockPressurePlateWeighted.propertiesCodec()).apply((Applicative)instance, BlockPressurePlateWeighted::new));
    public static final BlockStateInteger POWER = BlockProperties.POWER;
    private final int maxWeight;

    public MapCodec<BlockPressurePlateWeighted> codec() {
        return CODEC;
    }

    protected BlockPressurePlateWeighted(int i2, BlockSetType blocksettype, BlockBase.Info blockbase_info) {
        super(blockbase_info, blocksettype);
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(POWER, 0));
        this.maxWeight = i2;
    }

    @Override
    protected int getSignalStrength(World world, BlockPosition blockposition) {
        int i2 = 0;
        for (net.minecraft.world.entity.Entity entity : BlockPressurePlateWeighted.getEntities(world, TOUCH_AABB.move(blockposition), net.minecraft.world.entity.Entity.class)) {
            PlayerInteractEvent cancellable;
            if (entity instanceof EntityHuman) {
                cancellable = CraftEventFactory.callPlayerInteractEvent((EntityHuman)entity, Action.PHYSICAL, blockposition, null, null, null);
            } else {
                cancellable = new EntityInteractEvent((Entity)entity.getBukkitEntity(), world.getWorld().getBlockAt(blockposition.getX(), blockposition.getY(), blockposition.getZ()));
                world.getCraftServer().getPluginManager().callEvent((Event)((EntityInteractEvent)cancellable));
            }
            if (cancellable.isCancelled()) continue;
            ++i2;
        }
        if ((i2 = Math.min(i2, this.maxWeight)) > 0) {
            float f2 = (float)Math.min(this.maxWeight, i2) / (float)this.maxWeight;
            return MathHelper.ceil(f2 * 15.0f);
        }
        return 0;
    }

    @Override
    protected int getSignalForState(IBlockData iblockdata) {
        return iblockdata.getValue(POWER);
    }

    @Override
    protected IBlockData setSignalForState(IBlockData iblockdata, int i2) {
        return (IBlockData)iblockdata.setValue(POWER, i2);
    }

    @Override
    protected int getPressedTime() {
        return 10;
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.add(POWER);
    }
}

