/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockDiodeAbstract;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ITileEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityComparator;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyComparatorMode;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.ticks.TickListPriority;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;

public class BlockRedstoneComparator
extends BlockDiodeAbstract
implements ITileEntity {
    public static final MapCodec<BlockRedstoneComparator> CODEC = BlockRedstoneComparator.simpleCodec(BlockRedstoneComparator::new);
    public static final BlockStateEnum<BlockPropertyComparatorMode> MODE = BlockProperties.MODE_COMPARATOR;

    public MapCodec<BlockRedstoneComparator> codec() {
        return CODEC;
    }

    public BlockRedstoneComparator(BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(FACING, EnumDirection.NORTH)).setValue(POWERED, false)).setValue(MODE, BlockPropertyComparatorMode.COMPARE));
    }

    @Override
    protected int getDelay(IBlockData iblockdata) {
        return 2;
    }

    @Override
    public IBlockData updateShape(IBlockData iblockdata, EnumDirection enumdirection, IBlockData iblockdata1, GeneratorAccess generatoraccess, BlockPosition blockposition, BlockPosition blockposition1) {
        return enumdirection == EnumDirection.DOWN && !this.canSurviveOn(generatoraccess, blockposition1, iblockdata1) ? Blocks.AIR.defaultBlockState() : super.updateShape(iblockdata, enumdirection, iblockdata1, generatoraccess, blockposition, blockposition1);
    }

    @Override
    protected int getOutputSignal(IBlockAccess iblockaccess, BlockPosition blockposition, IBlockData iblockdata) {
        TileEntity tileentity = iblockaccess.getBlockEntity(blockposition);
        return tileentity instanceof TileEntityComparator ? ((TileEntityComparator)tileentity).getOutputSignal() : 0;
    }

    private int calculateOutputSignal(World world, BlockPosition blockposition, IBlockData iblockdata) {
        int i2 = this.getInputSignal(world, blockposition, iblockdata);
        if (i2 == 0) {
            return 0;
        }
        int j2 = this.getAlternateSignal(world, blockposition, iblockdata);
        return j2 > i2 ? 0 : (iblockdata.getValue(MODE) == BlockPropertyComparatorMode.SUBTRACT ? i2 - j2 : i2);
    }

    @Override
    protected boolean shouldTurnOn(World world, BlockPosition blockposition, IBlockData iblockdata) {
        int i2 = this.getInputSignal(world, blockposition, iblockdata);
        if (i2 == 0) {
            return false;
        }
        int j2 = this.getAlternateSignal(world, blockposition, iblockdata);
        return i2 > j2 ? true : i2 == j2 && iblockdata.getValue(MODE) == BlockPropertyComparatorMode.COMPARE;
    }

    @Override
    protected int getInputSignal(World world, BlockPosition blockposition, IBlockData iblockdata) {
        int i2 = super.getInputSignal(world, blockposition, iblockdata);
        EnumDirection enumdirection = iblockdata.getValue(FACING);
        BlockPosition blockposition1 = blockposition.relative(enumdirection);
        IBlockData iblockdata1 = world.getBlockState(blockposition1);
        if (iblockdata1.hasAnalogOutputSignal()) {
            i2 = iblockdata1.getAnalogOutputSignal(world, blockposition1);
        } else if (i2 < 15 && iblockdata1.isRedstoneConductor(world, blockposition1)) {
            blockposition1 = blockposition1.relative(enumdirection);
            iblockdata1 = world.getBlockState(blockposition1);
            EntityItemFrame entityitemframe = this.getItemFrame(world, enumdirection, blockposition1);
            int j2 = Math.max(entityitemframe == null ? Integer.MIN_VALUE : entityitemframe.getAnalogOutput(), iblockdata1.hasAnalogOutputSignal() ? iblockdata1.getAnalogOutputSignal(world, blockposition1) : Integer.MIN_VALUE);
            if (j2 != Integer.MIN_VALUE) {
                i2 = j2;
            }
        }
        return i2;
    }

    @Nullable
    private EntityItemFrame getItemFrame(World world, EnumDirection enumdirection, BlockPosition blockposition) {
        List<EntityItemFrame> list = world.getEntitiesOfClass(EntityItemFrame.class, new AxisAlignedBB(blockposition.getX(), blockposition.getY(), blockposition.getZ(), blockposition.getX() + 1, blockposition.getY() + 1, blockposition.getZ() + 1), entityitemframe -> entityitemframe != null && entityitemframe.getDirection() == enumdirection);
        return list.size() == 1 ? list.get(0) : null;
    }

    @Override
    protected EnumInteractionResult useWithoutItem(IBlockData iblockdata, World world, BlockPosition blockposition, EntityHuman entityhuman, MovingObjectPositionBlock movingobjectpositionblock) {
        if (!entityhuman.getAbilities().mayBuild) {
            return EnumInteractionResult.PASS;
        }
        float f2 = (iblockdata = (IBlockData)iblockdata.cycle(MODE)).getValue(MODE) == BlockPropertyComparatorMode.SUBTRACT ? 0.55f : 0.5f;
        world.playSound(entityhuman, blockposition, SoundEffects.COMPARATOR_CLICK, SoundCategory.BLOCKS, 0.3f, f2);
        world.setBlock(blockposition, iblockdata, 2);
        this.refreshOutputState(world, blockposition, iblockdata);
        return EnumInteractionResult.sidedSuccess(world.isClientSide);
    }

    @Override
    protected void checkTickOnNeighbor(World world, BlockPosition blockposition, IBlockData iblockdata) {
        if (!world.getBlockTicks().willTickThisTick(blockposition, this)) {
            int j2;
            int i2 = this.calculateOutputSignal(world, blockposition, iblockdata);
            TileEntity tileentity = world.getBlockEntity(blockposition);
            int n2 = j2 = tileentity instanceof TileEntityComparator ? ((TileEntityComparator)tileentity).getOutputSignal() : 0;
            if (i2 != j2 || iblockdata.getValue(POWERED).booleanValue() != this.shouldTurnOn(world, blockposition, iblockdata)) {
                TickListPriority ticklistpriority = this.shouldPrioritize(world, blockposition, iblockdata) ? TickListPriority.HIGH : TickListPriority.NORMAL;
                world.scheduleTick(blockposition, this, 2, ticklistpriority);
            }
        }
    }

    private void refreshOutputState(World world, BlockPosition blockposition, IBlockData iblockdata) {
        int i2 = this.calculateOutputSignal(world, blockposition, iblockdata);
        TileEntity tileentity = world.getBlockEntity(blockposition);
        int j2 = 0;
        if (tileentity instanceof TileEntityComparator) {
            TileEntityComparator tileentitycomparator = (TileEntityComparator)tileentity;
            j2 = tileentitycomparator.getOutputSignal();
            tileentitycomparator.setOutputSignal(i2);
        }
        if (j2 != i2 || iblockdata.getValue(MODE) == BlockPropertyComparatorMode.COMPARE) {
            boolean flag = this.shouldTurnOn(world, blockposition, iblockdata);
            boolean flag1 = iblockdata.getValue(POWERED);
            if (flag1 && !flag) {
                if (CraftEventFactory.callRedstoneChange(world, blockposition, 15, 0).getNewCurrent() != 0) {
                    return;
                }
                world.setBlock(blockposition, (IBlockData)iblockdata.setValue(POWERED, false), 2);
            } else if (!flag1 && flag) {
                if (CraftEventFactory.callRedstoneChange(world, blockposition, 0, 15).getNewCurrent() != 15) {
                    return;
                }
                world.setBlock(blockposition, (IBlockData)iblockdata.setValue(POWERED, true), 2);
            }
            this.updateNeighborsInFront(world, blockposition, iblockdata);
        }
    }

    @Override
    protected void tick(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        this.refreshOutputState(worldserver, blockposition, iblockdata);
    }

    @Override
    protected boolean triggerEvent(IBlockData iblockdata, World world, BlockPosition blockposition, int i2, int j2) {
        super.triggerEvent(iblockdata, world, blockposition, i2, j2);
        TileEntity tileentity = world.getBlockEntity(blockposition);
        return tileentity != null && tileentity.triggerEvent(i2, j2);
    }

    @Override
    public TileEntity newBlockEntity(BlockPosition blockposition, IBlockData iblockdata) {
        return new TileEntityComparator(blockposition, iblockdata);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.add(FACING, MODE, POWERED);
    }
}

